/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wsspi.cluster.selection.rule;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.cluster.topography.ClusterMemberDescription;
import com.ibm.websphere.cluster.topography.DescriptionKey;
import com.ibm.websphere.cluster.topography.KeyRepository;
import com.ibm.websphere.cluster.topography.KeyRepositoryFactory;
import com.ibm.ws.cluster.ProcessProperties;
import com.ibm.ws.cluster.topography.SelectionClusterMemberDescription;
import com.ibm.wsspi.cluster.ClusterService;
import com.ibm.wsspi.cluster.ClusterServiceFactory;
import com.ibm.wsspi.cluster.Identity;
import com.ibm.wsspi.cluster.selection.rule.DefaultRule;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class LocalHostRule
extends DefaultRule {
    private static final TraceComponent tc = Tr.register(LocalHostRule.class, "WLM", "com.ibm.ws.wlm.resources.WLMNLSMessages");
    private static final KeyRepository keyRepository = KeyRepositoryFactory.getInstance().getKeyRepository();
    private static final ProcessProperties processProps = ProcessProperties.getInstance();
    private static final ClusterService clusterService = ClusterServiceFactory.getClusterService();
    private static final Map scmdDistinction = new HashMap(1);

    public void subset(List identities, StringBuffer reason) {
        super.subset(identities, reason);
        LocalHostRule.match(identities, reason);
    }

    private static void match(List identities, StringBuffer reason) {
        Iterator iter = identities.iterator();
        while (iter.hasNext()) {
            DescriptionKey element = (DescriptionKey)iter.next();
            ClusterMemberDescription member = (ClusterMemberDescription)descMgr.getDescription(element);
            ClusterMemberDescription.Memento cmdMemento = (ClusterMemberDescription.Memento)member.getMemento();
            if (!cmdMemento.isLeaf()) {
                Identity[] subIdentities = clusterService.getMemberIdentities(member.getKey());
                ArrayList<Identity> subList = new ArrayList<Identity>();
                for (int i = 0; i < subIdentities.length; ++i) {
                    subList.add(subIdentities[i]);
                }
                StringBuffer subreason = new StringBuffer();
                LocalHostRule.match(subList, subreason);
                if (!subList.isEmpty()) continue;
                iter.remove();
                reason.append(element + " removed: Children all removed ");
                reason.append(subreason);
                reason.append(' ');
                continue;
            }
            DescriptionKey scmdKey = keyRepository.getDescriptionKey(element, scmdDistinction);
            SelectionClusterMemberDescription scmd = (SelectionClusterMemberDescription)cmdMemento.getExtrinsicData(scmdKey);
            if (scmd == null || ((SelectionClusterMemberDescription.Memento)scmd.getMemento()).getHost().equals(processProps.get("key.virtual.host"))) continue;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Member removed, not host local.", element);
            }
            iter.remove();
            reason.append(element + " removed: Not host local. ");
        }
    }

    static {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "version : ", "1.10 ");
        }
        scmdDistinction.put(SelectionClusterMemberDescription.distinction[0], SelectionClusterMemberDescription.distinction[1]);
    }
}

