/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wsspi.cluster.selection.rule;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.wsspi.cluster.Identity;
import com.ibm.wsspi.cluster.customadvisor.CustomAdvisorConfigListener;
import com.ibm.wsspi.cluster.customadvisor.CustomAdvisorHandler;
import com.ibm.wsspi.cluster.selection.RuleArbitrator;
import com.ibm.wsspi.cluster.selection.rule.DefaultRule;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;

public class AppMemberSelectableRule
extends DefaultRule
implements CustomAdvisorConfigListener {
    private static final TraceComponent tc = Tr.register(AppMemberSelectableRule.class, "WLM", "com.ibm.ws.wlm.resources.WLMNLSMessages");
    private CustomAdvisorHandler customAdvisorHandler;

    public AppMemberSelectableRule(CustomAdvisorHandler caHandler) {
        this.customAdvisorHandler = caHandler;
        this.customAdvisorHandler.getNotifier().registerListener(this);
    }

    public void subset(List identities, StringBuffer reason) {
        Map<Identity, Boolean> usability = this.customAdvisorHandler.getUsabilityMap();
        ListIterator identitiesIter = identities.listIterator();
        while (identitiesIter.hasNext()) {
            Identity memberIdentity = (Identity)identitiesIter.next();
            Boolean value = usability.get(memberIdentity);
            if (value == null || value.booleanValue()) continue;
            identitiesIter.remove();
            reason.append(memberIdentity + " removed: usabilityMap is false");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleNotification() {
        Object object = this.arbitratorMutex;
        synchronized (object) {
            for (RuleArbitrator arbitrator : this.arbitrators) {
                arbitrator.triggerRuleUpdate();
            }
        }
    }

    static {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "version : 1.3");
        }
    }
}

