/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wspolicy.wsdl.internal.subject;

import com.ibm.webservices.component.logging.Tr;
import com.ibm.webservices.component.logging.TraceComponent;
import com.ibm.wspolicy.WSPolicyException;
import com.ibm.wspolicy.datamodel.Policy;
import com.ibm.wspolicy.wsdl.UnknownWSDLElementException;
import com.ibm.wspolicy.wsdl.internal.attachment.WSDLAttachPointIdentifier;
import com.ibm.wspolicy.wsdl.internal.subject.WSDLSubject;
import com.ibm.wspolicy.wsdl.internal.subject.WSDLSubjectIdentifier;
import com.ibm.wspolicy.wsdl.internal.subject.WSDLSubjectType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WSDLSubjectCollection {
    private static final TraceComponent tc = Tr.register(WSDLSubjectCollection.class, "wspolicy4j", "com.ibm.ws.wspolicy.resources.CWPOLMessages");
    private HashMap<WSDLSubjectIdentifier, WSDLSubject> identifier2subject = new HashMap();
    private HashMap<WSDLAttachPointIdentifier, List<WSDLSubject>> attachPoint2subject = new HashMap();
    private HashMap<WSDLSubjectType, List<WSDLSubject>> type2instances = new HashMap();

    public WSDLSubject getSubjectWithIdentifier(WSDLSubjectIdentifier wSDLSubjectIdentifier) throws WSPolicyException {
        WSDLSubject wSDLSubject;
        if (tc.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "getSubjectWithIdentifier", wSDLSubjectIdentifier);
        }
        if ((wSDLSubject = this.identifier2subject.get(wSDLSubjectIdentifier)) == null) {
            if (tc.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "getSubjectWithIdentifier", "UnknownWSDLElementException");
            }
            throw new UnknownWSDLElementException();
        }
        if (tc.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "getSubjectWithIdentifier", wSDLSubject);
        }
        return wSDLSubject;
    }

    public List<WSDLSubject> getSubjectsForAttachpoint(WSDLAttachPointIdentifier wSDLAttachPointIdentifier) {
        if (tc.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "getSubjectsForAttachpoint", wSDLAttachPointIdentifier);
        }
        if (tc.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "getSubjectsForAttachpoint");
        }
        return this.attachPoint2subject.get(wSDLAttachPointIdentifier);
    }

    public List<WSDLSubject> getSubjectsOfType(WSDLSubjectType wSDLSubjectType) {
        if (tc.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "getSubjectsOfType", (Object)wSDLSubjectType);
        }
        if (tc.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "getSubjectsOfType");
        }
        return this.type2instances.get((Object)wSDLSubjectType);
    }

    public void add(WSDLSubject wSDLSubject, WSDLAttachPointIdentifier ... wSDLAttachPointIdentifierArray) {
        if (tc.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "add", new Object[]{wSDLSubject, wSDLAttachPointIdentifierArray});
        }
        this.identifier2subject.put(wSDLSubject.getIdentifier(), wSDLSubject);
        List<WSDLSubject> list = this.type2instances.get((Object)wSDLSubject.getIdentifier().getType());
        if (list == null) {
            list = new ArrayList<WSDLSubject>();
            this.type2instances.put(wSDLSubject.getIdentifier().getType(), list);
        }
        list.add(wSDLSubject);
        for (WSDLAttachPointIdentifier wSDLAttachPointIdentifier : wSDLAttachPointIdentifierArray) {
            List<WSDLSubject> list2 = this.attachPoint2subject.get(wSDLAttachPointIdentifier);
            if (list2 == null) {
                list2 = new ArrayList<WSDLSubject>();
                this.attachPoint2subject.put(wSDLAttachPointIdentifier, list2);
            }
            list2.add(wSDLSubject);
        }
        if (tc.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "add");
        }
    }

    public List<Policy> getAllAttachedPolicies() {
        if (tc.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "getAllAttachedPolicies");
        }
        ArrayList<Policy> arrayList = new ArrayList<Policy>();
        for (WSDLSubject wSDLSubject : this.identifier2subject.values()) {
            arrayList.addAll(wSDLSubject.getPolicies());
        }
        if (tc.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "getAllAttachedPolicies", arrayList);
        }
        return arrayList;
    }

    public boolean hasAttachedPolicy() {
        if (tc.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "hasAttachedPolicy");
        }
        for (WSDLSubject wSDLSubject : this.identifier2subject.values()) {
            if (wSDLSubject.getPolicies().isEmpty()) continue;
            if (tc.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "hasAttachedPolicy", Boolean.TRUE);
            }
            return true;
        }
        if (tc.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "hasAttachedPolicy", Boolean.FALSE);
        }
        return false;
    }
}

