/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wspolicy.wsdl.internal.subject;

import com.ibm.webservices.component.logging.Tr;
import com.ibm.webservices.component.logging.TraceComponent;
import com.ibm.wspolicy.wsdl.internal.attachment.WSDLAttachPointIdentifier;
import com.ibm.wspolicy.wsdl.internal.subject.WSDLSubject;
import com.ibm.wspolicy.wsdl.internal.subject.WSDLSubjectCollection;
import com.ibm.wspolicy.wsdl.internal.subject.WSDLSubjectIdentifier;
import java.util.List;
import java.util.Map;
import javax.wsdl.Binding;
import javax.wsdl.BindingFault;
import javax.wsdl.BindingOperation;
import javax.wsdl.Definition;
import javax.wsdl.Port;
import javax.wsdl.PortType;
import javax.wsdl.Service;

public class DefinitionSubjectProcessor {
    private static final TraceComponent tc = Tr.register(DefinitionSubjectProcessor.class, "wspolicy4j", "com.ibm.ws.wspolicy.resources.CWPOLMessages");
    WSDLSubjectCollection holder = new WSDLSubjectCollection();

    public DefinitionSubjectProcessor(Definition definition) {
        if (tc.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "DefinitionSubjectProcessor", definition);
        }
        Map map = definition.getAllServices();
        for (Service service : map.values()) {
            this.processService(service);
        }
        if (tc.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "DefinitionSubjectProcessor", this);
        }
    }

    private void processService(Service service) {
        if (tc.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "processService", service);
        }
        WSDLSubject wSDLSubject = new WSDLSubject();
        wSDLSubject.setIdentifier(WSDLSubjectIdentifier.createServiceSubjectIdentifier(service.getQName()));
        WSDLAttachPointIdentifier wSDLAttachPointIdentifier = WSDLAttachPointIdentifier.createServiceAttachPoint(service);
        wSDLSubject.getAttachPoints().add(wSDLAttachPointIdentifier);
        this.holder.add(wSDLSubject, wSDLAttachPointIdentifier);
        Map map = service.getPorts();
        for (Port port : map.values()) {
            this.processPort(service, port, wSDLSubject);
        }
        if (tc.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "processService");
        }
    }

    private void processPort(Service service, Port port, WSDLSubject wSDLSubject) {
        if (tc.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "processPort", new Object[]{service, port, wSDLSubject});
        }
        Binding binding = port.getBinding();
        PortType portType = binding.getPortType();
        WSDLSubject wSDLSubject2 = new WSDLSubject();
        wSDLSubject2.setIdentifier(WSDLSubjectIdentifier.createEndpointSubjectIdentifier(service.getQName(), port.getName()));
        wSDLSubject.getChildSubjects().add(wSDLSubject2);
        WSDLAttachPointIdentifier wSDLAttachPointIdentifier = WSDLAttachPointIdentifier.createPortAttachPoint(service, port);
        wSDLSubject2.getAttachPoints().add(wSDLAttachPointIdentifier);
        this.holder.add(wSDLSubject2, wSDLAttachPointIdentifier);
        WSDLAttachPointIdentifier wSDLAttachPointIdentifier2 = WSDLAttachPointIdentifier.createPortTypeAttachPoint(portType);
        wSDLSubject2.getAttachPoints().add(wSDLAttachPointIdentifier2);
        this.holder.add(wSDLSubject2, wSDLAttachPointIdentifier2);
        WSDLAttachPointIdentifier wSDLAttachPointIdentifier3 = WSDLAttachPointIdentifier.createBindingAttachPoint(binding);
        wSDLSubject2.getAttachPoints().add(wSDLAttachPointIdentifier3);
        this.holder.add(wSDLSubject2, wSDLAttachPointIdentifier3);
        List list = binding.getBindingOperations();
        for (BindingOperation bindingOperation : list) {
            this.processBindingOperation(service, port, binding, bindingOperation, wSDLSubject2);
        }
        if (tc.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "processPort");
        }
    }

    private void processBindingOperation(Service service, Port port, Binding binding, BindingOperation bindingOperation, WSDLSubject wSDLSubject) {
        if (tc.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "processBindingOperation", new Object[]{service, port, binding, bindingOperation, wSDLSubject});
        }
        WSDLSubject wSDLSubject2 = new WSDLSubject();
        wSDLSubject2.setIdentifier(WSDLSubjectIdentifier.createOperationSubjectIdentifier(service.getQName(), port.getName(), bindingOperation.getName()));
        wSDLSubject.getChildSubjects().add(wSDLSubject2);
        WSDLAttachPointIdentifier wSDLAttachPointIdentifier = WSDLAttachPointIdentifier.createOperationAttachPoint(binding.getPortType(), bindingOperation.getOperation());
        wSDLSubject2.getAttachPoints().add(wSDLAttachPointIdentifier);
        this.holder.add(wSDLSubject2, wSDLAttachPointIdentifier);
        WSDLAttachPointIdentifier wSDLAttachPointIdentifier2 = WSDLAttachPointIdentifier.createBindingOperationAttachPoint(binding, bindingOperation);
        wSDLSubject2.getAttachPoints().add(wSDLAttachPointIdentifier2);
        this.holder.add(wSDLSubject2, wSDLAttachPointIdentifier2);
        this.processBindingOperationForMessages(service, port, binding, bindingOperation, wSDLSubject2);
        if (tc.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "processBindingOperation");
        }
    }

    private void processBindingOperationForMessages(Service service, Port port, Binding binding, BindingOperation bindingOperation, WSDLSubject wSDLSubject) {
        Object object;
        Object object3;
        Object object4;
        if (tc.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "processBindingOperationForMessages", new Object[]{service, port, binding, bindingOperation, wSDLSubject});
        }
        if (bindingOperation.getBindingInput() != null) {
            object4 = new WSDLSubject();
            ((WSDLSubject)object4).setIdentifier(WSDLSubjectIdentifier.createInputMessageSubjectIdentifier(service.getQName(), port.getName(), bindingOperation.getName()));
            wSDLSubject.getChildSubjects().add((WSDLSubject)object4);
            object3 = WSDLAttachPointIdentifier.createOperationInputAttachPoint(binding.getPortType(), bindingOperation.getOperation());
            ((WSDLSubject)object4).getAttachPoints().add((WSDLAttachPointIdentifier)object3);
            this.holder.add((WSDLSubject)object4, new WSDLAttachPointIdentifier[]{object3});
            WSDLAttachPointIdentifier object22 = WSDLAttachPointIdentifier.createBindingOperationInputAttachPoint(binding, bindingOperation);
            ((WSDLSubject)object4).getAttachPoints().add(object22);
            this.holder.add((WSDLSubject)object4, object22);
            object = WSDLAttachPointIdentifier.createMessageAttachPoint(bindingOperation.getOperation().getInput().getMessage());
            ((WSDLSubject)object4).getAttachPoints().add((WSDLAttachPointIdentifier)object);
            this.holder.add((WSDLSubject)object4, new WSDLAttachPointIdentifier[]{object});
        }
        if (bindingOperation.getBindingOutput() != null) {
            object4 = new WSDLSubject();
            ((WSDLSubject)object4).setIdentifier(WSDLSubjectIdentifier.createOutputMessageSubjectIdentifier(service.getQName(), port.getName(), bindingOperation.getName()));
            wSDLSubject.getChildSubjects().add((WSDLSubject)object4);
            object3 = WSDLAttachPointIdentifier.createOperationOutputAttachPoint(binding.getPortType(), bindingOperation.getOperation());
            ((WSDLSubject)object4).getAttachPoints().add((WSDLAttachPointIdentifier)object3);
            this.holder.add((WSDLSubject)object4, new WSDLAttachPointIdentifier[]{object3});
            WSDLAttachPointIdentifier wSDLAttachPointIdentifier = WSDLAttachPointIdentifier.createBindingOperationOutputAttachPoint(binding, bindingOperation);
            ((WSDLSubject)object4).getAttachPoints().add(wSDLAttachPointIdentifier);
            this.holder.add((WSDLSubject)object4, wSDLAttachPointIdentifier);
            object = WSDLAttachPointIdentifier.createMessageAttachPoint(bindingOperation.getOperation().getOutput().getMessage());
            ((WSDLSubject)object4).getAttachPoints().add((WSDLAttachPointIdentifier)object);
            this.holder.add((WSDLSubject)object4, new WSDLAttachPointIdentifier[]{object});
        }
        object4 = bindingOperation.getBindingFaults();
        for (Map.Entry entry : object4.entrySet()) {
            object = new WSDLSubject();
            ((WSDLSubject)object).setIdentifier(WSDLSubjectIdentifier.createFaultMessageSubjectIdentifier(service.getQName(), port.getName(), bindingOperation.getName(), (String)entry.getKey()));
            wSDLSubject.getChildSubjects().add((WSDLSubject)object);
            WSDLAttachPointIdentifier wSDLAttachPointIdentifier = WSDLAttachPointIdentifier.createOperationFaultAttachPoint(binding.getPortType(), bindingOperation.getOperation(), bindingOperation.getOperation().getFault((String)entry.getKey()));
            ((WSDLSubject)object).getAttachPoints().add(wSDLAttachPointIdentifier);
            this.holder.add((WSDLSubject)object, wSDLAttachPointIdentifier);
            WSDLAttachPointIdentifier wSDLAttachPointIdentifier2 = WSDLAttachPointIdentifier.createBindingOperationFaultAttachPoint(binding, bindingOperation, (BindingFault)entry.getValue());
            ((WSDLSubject)object).getAttachPoints().add(wSDLAttachPointIdentifier2);
            this.holder.add((WSDLSubject)object, wSDLAttachPointIdentifier2);
            WSDLAttachPointIdentifier wSDLAttachPointIdentifier3 = WSDLAttachPointIdentifier.createMessageAttachPoint(bindingOperation.getOperation().getFault((String)entry.getKey()).getMessage());
            ((WSDLSubject)object).getAttachPoints().add(wSDLAttachPointIdentifier3);
            this.holder.add((WSDLSubject)object, wSDLAttachPointIdentifier3);
        }
        if (tc.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "processBindingOperationForMessages");
        }
    }

    public WSDLSubjectCollection getWSDLSubjectCollection() {
        if (tc.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "getWSDLSubjectCollection");
        }
        if (tc.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "getWSDLSubjectCollection", this.holder);
        }
        return this.holder;
    }
}

