/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wspolicy.wsdl.internal.attachment;

import com.ibm.webservices.component.logging.Tr;
import com.ibm.webservices.component.logging.TraceComponent;
import com.ibm.wspolicy.datamodel.Policy;
import com.ibm.wspolicy.datamodel.PolicyReference;
import com.ibm.wspolicy.factory.WSPolicyFactory;
import com.ibm.wspolicy.wsdl.internal.attachment.DefinitionAttachmentProcessor;
import com.ibm.wspolicy.wsdl.internal.attachment.WSDLAttachPointIdentifier;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WSDLPolicyAttachmentHolder {
    private static final TraceComponent tc = Tr.register(WSDLPolicyAttachmentHolder.class, "wspolicy4j", "com.ibm.ws.wspolicy.resources.CWPOLMessages");
    HashMap<WSDLAttachPointIdentifier, Policy> attachmentMap = new HashMap();
    HashMap<String, Policy> localReferenceMap = new HashMap();
    HashMap<String, Policy> globalReferenceMap = new HashMap();
    HashMap<Policy, Element> policyElementMap = new HashMap();

    public Map<Policy, Element> getPolicyElementMap() {
        if (tc.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "getPolicyElementMap");
        }
        if (tc.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "getPolicyElementMap", this.policyElementMap);
        }
        return this.policyElementMap;
    }

    public Map<String, Policy> getLocalReferenceMap() {
        if (tc.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "getLocalReferenceMap");
        }
        if (tc.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "getLocalReferenceMap", this.localReferenceMap);
        }
        return this.localReferenceMap;
    }

    public Map<String, Policy> getGlobalReferenceMap() {
        if (tc.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "getGlobalReferenceMap");
        }
        if (tc.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "getGlobalReferenceMap", this.globalReferenceMap);
        }
        return this.globalReferenceMap;
    }

    public void addAttachment(WSDLAttachPointIdentifier wSDLAttachPointIdentifier, Policy policy) {
        Policy policy2;
        if (tc.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "addAttachment", new Object[]{wSDLAttachPointIdentifier, policy});
        }
        if ((policy2 = this.attachmentMap.get(wSDLAttachPointIdentifier)) == null) {
            policy2 = WSPolicyFactory.newInstance().createDataModelFactory().createPolicy();
            this.attachmentMap.put(wSDLAttachPointIdentifier, policy2);
        }
        policy2.getChildren().add(policy);
        this.addUnreferencedPolicy(policy);
        if (tc.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "addAttachment");
        }
    }

    public void addElementMapping(Policy policy, Element element) {
        if (tc.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "addElementMapping", new Object[]{policy, element});
        }
        this.policyElementMap.put(policy, element);
        if (tc.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "addElementMapping");
        }
    }

    public void addUnreferencedPolicy(Policy policy) {
        String string;
        if (tc.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "addUnreferencedPolicy", policy);
        }
        if ((string = policy.getName()) != null && string.length() != 0) {
            this.globalReferenceMap.put(string, policy);
        } else {
            string = policy.getOtherAttributes().get(DefinitionAttachmentProcessor.WSU_ID);
            if (string == null || string.length() == 0) {
                string = policy.getOtherAttributes().get(DefinitionAttachmentProcessor.XML_ID);
            }
            this.localReferenceMap.put("#" + string, policy);
        }
        if (tc.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "addUnreferencedPolicy");
        }
    }

    public void addAttachment(WSDLAttachPointIdentifier wSDLAttachPointIdentifier, PolicyReference policyReference) {
        Policy policy;
        if (tc.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "addAttachment", new Object[]{wSDLAttachPointIdentifier, policyReference});
        }
        if ((policy = this.attachmentMap.get(wSDLAttachPointIdentifier)) == null) {
            policy = WSPolicyFactory.newInstance().createDataModelFactory().createPolicy();
            this.attachmentMap.put(wSDLAttachPointIdentifier, policy);
        }
        policy.getChildren().add(policyReference);
        if (tc.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "addAttachment");
        }
    }

    public Collection<Policy> getAllAttachedPolicies() {
        if (tc.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "getAllAttachedPolicies");
        }
        if (tc.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "getAllAttachedPolicies");
        }
        return this.attachmentMap.values();
    }

    public Policy getAttachment(WSDLAttachPointIdentifier wSDLAttachPointIdentifier) {
        if (tc.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "getAttachment", wSDLAttachPointIdentifier);
        }
        if (tc.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "getAttachment");
        }
        return this.attachmentMap.get(wSDLAttachPointIdentifier);
    }

    public Collection<WSDLAttachPointIdentifier> getAttachPoints() {
        if (tc.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "getAttachPoints");
        }
        if (tc.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "getAttachPoints");
        }
        return this.attachmentMap.keySet();
    }
}

