/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wspolicy.wsdl.internal.attachment;

import com.ibm.webservices.component.logging.Tr;
import com.ibm.webservices.component.logging.TraceComponent;
import com.ibm.wspolicy.datamodel.Policy;
import com.ibm.wspolicy.datamodel.PolicyElement;
import com.ibm.wspolicy.datamodel.PolicyReference;
import com.ibm.wspolicy.factory.WSDigestValidator;
import com.ibm.wspolicy.factory.WSPolicyFactory;
import com.ibm.wspolicy.processor.PolicyProcessor;
import com.ibm.wspolicy.processor.PolicyReferenceResolver;
import com.ibm.wspolicy.wsdl.internal.attachment.WSDLAttachPointIdentifier;
import com.ibm.wspolicy.wsdl.internal.attachment.WSDLPolicyAttachmentHolder;
import com.ibm.wspolicy.xml.ElementReader;
import com.ibm.wspolicy.xml.ElementReaderException;
import com.ibm.wspolicy.xml.UnsupportedPolicyNamespaceException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.wsdl.Binding;
import javax.wsdl.BindingFault;
import javax.wsdl.BindingOperation;
import javax.wsdl.Definition;
import javax.wsdl.Fault;
import javax.wsdl.Import;
import javax.wsdl.Message;
import javax.wsdl.Operation;
import javax.wsdl.Port;
import javax.wsdl.PortType;
import javax.wsdl.Service;
import javax.wsdl.extensions.AttributeExtensible;
import javax.wsdl.extensions.ElementExtensible;
import javax.wsdl.extensions.ExtensibilityElement;
import javax.wsdl.extensions.UnknownExtensibilityElement;
import javax.xml.namespace.QName;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefinitionAttachmentProcessor {
    private static final TraceComponent tc = Tr.register(DefinitionAttachmentProcessor.class, "wspolicy4j", "com.ibm.ws.wspolicy.resources.CWPOLMessages");
    public static final QName WSP_POLICY = new QName("http://www.w3.org/ns/ws-policy", "Policy");
    public static final QName WSP_POLICYREFERENCE = new QName("http://www.w3.org/ns/ws-policy", "PolicyReference");
    public static final QName WSP_POLICY_URIS = new QName("http://www.w3.org/ns/ws-policy", "PolicyURIs");
    public static final QName WSU_ID = new QName("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd", "Id");
    public static final QName XML_ID = new QName("http://www.w3.org/XML/1998/namespace", "id");
    private WSPolicyFactory wpf = WSPolicyFactory.newInstance();

    public List<WSDLPolicyAttachmentHolder> buildHolders(Definition definition) throws ElementReaderException {
        if (tc.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "buildHolders", definition);
        }
        ArrayList<WSDLPolicyAttachmentHolder> arrayList = new ArrayList<WSDLPolicyAttachmentHolder>();
        arrayList.add(this.buildHolderForSingleDefinition(definition));
        Collection collection = definition.getImports().values();
        for (List list : collection) {
            for (Import import_ : list) {
                arrayList.add(this.buildHolderForSingleDefinition(import_.getDefinition()));
            }
        }
        if (tc.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "buildHolders", arrayList);
        }
        return arrayList;
    }

    private WSDLPolicyAttachmentHolder buildHolderForSingleDefinition(Definition definition) throws ElementReaderException {
        Collection collection;
        Object object;
        Object object2;
        Iterator iterator;
        Object object3;
        Object object4;
        Iterator iterator22;
        Object object52;
        Collection collection2;
        if (tc.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "buildHolderForSingleDefinition", definition);
        }
        WSDLPolicyAttachmentHolder wSDLPolicyAttachmentHolder = new WSDLPolicyAttachmentHolder();
        ElementReader<Element> elementReader = this.wpf.getReader(Element.class);
        List list = definition.getExtensibilityElements();
        Map<PolicyElement, Element> map = this.getPoliciesAndReferences(list, elementReader);
        for (Map.Entry<PolicyElement, Element> object62 : map.entrySet()) {
            if (!(object62.getKey() instanceof Policy)) continue;
            wSDLPolicyAttachmentHolder.addUnreferencedPolicy((Policy)object62.getKey());
            wSDLPolicyAttachmentHolder.addElementMapping((Policy)object62.getKey(), object62.getValue());
        }
        Collection collection3 = definition.getServices().values();
        Iterator iterator3 = collection3.iterator();
        while (iterator3.hasNext()) {
            collection2 = (Service)iterator3.next();
            object52 = WSDLAttachPointIdentifier.createServiceAttachPoint((Service)((Object)collection2));
            this.processExtensibilityElements((ElementExtensible)((Object)collection2), (WSDLAttachPointIdentifier)object52, wSDLPolicyAttachmentHolder, elementReader);
            iterator22 = collection2.getPorts().values();
            object4 = iterator22.iterator();
            while (object4.hasNext()) {
                object3 = (Port)object4.next();
                iterator = WSDLAttachPointIdentifier.createPortAttachPoint(collection2, (Port)object3);
                this.processExtensibilityElements((ElementExtensible)object3, (WSDLAttachPointIdentifier)((Object)iterator), wSDLPolicyAttachmentHolder, elementReader);
            }
        }
        Collection collection4 = definition.getBindings().values();
        for (Object object52 : collection4) {
            iterator22 = WSDLAttachPointIdentifier.createBindingAttachPoint((Binding)object52);
            this.processExtensibilityElements((ElementExtensible)object52, (WSDLAttachPointIdentifier)((Object)iterator22), wSDLPolicyAttachmentHolder, elementReader);
            object4 = object52.getBindingOperations();
            object3 = object4.iterator();
            while (object3.hasNext()) {
                iterator = (BindingOperation)object3.next();
                object2 = WSDLAttachPointIdentifier.createBindingOperationAttachPoint((Binding)object52, (BindingOperation)((Object)iterator));
                this.processExtensibilityElements((ElementExtensible)((Object)iterator), (WSDLAttachPointIdentifier)object2, wSDLPolicyAttachmentHolder, elementReader);
                if (iterator.getBindingInput() != null) {
                    object = WSDLAttachPointIdentifier.createBindingOperationInputAttachPoint((Binding)object52, iterator);
                    this.processExtensibilityElements(iterator.getBindingInput(), (WSDLAttachPointIdentifier)object, wSDLPolicyAttachmentHolder, elementReader);
                }
                if (iterator.getBindingOutput() != null) {
                    object = WSDLAttachPointIdentifier.createBindingOperationOutputAttachPoint((Binding)object52, iterator);
                    this.processExtensibilityElements(iterator.getBindingOutput(), (WSDLAttachPointIdentifier)object, wSDLPolicyAttachmentHolder, elementReader);
                }
                object = iterator.getBindingFaults().values();
                collection = object.iterator();
                while (collection.hasNext()) {
                    BindingFault bindingFault = (BindingFault)collection.next();
                    Object object6 = WSDLAttachPointIdentifier.createBindingOperationFaultAttachPoint((Binding)object52, iterator, bindingFault);
                    this.processExtensibilityElements(bindingFault, (WSDLAttachPointIdentifier)object6, wSDLPolicyAttachmentHolder, elementReader);
                }
            }
        }
        collection2 = definition.getPortTypes().values();
        for (Iterator iterator22 : collection2) {
            object4 = WSDLAttachPointIdentifier.createPortTypeAttachPoint((PortType)((Object)iterator22));
            this.processExtensibilityElements((ElementExtensible)((Object)iterator22), (WSDLAttachPointIdentifier)object4, wSDLPolicyAttachmentHolder, elementReader);
            this.processExtensibilityAttributes((AttributeExtensible)((Object)iterator22), (WSDLAttachPointIdentifier)object4, wSDLPolicyAttachmentHolder);
            object3 = iterator22.getOperations();
            iterator = object3.iterator();
            while (iterator.hasNext()) {
                object2 = (Operation)iterator.next();
                object = WSDLAttachPointIdentifier.createOperationAttachPoint(iterator22, (Operation)object2);
                this.processExtensibilityElements((ElementExtensible)object2, (WSDLAttachPointIdentifier)object, wSDLPolicyAttachmentHolder, elementReader);
                if (object2.getInput() != null) {
                    collection = WSDLAttachPointIdentifier.createOperationInputAttachPoint(iterator22, (Operation)object2);
                    this.processExtensibilityElements(object2.getInput(), (WSDLAttachPointIdentifier)((Object)collection), wSDLPolicyAttachmentHolder, elementReader);
                    this.processExtensibilityAttributes(object2.getInput(), (WSDLAttachPointIdentifier)((Object)collection), wSDLPolicyAttachmentHolder);
                }
                if (object2.getOutput() != null) {
                    collection = WSDLAttachPointIdentifier.createOperationOutputAttachPoint(iterator22, (Operation)object2);
                    this.processExtensibilityElements(object2.getOutput(), (WSDLAttachPointIdentifier)((Object)collection), wSDLPolicyAttachmentHolder, elementReader);
                    this.processExtensibilityAttributes(object2.getOutput(), (WSDLAttachPointIdentifier)((Object)collection), wSDLPolicyAttachmentHolder);
                }
                collection = object2.getFaults().values();
                for (Object object6 : collection) {
                    WSDLAttachPointIdentifier wSDLAttachPointIdentifier = WSDLAttachPointIdentifier.createOperationFaultAttachPoint(iterator22, (Operation)object2, (Fault)object6);
                    this.processExtensibilityElements((ElementExtensible)object6, wSDLAttachPointIdentifier, wSDLPolicyAttachmentHolder, elementReader);
                    this.processExtensibilityAttributes((AttributeExtensible)object6, wSDLAttachPointIdentifier, wSDLPolicyAttachmentHolder);
                }
            }
        }
        object52 = definition.getMessages().values();
        iterator22 = object52.iterator();
        while (iterator22.hasNext()) {
            object4 = (Message)iterator22.next();
            object3 = WSDLAttachPointIdentifier.createMessageAttachPoint((Message)object4);
            this.processExtensibilityElements((ElementExtensible)object4, (WSDLAttachPointIdentifier)object3, wSDLPolicyAttachmentHolder, elementReader);
        }
        if (tc.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "buildHolderForSingleDefinition", wSDLPolicyAttachmentHolder);
        }
        return wSDLPolicyAttachmentHolder;
    }

    private void processExtensibilityElements(ElementExtensible elementExtensible, WSDLAttachPointIdentifier wSDLAttachPointIdentifier, WSDLPolicyAttachmentHolder wSDLPolicyAttachmentHolder, ElementReader<Element> elementReader) throws ElementReaderException {
        if (tc.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "processExtensibilityElements", new Object[]{elementExtensible, wSDLAttachPointIdentifier, wSDLPolicyAttachmentHolder, elementReader});
        }
        List list = elementExtensible.getExtensibilityElements();
        Map<PolicyElement, Element> map = this.getPoliciesAndReferences(list, elementReader);
        for (Map.Entry<PolicyElement, Element> entry : map.entrySet()) {
            if (entry.getKey() instanceof Policy) {
                wSDLPolicyAttachmentHolder.addAttachment(wSDLAttachPointIdentifier, (Policy)entry.getKey());
                wSDLPolicyAttachmentHolder.addElementMapping((Policy)entry.getKey(), entry.getValue());
                continue;
            }
            if (!(entry.getKey() instanceof PolicyReference)) continue;
            wSDLPolicyAttachmentHolder.addAttachment(wSDLAttachPointIdentifier, (PolicyReference)entry.getKey());
        }
        if (tc.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "processExtensibilityElements");
        }
    }

    private Map<PolicyElement, Element> getPoliciesAndReferences(List<ExtensibilityElement> list, ElementReader<Element> elementReader) throws ElementReaderException {
        if (tc.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "getPoliciesAndReferences", new Object[]{list, elementReader});
        }
        HashMap<PolicyElement, Element> hashMap = new HashMap<PolicyElement, Element>();
        for (ExtensibilityElement extensibilityElement : list) {
            if (!(extensibilityElement instanceof UnknownExtensibilityElement)) continue;
            if (WSP_POLICY.equals(extensibilityElement.getElementType()) || WSP_POLICYREFERENCE.equals(extensibilityElement.getElementType())) {
                Element element = ((UnknownExtensibilityElement)extensibilityElement).getElement();
                PolicyElement policyElement = elementReader.read(element);
                hashMap.put(policyElement, element);
            }
            if (extensibilityElement.getElementType() == null || extensibilityElement.getElementType().getNamespaceURI() == null || !extensibilityElement.getElementType().getNamespaceURI().equals("http://schemas.xmlsoap.org/ws/2004/09/policy")) continue;
            throw new UnsupportedPolicyNamespaceException();
        }
        if (tc.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "getPoliciesAndReferences", hashMap);
        }
        return hashMap;
    }

    private void processExtensibilityAttributes(AttributeExtensible attributeExtensible, WSDLAttachPointIdentifier wSDLAttachPointIdentifier, WSDLPolicyAttachmentHolder wSDLPolicyAttachmentHolder) {
        if (tc.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "processExtensibilityAttributes", new Object[]{attributeExtensible, wSDLAttachPointIdentifier, wSDLPolicyAttachmentHolder});
        }
        ArrayList<Object> arrayList = new ArrayList<Object>();
        Object object = attributeExtensible.getExtensionAttribute(WSP_POLICY_URIS);
        if (object instanceof String) {
            for (String string : ((String)object).split(" ")) {
                arrayList.add(string);
            }
        } else if (object instanceof List) {
            for (Object e : (List)object) {
                if (!(e instanceof String)) continue;
                arrayList.add((String)e);
            }
        } else if (object instanceof QName) {
            QName qName = (QName)object;
            for (String string : qName.getLocalPart().split(" ")) {
                arrayList.add(string);
            }
        } else if (object != null && tc.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "processExtensibilityAttributes found attribute of unexpected type ", object);
        }
        if (arrayList.size() > 0) {
            for (String string : arrayList) {
                PolicyReference policyReference = WSPolicyFactory.newInstance().createDataModelFactory().createPolicyReference();
                policyReference.setURI(string);
                wSDLPolicyAttachmentHolder.addAttachment(wSDLAttachPointIdentifier, policyReference);
            }
        }
        if (tc.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "processExtensibilityAttributes");
        }
    }

    public Map<WSDLAttachPointIdentifier, Policy> buildPolicyAttachmentMap(Definition definition, Map<Policy, Set<PolicyReference>> map) throws ElementReaderException {
        if (tc.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "buildPolicyAttachmentMap", definition);
        }
        List<WSDLPolicyAttachmentHolder> list = this.buildHolders(definition);
        PolicyProcessor policyProcessor = this.wpf.createWSPolicyProcessor();
        MultiDocumentReferenceResolver multiDocumentReferenceResolver = new MultiDocumentReferenceResolver(list);
        for (WSDLPolicyAttachmentHolder object : list) {
            SingleDocumentReferenceResolver singleDocumentReferenceResolver = new SingleDocumentReferenceResolver(object);
            for (Policy policy : object.getAllAttachedPolicies()) {
                HashSet<PolicyReference> hashSet;
                boolean bl = policyProcessor.resolvePolicyReferences(policy, hashSet = new HashSet<PolicyReference>(), multiDocumentReferenceResolver, singleDocumentReferenceResolver);
                if (bl) continue;
                map.put(policy, hashSet);
            }
        }
        HashMap hashMap = new HashMap();
        for (WSDLPolicyAttachmentHolder wSDLPolicyAttachmentHolder : list) {
            for (WSDLAttachPointIdentifier wSDLAttachPointIdentifier : wSDLPolicyAttachmentHolder.getAttachPoints()) {
                hashMap.put(wSDLAttachPointIdentifier, wSDLPolicyAttachmentHolder.getAttachment(wSDLAttachPointIdentifier));
            }
        }
        if (tc.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "buildPolicyAttachmentMap", hashMap);
        }
        return hashMap;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class SingleDocumentReferenceResolver
    implements PolicyReferenceResolver {
        private final Map<String, Policy> referenceMap = new HashMap<String, Policy>();
        private final Map<Policy, Element> policyEltMap = new HashMap<Policy, Element>();
        private final Set<String> failedRefs = new HashSet<String>();

        public SingleDocumentReferenceResolver(WSDLPolicyAttachmentHolder wSDLPolicyAttachmentHolder) {
            this.referenceMap.putAll(wSDLPolicyAttachmentHolder.getLocalReferenceMap());
        }

        @Override
        public Policy resolveReference(WSPolicyFactory wSPolicyFactory, PolicyReference policyReference) {
            Policy policy = this.referenceMap.get(policyReference.getURI());
            if (policy == null) {
                if (policyReference.getDigest() != null && policyReference.getDigest().trim().length() > 0) {
                    Element element = this.policyEltMap.get(policy);
                    WSDigestValidator wSDigestValidator = wSPolicyFactory.getDigestValidator(policyReference.getDigestAlgorithm());
                    try {
                        if (wSDigestValidator == null || !wSDigestValidator.validate(policyReference.getDigest(), element)) {
                            policy = null;
                        }
                    }
                    catch (RuntimeException runtimeException) {
                        policy = null;
                    }
                }
                if (policy == null) {
                    this.failedRefs.add("*" + policyReference.getURI());
                }
            } else {
                this.failedRefs.add(policyReference.getURI());
            }
            return policy;
        }

        public Set<String> getFailedReferences() {
            return this.failedRefs;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class MultiDocumentReferenceResolver
    implements PolicyReferenceResolver {
        private final Map<String, Policy> globalMap = new HashMap<String, Policy>();
        private final Map<Policy, Element> policyEltMap = new HashMap<Policy, Element>();
        private final Set<String> failedRefs = new HashSet<String>();

        public MultiDocumentReferenceResolver(List<WSDLPolicyAttachmentHolder> list) {
            for (WSDLPolicyAttachmentHolder wSDLPolicyAttachmentHolder : list) {
                this.globalMap.putAll(wSDLPolicyAttachmentHolder.getGlobalReferenceMap());
                this.policyEltMap.putAll(wSDLPolicyAttachmentHolder.getPolicyElementMap());
            }
        }

        @Override
        public Policy resolveReference(WSPolicyFactory wSPolicyFactory, PolicyReference policyReference) {
            Policy policy = this.globalMap.get(policyReference.getURI());
            if (policy == null) {
                if (policyReference.getDigest() != null && policyReference.getDigest().trim().length() > 0) {
                    Element element = this.policyEltMap.get(policy);
                    WSDigestValidator wSDigestValidator = wSPolicyFactory.getDigestValidator(policyReference.getDigestAlgorithm());
                    try {
                        if (wSDigestValidator == null || !wSDigestValidator.validate(policyReference.getDigest(), element)) {
                            policy = null;
                        }
                    }
                    catch (RuntimeException runtimeException) {
                        policy = null;
                    }
                }
                if (policy == null) {
                    this.failedRefs.add("*" + policyReference.getURI());
                }
            } else {
                this.failedRefs.add(policyReference.getURI());
            }
            return policy;
        }

        public Set<String> getFailedReferences() {
            return this.failedRefs;
        }
    }
}

