/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wspolicy.wsdl.internal;

import com.ibm.webservices.component.logging.Tr;
import com.ibm.webservices.component.logging.TraceComponent;
import com.ibm.wspolicy.WSPolicyException;
import com.ibm.wspolicy.datamodel.Policy;
import com.ibm.wspolicy.datamodel.PolicyReference;
import com.ibm.wspolicy.factory.WSPolicyFactory;
import com.ibm.wspolicy.processor.PolicyProcessor;
import com.ibm.wspolicy.wsdl.WSDLPolicyModel;
import com.ibm.wspolicy.wsdl.WSDLProcessor;
import com.ibm.wspolicy.wsdl.internal.WSDLPolicyModelImpl;
import com.ibm.wspolicy.wsdl.internal.attachment.DefinitionAttachmentProcessor;
import com.ibm.wspolicy.wsdl.internal.attachment.WSDLAttachPointIdentifier;
import com.ibm.wspolicy.wsdl.internal.subject.DefinitionSubjectProcessor;
import com.ibm.wspolicy.wsdl.internal.subject.WSDLSubject;
import com.ibm.wspolicy.wsdl.internal.subject.WSDLSubjectCollection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.wsdl.Definition;
import javax.xml.namespace.QName;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WSDLProcessorImpl
implements WSDLProcessor {
    private static final TraceComponent tc = Tr.register(WSDLProcessorImpl.class, "wspolicy4j", "com.ibm.ws.wspolicy.resources.CWPOLMessages");
    WSPolicyFactory wsPolicyFactory;

    public WSDLProcessorImpl(WSPolicyFactory wSPolicyFactory) {
        if (tc.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "WSDLProcessorImpl", wSPolicyFactory);
        }
        this.wsPolicyFactory = wSPolicyFactory;
        if (tc.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "WSDLProcessorImpl", wSPolicyFactory);
        }
    }

    @Override
    public WSDLPolicyModel buildWSDLPolicyModel(Definition definition) throws WSPolicyException {
        if (tc.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "buildWSDLPolicyModel", definition);
        }
        WSDLSubjectCollection wSDLSubjectCollection = new DefinitionSubjectProcessor(definition).getWSDLSubjectCollection();
        HashMap<Policy, Set<PolicyReference>> hashMap = new HashMap<Policy, Set<PolicyReference>>();
        Map<WSDLAttachPointIdentifier, Policy> map = new DefinitionAttachmentProcessor().buildPolicyAttachmentMap(definition, hashMap);
        for (Map.Entry<WSDLAttachPointIdentifier, Policy> entry : map.entrySet()) {
            List<WSDLSubject> list = wSDLSubjectCollection.getSubjectsForAttachpoint(entry.getKey());
            if (list == null) continue;
            for (WSDLSubject wSDLSubject : list) {
                wSDLSubject.getPolicies().add(entry.getValue());
            }
        }
        WSDLPolicyModelImpl wSDLPolicyModelImpl = new WSDLPolicyModelImpl(wSDLSubjectCollection, definition, hashMap);
        if (tc.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "buildWSDLPolicyModel", wSDLPolicyModelImpl);
        }
        return wSDLPolicyModelImpl;
    }

    @Override
    public PolicyProcessor.Alternative calculateFaultAlternative(QName qName, String string, String string2, String string3, WSDLPolicyModel wSDLPolicyModel, PolicyProcessor.FilterType filterType) throws WSPolicyException {
        if (tc.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "calculateFaultAlternative", new Object[]{qName, string, string2, string3, wSDLPolicyModel, filterType});
        }
        List<Policy> list = wSDLPolicyModel.getServiceAttachedPolicies(qName);
        PolicyProcessor.Alternative alternative = this.getSingleAlternativeAfterMerge(list, filterType);
        List<Policy> list2 = wSDLPolicyModel.getEndpointAttachedPolicies(qName, string);
        PolicyProcessor.Alternative alternative2 = this.getSingleAlternativeAfterMerge(list2, filterType);
        List<Policy> list3 = wSDLPolicyModel.getOperationAttachedPolicies(qName, string, string2);
        PolicyProcessor.Alternative alternative3 = this.getSingleAlternativeAfterMerge(list3, filterType);
        List<Policy> list4 = wSDLPolicyModel.getFaultAttachedPolicies(qName, string, string2, string3);
        PolicyProcessor.Alternative alternative4 = this.getSingleAlternativeAfterMerge(list4, filterType);
        PolicyProcessor policyProcessor = this.wsPolicyFactory.createWSPolicyProcessor();
        PolicyProcessor.Alternative alternative5 = policyProcessor.combineAlternatives(alternative, alternative2);
        alternative5 = policyProcessor.combineAlternatives(alternative5, alternative3);
        alternative5 = policyProcessor.combineAlternatives(alternative5, alternative4);
        if (tc.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "calculateFaultAlternative", alternative5);
        }
        return alternative5;
    }

    @Override
    public PolicyProcessor.Alternative calculateFaultIntersection(QName qName, String string, String string2, String string3, WSDLPolicyModel wSDLPolicyModel, WSDLPolicyModel wSDLPolicyModel2, PolicyProcessor.FilterType filterType) throws WSPolicyException {
        if (tc.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "calculateFaultIntersection", new Object[]{qName, string, string2, string3, wSDLPolicyModel, wSDLPolicyModel2, filterType});
        }
        PolicyProcessor.Alternative alternative = this.calculateServiceIntersection(qName, wSDLPolicyModel, wSDLPolicyModel2, filterType);
        PolicyProcessor.Alternative alternative2 = this.calculateEndpointIntersection(qName, string, wSDLPolicyModel, wSDLPolicyModel2, filterType);
        PolicyProcessor.Alternative alternative3 = this.calculateOperationIntersection(qName, string, string2, wSDLPolicyModel, wSDLPolicyModel2, filterType);
        PolicyProcessor.Alternative alternative4 = this.calculateFaultMessageIntersection(qName, string, string2, string3, wSDLPolicyModel, wSDLPolicyModel2, filterType);
        PolicyProcessor policyProcessor = this.wsPolicyFactory.createWSPolicyProcessor();
        PolicyProcessor.Alternative alternative5 = policyProcessor.combineAlternatives(alternative, alternative2);
        alternative5 = policyProcessor.combineAlternatives(alternative5, alternative3);
        alternative5 = policyProcessor.combineAlternatives(alternative5, alternative4);
        if (tc.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "calculateFaultIntersection", alternative5);
        }
        return alternative5;
    }

    @Override
    public PolicyProcessor.Alternative calculateRequestAlternative(QName qName, String string, String string2, WSDLPolicyModel wSDLPolicyModel, PolicyProcessor.FilterType filterType) throws WSPolicyException {
        if (tc.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "calculateRequestAlternative", new Object[]{qName, string, string2, wSDLPolicyModel, filterType});
        }
        List<Policy> list = wSDLPolicyModel.getServiceAttachedPolicies(qName);
        PolicyProcessor.Alternative alternative = this.getSingleAlternativeAfterMerge(list, filterType);
        List<Policy> list2 = wSDLPolicyModel.getEndpointAttachedPolicies(qName, string);
        PolicyProcessor.Alternative alternative2 = this.getSingleAlternativeAfterMerge(list2, filterType);
        List<Policy> list3 = wSDLPolicyModel.getOperationAttachedPolicies(qName, string, string2);
        PolicyProcessor.Alternative alternative3 = this.getSingleAlternativeAfterMerge(list3, filterType);
        List<Policy> list4 = wSDLPolicyModel.getRequestAttachedPolicies(qName, string, string2);
        PolicyProcessor.Alternative alternative4 = this.getSingleAlternativeAfterMerge(list4, filterType);
        PolicyProcessor policyProcessor = this.wsPolicyFactory.createWSPolicyProcessor();
        PolicyProcessor.Alternative alternative5 = policyProcessor.combineAlternatives(alternative, alternative2);
        alternative5 = policyProcessor.combineAlternatives(alternative5, alternative3);
        alternative5 = policyProcessor.combineAlternatives(alternative5, alternative4);
        if (tc.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "calculateRequestAlternative", alternative5);
        }
        return alternative5;
    }

    private PolicyProcessor.Alternative getSingleAlternativeAfterMerge(List<Policy> list, PolicyProcessor.FilterType filterType) throws WSPolicyException {
        if (tc.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "getSingleAlternativeAfterMerge", new Object[]{list, filterType});
        }
        Policy policy = this.mergePolicies(list);
        PolicyProcessor policyProcessor = this.wsPolicyFactory.createWSPolicyProcessor();
        PolicyProcessor.Alternative alternative = policyProcessor.getSingleAlternative(policy, filterType);
        if (tc.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "getSingleAlternativeAfterMerge", alternative);
        }
        return alternative;
    }

    @Override
    public PolicyProcessor.Alternative calculateRequestIntersection(QName qName, String string, String string2, WSDLPolicyModel wSDLPolicyModel, WSDLPolicyModel wSDLPolicyModel2, PolicyProcessor.FilterType filterType) throws WSPolicyException {
        if (tc.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "calculateRequestIntersection", new Object[]{qName, string, string2, wSDLPolicyModel, wSDLPolicyModel2, filterType});
        }
        PolicyProcessor.Alternative alternative = this.calculateServiceIntersection(qName, wSDLPolicyModel, wSDLPolicyModel2, filterType);
        PolicyProcessor.Alternative alternative2 = this.calculateEndpointIntersection(qName, string, wSDLPolicyModel, wSDLPolicyModel2, filterType);
        PolicyProcessor.Alternative alternative3 = this.calculateOperationIntersection(qName, string, string2, wSDLPolicyModel, wSDLPolicyModel2, filterType);
        PolicyProcessor.Alternative alternative4 = this.calculateInputMessageIntersection(qName, string, string2, wSDLPolicyModel, wSDLPolicyModel2, filterType);
        PolicyProcessor policyProcessor = this.wsPolicyFactory.createWSPolicyProcessor();
        PolicyProcessor.Alternative alternative5 = policyProcessor.combineAlternatives(alternative, alternative2);
        alternative5 = policyProcessor.combineAlternatives(alternative5, alternative3);
        alternative5 = policyProcessor.combineAlternatives(alternative5, alternative4);
        if (tc.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "calculateRequestIntersection", alternative5);
        }
        return alternative5;
    }

    @Override
    public PolicyProcessor.Alternative calculateResponseAlternative(QName qName, String string, String string2, WSDLPolicyModel wSDLPolicyModel, PolicyProcessor.FilterType filterType) throws WSPolicyException {
        if (tc.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "calculateResponseAlternative", new Object[]{qName, string, string2, wSDLPolicyModel, filterType});
        }
        List<Policy> list = wSDLPolicyModel.getServiceAttachedPolicies(qName);
        PolicyProcessor.Alternative alternative = this.getSingleAlternativeAfterMerge(list, filterType);
        List<Policy> list2 = wSDLPolicyModel.getEndpointAttachedPolicies(qName, string);
        PolicyProcessor.Alternative alternative2 = this.getSingleAlternativeAfterMerge(list2, filterType);
        List<Policy> list3 = wSDLPolicyModel.getOperationAttachedPolicies(qName, string, string2);
        PolicyProcessor.Alternative alternative3 = this.getSingleAlternativeAfterMerge(list3, filterType);
        List<Policy> list4 = wSDLPolicyModel.getResponseAttachedPolicies(qName, string, string2);
        PolicyProcessor.Alternative alternative4 = this.getSingleAlternativeAfterMerge(list4, filterType);
        PolicyProcessor policyProcessor = this.wsPolicyFactory.createWSPolicyProcessor();
        PolicyProcessor.Alternative alternative5 = policyProcessor.combineAlternatives(alternative, alternative2);
        alternative5 = policyProcessor.combineAlternatives(alternative5, alternative3);
        alternative5 = policyProcessor.combineAlternatives(alternative5, alternative4);
        if (tc.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "calculateResponseAlternative", alternative5);
        }
        return alternative5;
    }

    @Override
    public PolicyProcessor.Alternative calculateResponseIntersection(QName qName, String string, String string2, WSDLPolicyModel wSDLPolicyModel, WSDLPolicyModel wSDLPolicyModel2, PolicyProcessor.FilterType filterType) throws WSPolicyException {
        if (tc.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "calculateResponseIntersection", new Object[]{qName, string, string2, wSDLPolicyModel, wSDLPolicyModel2, filterType});
        }
        PolicyProcessor.Alternative alternative = this.calculateServiceIntersection(qName, wSDLPolicyModel, wSDLPolicyModel2, filterType);
        PolicyProcessor.Alternative alternative2 = this.calculateEndpointIntersection(qName, string, wSDLPolicyModel, wSDLPolicyModel2, filterType);
        PolicyProcessor.Alternative alternative3 = this.calculateOperationIntersection(qName, string, string2, wSDLPolicyModel, wSDLPolicyModel2, filterType);
        PolicyProcessor.Alternative alternative4 = this.calculateOutputMessageIntersection(qName, string, string2, wSDLPolicyModel, wSDLPolicyModel2, filterType);
        PolicyProcessor policyProcessor = this.wsPolicyFactory.createWSPolicyProcessor();
        PolicyProcessor.Alternative alternative5 = policyProcessor.combineAlternatives(alternative, alternative2);
        alternative5 = policyProcessor.combineAlternatives(alternative5, alternative3);
        alternative5 = policyProcessor.combineAlternatives(alternative5, alternative4);
        if (tc.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "calculateResponseIntersection", alternative5);
        }
        return alternative5;
    }

    @Override
    public PolicyProcessor.Alternative calculateEndpointAlternative(QName qName, String string, WSDLPolicyModel wSDLPolicyModel, PolicyProcessor.FilterType filterType) throws WSPolicyException {
        if (tc.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "calculateEndpointAlternative", new Object[]{qName, string, wSDLPolicyModel, filterType});
        }
        List<Policy> list = wSDLPolicyModel.getEndpointAttachedPolicies(qName, string);
        PolicyProcessor.Alternative alternative = this.getSingleAlternativeAfterMerge(list, filterType);
        if (tc.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "calculateEndpointAlternative", alternative);
        }
        return alternative;
    }

    @Override
    public PolicyProcessor.Alternative calculateEndpointIntersection(QName qName, String string, WSDLPolicyModel wSDLPolicyModel, WSDLPolicyModel wSDLPolicyModel2, PolicyProcessor.FilterType filterType) throws WSPolicyException {
        if (tc.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "calculateEndpointIntersection", new Object[]{qName, string, wSDLPolicyModel, wSDLPolicyModel2, filterType});
        }
        List<Policy> list = wSDLPolicyModel.getEndpointAttachedPolicies(qName, string);
        List<Policy> list2 = wSDLPolicyModel2.getEndpointAttachedPolicies(qName, string);
        PolicyProcessor.Alternative alternative = this.calculateIntersectionAfterMerge(list, list2, filterType);
        if (tc.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "calculateEndpointIntersection", alternative);
        }
        return alternative;
    }

    @Override
    public PolicyProcessor.Alternative calculateFaultMessageAlternative(QName qName, String string, String string2, String string3, WSDLPolicyModel wSDLPolicyModel, PolicyProcessor.FilterType filterType) throws WSPolicyException {
        if (tc.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "calculateFaultMessageAlternative", new Object[]{qName, string, string2, string3, wSDLPolicyModel, filterType});
        }
        List<Policy> list = wSDLPolicyModel.getFaultAttachedPolicies(qName, string, string2, string3);
        PolicyProcessor.Alternative alternative = this.getSingleAlternativeAfterMerge(list, filterType);
        if (tc.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "calculateFaultMessageAlternative", alternative);
        }
        return alternative;
    }

    @Override
    public PolicyProcessor.Alternative calculateFaultMessageIntersection(QName qName, String string, String string2, String string3, WSDLPolicyModel wSDLPolicyModel, WSDLPolicyModel wSDLPolicyModel2, PolicyProcessor.FilterType filterType) throws WSPolicyException {
        if (tc.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "calculateFaultMessageIntersection", new Object[]{qName, string, string2, string3, wSDLPolicyModel, wSDLPolicyModel2, filterType});
        }
        List<Policy> list = wSDLPolicyModel.getFaultAttachedPolicies(qName, string, string2, string3);
        List<Policy> list2 = wSDLPolicyModel2.getFaultAttachedPolicies(qName, string, string2, string3);
        PolicyProcessor.Alternative alternative = this.calculateIntersectionAfterMerge(list, list2, filterType);
        if (tc.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "calculateFaultMessageIntersection", alternative);
        }
        return alternative;
    }

    @Override
    public PolicyProcessor.Alternative calculateInputMessageAlternative(QName qName, String string, String string2, WSDLPolicyModel wSDLPolicyModel, PolicyProcessor.FilterType filterType) throws WSPolicyException {
        if (tc.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "calculateInputMessageAlternative", new Object[]{qName, string, string2, wSDLPolicyModel, filterType});
        }
        List<Policy> list = wSDLPolicyModel.getRequestAttachedPolicies(qName, string, string2);
        PolicyProcessor.Alternative alternative = this.getSingleAlternativeAfterMerge(list, filterType);
        if (tc.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "calculateInputMessageAlternative", alternative);
        }
        return alternative;
    }

    @Override
    public PolicyProcessor.Alternative calculateInputMessageIntersection(QName qName, String string, String string2, WSDLPolicyModel wSDLPolicyModel, WSDLPolicyModel wSDLPolicyModel2, PolicyProcessor.FilterType filterType) throws WSPolicyException {
        if (tc.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "calculateInputMessageIntersection", new Object[]{qName, string, string2, wSDLPolicyModel, wSDLPolicyModel2, filterType});
        }
        List<Policy> list = wSDLPolicyModel.getRequestAttachedPolicies(qName, string, string2);
        List<Policy> list2 = wSDLPolicyModel2.getRequestAttachedPolicies(qName, string, string2);
        PolicyProcessor.Alternative alternative = this.calculateIntersectionAfterMerge(list, list2, filterType);
        if (tc.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "calculateInputMessageIntersection", alternative);
        }
        return alternative;
    }

    @Override
    public PolicyProcessor.Alternative calculateOperationAlternative(QName qName, String string, String string2, WSDLPolicyModel wSDLPolicyModel, PolicyProcessor.FilterType filterType) throws WSPolicyException {
        if (tc.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "calculateOperationAlternative", new Object[]{qName, string, string2, wSDLPolicyModel, filterType});
        }
        List<Policy> list = wSDLPolicyModel.getOperationAttachedPolicies(qName, string, string2);
        PolicyProcessor.Alternative alternative = this.getSingleAlternativeAfterMerge(list, filterType);
        if (tc.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "calculateOperationAlternative", alternative);
        }
        return alternative;
    }

    @Override
    public PolicyProcessor.Alternative calculateOperationIntersection(QName qName, String string, String string2, WSDLPolicyModel wSDLPolicyModel, WSDLPolicyModel wSDLPolicyModel2, PolicyProcessor.FilterType filterType) throws WSPolicyException {
        if (tc.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "calculateOperationIntersection", new Object[]{qName, string, string2, wSDLPolicyModel, wSDLPolicyModel2, filterType});
        }
        List<Policy> list = wSDLPolicyModel.getOperationAttachedPolicies(qName, string, string2);
        List<Policy> list2 = wSDLPolicyModel2.getOperationAttachedPolicies(qName, string, string2);
        PolicyProcessor.Alternative alternative = this.calculateIntersectionAfterMerge(list, list2, filterType);
        if (tc.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "calculateOperationIntersection", alternative);
        }
        return alternative;
    }

    @Override
    public PolicyProcessor.Alternative calculateOutputMessageAlternative(QName qName, String string, String string2, WSDLPolicyModel wSDLPolicyModel, PolicyProcessor.FilterType filterType) throws WSPolicyException {
        if (tc.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "calculateOutputMessageAlternative", new Object[]{qName, string, string2, wSDLPolicyModel, filterType});
        }
        List<Policy> list = wSDLPolicyModel.getResponseAttachedPolicies(qName, string, string2);
        PolicyProcessor.Alternative alternative = this.getSingleAlternativeAfterMerge(list, filterType);
        if (tc.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "calculateOutputMessageAlternative", alternative);
        }
        return alternative;
    }

    @Override
    public PolicyProcessor.Alternative calculateOutputMessageIntersection(QName qName, String string, String string2, WSDLPolicyModel wSDLPolicyModel, WSDLPolicyModel wSDLPolicyModel2, PolicyProcessor.FilterType filterType) throws WSPolicyException {
        if (tc.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "calculateOutputMessageIntersection", new Object[]{qName, string, string2, wSDLPolicyModel, wSDLPolicyModel2, filterType});
        }
        List<Policy> list = wSDLPolicyModel.getResponseAttachedPolicies(qName, string, string2);
        List<Policy> list2 = wSDLPolicyModel2.getResponseAttachedPolicies(qName, string, string2);
        PolicyProcessor.Alternative alternative = this.calculateIntersectionAfterMerge(list, list2, filterType);
        if (tc.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "calculateOutputMessageIntersection", alternative);
        }
        return alternative;
    }

    @Override
    public PolicyProcessor.Alternative calculateServiceAlternative(QName qName, WSDLPolicyModel wSDLPolicyModel, PolicyProcessor.FilterType filterType) throws WSPolicyException {
        if (tc.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "calculateServiceAlternative", new Object[]{qName, wSDLPolicyModel, filterType});
        }
        List<Policy> list = wSDLPolicyModel.getServiceAttachedPolicies(qName);
        PolicyProcessor.Alternative alternative = this.getSingleAlternativeAfterMerge(list, filterType);
        if (tc.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "calculateServiceAlternative", alternative);
        }
        return alternative;
    }

    @Override
    public PolicyProcessor.Alternative calculateServiceIntersection(QName qName, WSDLPolicyModel wSDLPolicyModel, WSDLPolicyModel wSDLPolicyModel2, PolicyProcessor.FilterType filterType) throws WSPolicyException {
        if (tc.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "calculateServiceIntersection", new Object[]{qName, wSDLPolicyModel, wSDLPolicyModel2, filterType});
        }
        List<Policy> list = wSDLPolicyModel.getServiceAttachedPolicies(qName);
        List<Policy> list2 = wSDLPolicyModel2.getServiceAttachedPolicies(qName);
        PolicyProcessor.Alternative alternative = this.calculateIntersectionAfterMerge(list, list2, filterType);
        if (tc.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "calculateServiceIntersection", alternative);
        }
        return alternative;
    }

    private PolicyProcessor.Alternative calculateIntersectionAfterMerge(List<Policy> list, List<Policy> list2, PolicyProcessor.FilterType filterType) throws WSPolicyException {
        if (tc.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "calculateIntersectionAfterMerge", new Object[]{list, list2, filterType});
        }
        Policy policy = this.mergePolicies(list);
        Policy policy2 = this.mergePolicies(list2);
        PolicyProcessor policyProcessor = this.wsPolicyFactory.createWSPolicyProcessor();
        Iterable<PolicyProcessor.Alternative> iterable = policyProcessor.intersect(policy, policy2, false, filterType);
        PolicyProcessor.Alternative alternative = null;
        Iterator<PolicyProcessor.Alternative> iterator = iterable.iterator();
        if (iterator.hasNext()) {
            alternative = iterator.next();
        }
        if (tc.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "calculateIntersectionAfterMerge", alternative);
        }
        return alternative;
    }

    private Policy mergePolicies(List<Policy> list) throws WSPolicyException {
        if (tc.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "mergePolicies", list);
        }
        Policy policy = this.wsPolicyFactory.createDataModelFactory().createPolicy();
        PolicyProcessor policyProcessor = this.wsPolicyFactory.createWSPolicyProcessor();
        for (Policy policy2 : list) {
            if (policyProcessor.policyContainsPolicyReferences(policy2)) {
                throw new WSPolicyException();
            }
            policy = policyProcessor.merge(policy, policy2);
        }
        if (tc.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "mergePolicies", policy);
        }
        return policy;
    }
}

