/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wspolicy.wsdl.internal;

import com.ibm.webservices.component.logging.Tr;
import com.ibm.webservices.component.logging.TraceComponent;
import com.ibm.wspolicy.WSPolicyException;
import com.ibm.wspolicy.datamodel.Policy;
import com.ibm.wspolicy.datamodel.PolicyReference;
import com.ibm.wspolicy.wsdl.WSDLPolicyModel;
import com.ibm.wspolicy.wsdl.internal.attachment.WSDLAttachPointIdentifier;
import com.ibm.wspolicy.wsdl.internal.subject.WSDLSubject;
import com.ibm.wspolicy.wsdl.internal.subject.WSDLSubjectCollection;
import com.ibm.wspolicy.wsdl.internal.subject.WSDLSubjectIdentifier;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.wsdl.BindingOperation;
import javax.wsdl.Definition;
import javax.wsdl.Operation;
import javax.wsdl.Port;
import javax.wsdl.Service;
import javax.xml.namespace.QName;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WSDLPolicyModelImpl
implements WSDLPolicyModel {
    private static final TraceComponent tc = Tr.register(WSDLPolicyModelImpl.class, "wspolicy4j", "com.ibm.ws.wspolicy.resources.CWPOLMessages");
    WSDLSubjectCollection wsdlSubjectCollection;
    Map<Policy, Set<PolicyReference>> policiesWithUnresolvedReferences;
    Definition def;

    public WSDLPolicyModelImpl(WSDLSubjectCollection wSDLSubjectCollection, Definition definition, Map<Policy, Set<PolicyReference>> map) {
        if (tc.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "WSDLPolicyModelImpl", new Object[]{wSDLSubjectCollection, definition});
        }
        this.wsdlSubjectCollection = wSDLSubjectCollection;
        this.policiesWithUnresolvedReferences = map;
        this.def = definition;
        if (tc.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "WSDLPolicyModelImpl");
        }
    }

    private void addAttachment(WSDLAttachPointIdentifier wSDLAttachPointIdentifier, Policy policy) {
        if (tc.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "addAttachment", new Object[]{wSDLAttachPointIdentifier, policy});
        }
        for (WSDLSubject wSDLSubject : this.wsdlSubjectCollection.getSubjectsForAttachpoint(wSDLAttachPointIdentifier)) {
            wSDLSubject.getPolicies().add(policy);
        }
        if (tc.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "addAttachment");
        }
    }

    @Override
    public List<Policy> getEndpointAttachedPolicies(QName qName, String string) throws WSPolicyException {
        if (tc.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "getEndpointAttachedPolicies", new Object[]{qName, string});
        }
        WSDLSubjectIdentifier wSDLSubjectIdentifier = WSDLSubjectIdentifier.createEndpointSubjectIdentifier(qName, string);
        List<Policy> list = this.wsdlSubjectCollection.getSubjectWithIdentifier(wSDLSubjectIdentifier).getPolicies();
        if (tc.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "getEndpointAttachedPolicies", list);
        }
        return list;
    }

    @Override
    public List<Policy> getFaultAttachedPolicies(QName qName, String string, String string2, String string3) throws WSPolicyException {
        if (tc.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "getFaultAttachedPolicies", new Object[]{qName, string, string2, string3});
        }
        WSDLSubjectIdentifier wSDLSubjectIdentifier = WSDLSubjectIdentifier.createFaultMessageSubjectIdentifier(qName, string, string2, string3);
        List<Policy> list = this.wsdlSubjectCollection.getSubjectWithIdentifier(wSDLSubjectIdentifier).getPolicies();
        if (tc.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "getFaultAttachedPolicies", list);
        }
        return list;
    }

    @Override
    public List<String> getFaultNames(QName qName, String string, String string2) {
        if (tc.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "getFaultNames", new Object[]{qName, string, string2});
        }
        Service service = this.def.getService(qName);
        Port port = service.getPort(string);
        Operation operation = port.getBinding().getBindingOperation(string2, null, null).getOperation();
        ArrayList<String> arrayList = new ArrayList<String>(operation.getFaults().keySet());
        if (tc.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "getFaultNames", arrayList);
        }
        return arrayList;
    }

    @Override
    public List<Policy> getOperationAttachedPolicies(QName qName, String string, String string2) throws WSPolicyException {
        if (tc.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "getOperationAttachedPolicies", new Object[]{qName, string, string2});
        }
        WSDLSubjectIdentifier wSDLSubjectIdentifier = WSDLSubjectIdentifier.createOperationSubjectIdentifier(qName, string, string2);
        List<Policy> list = this.wsdlSubjectCollection.getSubjectWithIdentifier(wSDLSubjectIdentifier).getPolicies();
        if (tc.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "getOperationAttachedPolicies", list);
        }
        return list;
    }

    @Override
    public List<String> getOperationNames(QName qName, String string) {
        if (tc.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "getOperationNames", new Object[]{qName, string});
        }
        Service service = this.def.getService(qName);
        Port port = service.getPort(string);
        List list = port.getBinding().getBindingOperations();
        ArrayList<String> arrayList = new ArrayList<String>();
        for (Object e : list) {
            arrayList.add(((BindingOperation)e).getName());
        }
        if (tc.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "getOperationNames", arrayList);
        }
        return arrayList;
    }

    @Override
    public List<String> getPortNames(QName qName) {
        if (tc.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "getPortNames", qName);
        }
        Service service = this.def.getService(qName);
        ArrayList<String> arrayList = new ArrayList<String>(service.getPorts().keySet());
        if (tc.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "getPortNames", arrayList);
        }
        return arrayList;
    }

    @Override
    public List<Policy> getRequestAttachedPolicies(QName qName, String string, String string2) throws WSPolicyException {
        if (tc.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "getRequestAttachedPolicies", new Object[]{qName, string, string2});
        }
        WSDLSubjectIdentifier wSDLSubjectIdentifier = WSDLSubjectIdentifier.createInputMessageSubjectIdentifier(qName, string, string2);
        List<Policy> list = this.wsdlSubjectCollection.getSubjectWithIdentifier(wSDLSubjectIdentifier).getPolicies();
        if (tc.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "getRequestAttachedPolicies", list);
        }
        return list;
    }

    @Override
    public List<Policy> getResponseAttachedPolicies(QName qName, String string, String string2) throws WSPolicyException {
        if (tc.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "getResponseAttachedPolicies", new Object[]{qName, string, string2});
        }
        WSDLSubjectIdentifier wSDLSubjectIdentifier = WSDLSubjectIdentifier.createOutputMessageSubjectIdentifier(qName, string, string2);
        List<Policy> list = this.wsdlSubjectCollection.getSubjectWithIdentifier(wSDLSubjectIdentifier).getPolicies();
        if (tc.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "getResponseAttachedPolicies", list);
        }
        return list;
    }

    @Override
    public List<Policy> getServiceAttachedPolicies(QName qName) throws WSPolicyException {
        if (tc.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "getServiceAttachedPolicies", qName);
        }
        WSDLSubjectIdentifier wSDLSubjectIdentifier = WSDLSubjectIdentifier.createServiceSubjectIdentifier(qName);
        List<Policy> list = this.wsdlSubjectCollection.getSubjectWithIdentifier(wSDLSubjectIdentifier).getPolicies();
        if (tc.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "getServiceAttachedPolicies", list);
        }
        return list;
    }

    @Override
    public List<QName> getServiceNames() {
        if (tc.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "getServiceNames");
        }
        ArrayList<QName> arrayList = new ArrayList<QName>(this.def.getAllServices().keySet());
        if (tc.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "getServiceNames", arrayList);
        }
        return arrayList;
    }

    @Override
    public void addBindingAttachment(QName qName, Policy policy) {
        if (tc.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "addBindingAttachment", new Object[]{qName, policy});
        }
        this.addAttachment(WSDLAttachPointIdentifier.createBindingAttachPoint(qName), policy);
        if (tc.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "addBindingAttachment");
        }
    }

    @Override
    public void addBindingFaultAttachment(QName qName, String string, String string2, Policy policy) {
        if (tc.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "addBindingFaultAttachment", new Object[]{qName, string, string2, policy});
        }
        this.addAttachment(WSDLAttachPointIdentifier.createBindingOperationFaultAttachPoint(qName, string, string2), policy);
        if (tc.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "addBindingFaultAttachment");
        }
    }

    @Override
    public void addBindingOperationAttachment(QName qName, String string, Policy policy) {
        if (tc.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "addBindingOperationAttachment", new Object[]{qName, string, policy});
        }
        this.addAttachment(WSDLAttachPointIdentifier.createBindingOperationAttachPoint(qName, string), policy);
        if (tc.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "addBindingOperationAttachment");
        }
    }

    @Override
    public void addBindingRequestAttachment(QName qName, String string, Policy policy) {
        if (tc.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "addBindingRequestAttachment", new Object[]{qName, string, policy});
        }
        this.addAttachment(WSDLAttachPointIdentifier.createBindingOperationInputAttachPoint(qName, string), policy);
        if (tc.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "addBindingRequestAttachment");
        }
    }

    @Override
    public void addBindingResponseAttachment(QName qName, String string, Policy policy) {
        if (tc.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "addBindingResponseAttachment", new Object[]{qName, string, policy});
        }
        this.addAttachment(WSDLAttachPointIdentifier.createBindingOperationOutputAttachPoint(qName, string), policy);
        if (tc.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "addBindingResponseAttachment");
        }
    }

    @Override
    public void addMessageAttachment(QName qName, Policy policy) {
        if (tc.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "addMessageAttachment", new Object[]{qName, policy});
        }
        this.addAttachment(WSDLAttachPointIdentifier.createMessageAttachPoint(qName), policy);
        if (tc.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "addMessageAttachment");
        }
    }

    @Override
    public void addOperationAttachment(QName qName, String string, Policy policy) {
        if (tc.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "addOperationAttachment", new Object[]{qName, string, policy});
        }
        this.addAttachment(WSDLAttachPointIdentifier.createOperationAttachPoint(qName, string), policy);
        if (tc.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "addOperationAttachment");
        }
    }

    @Override
    public void addPortAttachment(QName qName, String string, Policy policy) {
        if (tc.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "addPortAttachment", new Object[]{qName, string, policy});
        }
        this.addAttachment(WSDLAttachPointIdentifier.createPortAttachPoint(qName, string), policy);
        if (tc.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "addPortAttachment");
        }
    }

    @Override
    public void addPortTypeAttachment(QName qName, Policy policy) {
        if (tc.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "addPortTypeAttachment", new Object[]{qName, policy});
        }
        this.addAttachment(WSDLAttachPointIdentifier.createPortTypeAttachPoint(qName), policy);
        if (tc.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "addPortTypeAttachment");
        }
    }

    @Override
    public void addPortTypeFaultAttachment(QName qName, String string, String string2, Policy policy) {
        if (tc.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "addPortTypeFaultAttachment", new Object[]{qName, string, string2, policy});
        }
        this.addAttachment(WSDLAttachPointIdentifier.createOperationFaultAttachPoint(qName, string, string2), policy);
        if (tc.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "addPortTypeFaultAttachment");
        }
    }

    @Override
    public void addPortTypeRequestAttachment(QName qName, String string, Policy policy) {
        if (tc.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "addPortTypeRequestAttachment", new Object[]{qName, string, policy});
        }
        this.addAttachment(WSDLAttachPointIdentifier.createOperationInputAttachPoint(qName, string), policy);
        if (tc.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "addPortTypeRequestAttachment");
        }
    }

    @Override
    public void addPortTypeResponseAttachment(QName qName, String string, Policy policy) {
        if (tc.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "addPortTypeResponseAttachment", new Object[]{qName, string, policy});
        }
        this.addAttachment(WSDLAttachPointIdentifier.createOperationOutputAttachPoint(qName, string), policy);
        if (tc.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "addPortTypeResponseAttachment");
        }
    }

    @Override
    public void addServiceAttachment(QName qName, Policy policy) {
        if (tc.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "addServiceAttachment", new Object[]{qName, policy});
        }
        this.addAttachment(WSDLAttachPointIdentifier.createServiceAttachPoint(qName), policy);
        if (tc.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "addServiceAttachment");
        }
    }

    @Override
    public List<Policy> getAllAttachedPolicies() {
        if (tc.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "getAllAttachedPolicies");
        }
        List<Policy> list = this.wsdlSubjectCollection.getAllAttachedPolicies();
        if (tc.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "getAllAttachedPolicies", list);
        }
        return list;
    }

    @Override
    public boolean hasAttachedPolicy() {
        if (tc.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "hasAttachedPolicy");
        }
        boolean bl = this.wsdlSubjectCollection.hasAttachedPolicy();
        if (tc.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "hasAttachedPolicy", bl);
        }
        return bl;
    }

    @Override
    public Map<Policy, Set<PolicyReference>> getPoliciesWithUnresolvedReferences() {
        if (tc.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "getPoliciesWithUnresolvedReferences");
        }
        if (tc.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "getPoliciesWithUnresolvedReferences", this.policiesWithUnresolvedReferences);
        }
        return this.policiesWithUnresolvedReferences;
    }
}

