/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wspolicy.internal.xml;

import com.ibm.webservices.component.logging.Tr;
import com.ibm.wspolicy.datamodel.PolicyElement;
import com.ibm.wspolicy.xml.ElementReader;
import com.ibm.wspolicy.xml.ElementReaderException;
import java.io.InputStream;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicInteger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.bootstrap.DOMImplementationRegistry;
import org.w3c.dom.ls.DOMImplementationLS;
import org.w3c.dom.ls.LSInput;
import org.w3c.dom.ls.LSParser;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InputStreamElementReader
implements ElementReader<InputStream> {
    private ElementReader<Element> der;
    private static PooledParser pooledParser;

    public InputStreamElementReader(ElementReader<Element> elementReader) {
        this.der = elementReader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PolicyElement read(InputStream inputStream) throws ElementReaderException {
        try {
            Object object = this;
            synchronized (object) {
                if (pooledParser == null) {
                    pooledParser = new PooledParser();
                }
            }
            object = pooledParser.parse(inputStream);
            PolicyElement policyElement = this.der.read(object.getDocumentElement());
            return policyElement;
        }
        catch (Exception exception) {
            ElementReaderException elementReaderException = new ElementReaderException();
            elementReaderException.initCause(exception);
            throw elementReaderException;
        }
    }

    private static class PooledParser {
        private static int MAX_POOL_SIZE;
        private ConcurrentLinkedQueue<LSParser> q = new ConcurrentLinkedQueue();
        private AtomicInteger count = new AtomicInteger(0);
        private DOMImplementationLS impl;

        PooledParser() throws ClassCastException, ClassNotFoundException, InstantiationException, IllegalAccessException {
            DOMImplementationRegistry dOMImplementationRegistry = DOMImplementationRegistry.newInstance();
            this.impl = (DOMImplementationLS)((Object)dOMImplementationRegistry.getDOMImplementation("LS"));
        }

        public Document parse(InputStream inputStream) {
            LSParser lSParser = this.q.poll();
            if (lSParser == null) {
                lSParser = this.impl.createLSParser((short)1, null);
                this.count.incrementAndGet();
            }
            LSInput lSInput = this.impl.createLSInput();
            lSInput.setByteStream(inputStream);
            Document document = lSParser.parse(lSInput);
            if (this.count.decrementAndGet() < MAX_POOL_SIZE) {
                this.q.add(lSParser);
            }
            return document;
        }

        static {
            try {
                int n;
                String string = AccessController.doPrivileged(new PrivilegedAction<String>(){

                    @Override
                    public String run() {
                        return System.getProperty("com.ibm.wspolicy.internal.xml.InputStreamElementReader.PooledParser.MAX_POOL_SIZE", "10");
                    }
                });
                MAX_POOL_SIZE = n = Integer.parseInt(string);
            }
            catch (Exception exception) {
                Tr.processException(exception, "com.ibm.wspolicy.internal.xml.InputStreamElementReader.PooledParser.<clinit>", "30");
                MAX_POOL_SIZE = 10;
            }
        }
    }
}

