/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wspolicy.internal.xml;

import com.ibm.wspolicy.datamodel.All;
import com.ibm.wspolicy.datamodel.Assertion;
import com.ibm.wspolicy.datamodel.ExactlyOne;
import com.ibm.wspolicy.datamodel.ExtensibleElement;
import com.ibm.wspolicy.datamodel.Policy;
import com.ibm.wspolicy.datamodel.PolicyElement;
import com.ibm.wspolicy.datamodel.PolicyReference;
import com.ibm.wspolicy.factory.DataModelFactory;
import com.ibm.wspolicy.internal.datamodel.DOMExtensibleElement;
import com.ibm.wspolicy.xml.ElementReader;
import com.ibm.wspolicy.xml.ElementReaderException;
import com.ibm.wspolicy.xml.UnsupportedElementException;
import com.ibm.wspolicy.xml.UnsupportedPolicyNamespaceException;
import javax.xml.namespace.QName;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DOMElementElementReader
implements ElementReader<Element> {
    private static final String NS = "http://www.w3.org/ns/ws-policy";
    private static final String OLD_NS = "http://schemas.xmlsoap.org/ws/2004/09/policy";
    private static final String POLICY = "Policy";
    private static final String POLICY_REFERENCE = "PolicyReference";
    private static final String EXACTLY_ONE = "ExactlyOne";
    private static final String ALL = "All";
    private static final String NAME = "Name";
    private static final String ONE = "1";
    private static final String IGNORABLE = "Ignorable";
    private static final String OPTIONAL = "Optional";
    private static final String DIGEST_ALGORITHM = "DigestAlgorithm";
    private static final String DIGEST = "Digest";
    private static final String URI = "URI";
    private static final String XMLNS = "xmlns";
    private DataModelFactory _factory;

    public DOMElementElementReader(DataModelFactory dataModelFactory) {
        this._factory = dataModelFactory;
    }

    @Override
    public PolicyElement read(Element element) throws ElementReaderException {
        if (NS.equals(element.getNamespaceURI()) && POLICY.equals(element.getLocalName())) {
            return this.readPolicy(element);
        }
        if (NS.equals(element.getNamespaceURI()) && ALL.equals(element.getLocalName())) {
            return this.readAll(element);
        }
        if (NS.equals(element.getNamespaceURI()) && EXACTLY_ONE.equals(element.getLocalName())) {
            return this.readExactlyOne(element);
        }
        if (NS.equals(element.getNamespaceURI()) && POLICY_REFERENCE.equals(element.getLocalName())) {
            return this.readPolicyReference(element);
        }
        if (OLD_NS.equals(element.getNamespaceURI())) {
            throw new UnsupportedPolicyNamespaceException();
        }
        if (!NS.equals(element.getNamespaceURI())) {
            return this.readAssertion(element);
        }
        throw new UnsupportedElementException();
    }

    private Policy readPolicy(Element element) throws ElementReaderException {
        Object object;
        Policy policy = this._factory.createPolicy();
        NamedNodeMap namedNodeMap = element.getAttributes();
        for (int i = 0; i < namedNodeMap.getLength(); ++i) {
            Node node = namedNodeMap.item(i);
            if (node.getNodeType() != 2) continue;
            String string = node.getNodeName();
            if ((string = string.trim()).startsWith(XMLNS)) continue;
            object = node.getLocalName();
            if (((String)object).equals(NAME)) {
                policy.setName(node.getNodeValue());
                continue;
            }
            QName qName = null;
            qName = node.getPrefix() != null ? new QName(node.getNamespaceURI(), (String)object, node.getPrefix()) : new QName(node.getNamespaceURI(), (String)object);
            policy.getOtherAttributes().put(qName, node.getNodeValue());
        }
        NodeList nodeList = element.getChildNodes();
        int n = 0;
        for (int i = 0; i < nodeList.getLength(); ++i) {
            if (nodeList.item(i).getNodeType() != 1) continue;
            ++n;
            object = (Element)nodeList.item(i);
            policy.getChildren().add(this.read((Element)object));
        }
        return policy;
    }

    private All readAll(Element element) throws ElementReaderException {
        All all = this._factory.createAll();
        NodeList nodeList = element.getChildNodes();
        int n = 0;
        for (int i = 0; i < nodeList.getLength(); ++i) {
            if (nodeList.item(i).getNodeType() != 1) continue;
            ++n;
            Element element2 = (Element)nodeList.item(i);
            all.getChildren().add(this.read(element2));
        }
        return all;
    }

    private ExactlyOne readExactlyOne(Element element) throws ElementReaderException {
        ExactlyOne exactlyOne = this._factory.createExactlyOne();
        NodeList nodeList = element.getChildNodes();
        int n = 0;
        for (int i = 0; i < nodeList.getLength(); ++i) {
            if (nodeList.item(i).getNodeType() != 1) continue;
            ++n;
            Element element2 = (Element)nodeList.item(i);
            exactlyOne.getChildren().add(this.read(element2));
        }
        return exactlyOne;
    }

    private Assertion readAssertion(Element element) throws ElementReaderException {
        Object object;
        Object object2;
        QName qName = null;
        if (element.getNamespaceURI() != null && element.getPrefix() != null) {
            qName = new QName(element.getNamespaceURI(), element.getLocalName(), element.getPrefix());
        }
        if (element.getNamespaceURI() != null && element.getPrefix() == null) {
            qName = new QName(element.getNamespaceURI(), element.getLocalName());
        }
        if (element.getNamespaceURI() == null) {
            qName = new QName(element.getLocalName());
        }
        if (qName == null) {
            throw new ElementReaderException();
        }
        Assertion assertion = this._factory.createAssertion(qName);
        NamedNodeMap namedNodeMap = element.getAttributes();
        for (int i = 0; i < namedNodeMap.getLength(); ++i) {
            Node node = namedNodeMap.item(i);
            if (node.getNodeType() != 2) continue;
            String string = node.getNodeName();
            if ((string = string.trim()).startsWith(XMLNS)) continue;
            object2 = node.getLocalName();
            if (OPTIONAL.equals(object2)) {
                object = node.getNodeValue();
                if (ONE.equals(((String)object).trim())) {
                    assertion.setOptional(true);
                    continue;
                }
                assertion.setOptional(Boolean.valueOf((String)object));
                continue;
            }
            if (IGNORABLE.equals(object2)) {
                object = node.getNodeValue();
                if (ONE.equals(((String)object).trim())) {
                    assertion.setIgnorable(true);
                    continue;
                }
                assertion.setIgnorable(Boolean.valueOf((String)object));
                continue;
            }
            object = null;
            object = node.getPrefix() != null ? new QName(node.getNamespaceURI(), (String)object2, node.getPrefix()) : new QName(node.getNamespaceURI(), (String)object2);
            assertion.getAttributeParameters().put((QName)object, node.getNodeValue());
        }
        NodeList nodeList = element.getChildNodes();
        int n = 0;
        for (int i = 0; i < nodeList.getLength(); ++i) {
            object2 = nodeList.item(i);
            if (object2.getNodeType() == 1) {
                DOMExtensibleElement dOMExtensibleElement;
                object = (Element)object2;
                if (++n == 1) {
                    if (POLICY.equals(object.getLocalName())) {
                        assertion.setNestedPolicy(this.readPolicy((Element)object));
                        continue;
                    }
                    dOMExtensibleElement = new DOMExtensibleElement();
                    dOMExtensibleElement.setNode((Node)object);
                    assertion.getElementParameters().add(dOMExtensibleElement);
                    continue;
                }
                dOMExtensibleElement = new DOMExtensibleElement();
                dOMExtensibleElement.setNode((Node)object);
                assertion.getElementParameters().add(dOMExtensibleElement);
                continue;
            }
            if (object2.getNodeType() != 3 || object2.getNodeValue().trim().length() == 0) continue;
            object = new DOMExtensibleElement();
            ((DOMExtensibleElement)object).setNode(nodeList.item(i));
            assertion.getElementParameters().add((ExtensibleElement)object);
        }
        return assertion;
    }

    private PolicyReference readPolicyReference(Element element) {
        Object object;
        PolicyReference policyReference = this._factory.createPolicyReference();
        NamedNodeMap namedNodeMap = element.getAttributes();
        for (int i = 0; i < namedNodeMap.getLength(); ++i) {
            Node node = namedNodeMap.item(i);
            if (node.getNodeType() != 2) continue;
            object = node.getNodeName();
            if (((String)(object = ((String)object).trim())).startsWith(XMLNS)) continue;
            String string = node.getLocalName();
            if (string.equals(URI)) {
                policyReference.setURI(node.getNodeValue());
                continue;
            }
            if (string.equals(DIGEST)) {
                policyReference.setDigest(node.getNodeValue());
                continue;
            }
            if (string.equals(DIGEST_ALGORITHM)) {
                policyReference.setDigestAlgorithm(node.getNodeValue());
                continue;
            }
            QName qName = null;
            qName = node.getPrefix() != null ? new QName(node.getNamespaceURI(), string, node.getPrefix()) : new QName(node.getNamespaceURI(), string);
            policyReference.getOtherAttributes().put(qName, node.getNodeValue());
        }
        NodeList nodeList = element.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            if (nodeList.item(i).getNodeType() != 1 && nodeList.item(i).getNodeType() != 3) continue;
            object = new DOMExtensibleElement();
            ((DOMExtensibleElement)object).setNode(nodeList.item(i));
            policyReference.getExtensibilityElements().add((ExtensibleElement)object);
        }
        return policyReference;
    }
}

