/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wspolicy.internal.xml;

import com.ibm.wspolicy.datamodel.All;
import com.ibm.wspolicy.datamodel.Assertion;
import com.ibm.wspolicy.datamodel.ExactlyOne;
import com.ibm.wspolicy.datamodel.ExtensibleElement;
import com.ibm.wspolicy.datamodel.Policy;
import com.ibm.wspolicy.datamodel.PolicyElement;
import com.ibm.wspolicy.datamodel.PolicyReference;
import com.ibm.wspolicy.xml.ElementWriter;
import com.ibm.wspolicy.xml.ElementWriterException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import javax.xml.namespace.QName;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class DOMDocumentElementWriter
implements ElementWriter<Document> {
    private final Map<String, String> prefixMap = new HashMap<String, String>();
    private final AtomicInteger count = new AtomicInteger(0);

    public DOMDocumentElementWriter() {
        this.prefixMap.put("http://www.w3.org/ns/ws-policy", "wsp");
        this.prefixMap.put("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd", "wsu");
    }

    @Override
    public void write(PolicyElement policyElement, Document document) throws ElementWriterException {
        Element element = this.createDOMElement(policyElement, document);
        document.appendChild(element);
    }

    private Element createDOMElement(Policy policy, Document document) throws ElementWriterException {
        Node node;
        Element element = document.createElementNS("http://www.w3.org/ns/ws-policy", "Policy");
        element.setPrefix(this.prefixMap.get("http://www.w3.org/ns/ws-policy"));
        if (policy.getName() != null && policy.getName().length() > 0) {
            element.setAttribute("Name", policy.getName());
        }
        for (Map.Entry<QName, String> object : policy.getOtherAttributes().entrySet()) {
            node = document.createAttributeNS(object.getKey().getNamespaceURI(), object.getKey().getLocalPart());
            node.setValue(object.getValue());
            if (object.getKey().getNamespaceURI() != null && object.getKey().getNamespaceURI().trim().length() > 0) {
                node.setPrefix(this.getPrefix(object.getKey()));
            }
            element.setAttributeNode((Attr)node);
        }
        for (PolicyElement policyElement : policy.getChildren()) {
            node = this.createDOMElement(policyElement, document);
            element.appendChild(node);
        }
        return element;
    }

    private Element createDOMElement(PolicyReference policyReference, Document document) {
        Element element = document.createElementNS("http://www.w3.org/ns/ws-policy", "PolicyReference");
        element.setPrefix(this.prefixMap.get("http://www.w3.org/ns/ws-policy"));
        element.setAttribute("URI", policyReference.getURI());
        if (policyReference.getDigest() != null && policyReference.getDigest().length() > 0) {
            element.setAttribute("Digest", policyReference.getDigest());
        }
        if (policyReference.getDigestAlgorithm() != null && policyReference.getDigestAlgorithm().length() > 0) {
            element.setAttribute("DigestAlgorithm", policyReference.getDigestAlgorithm());
        }
        for (Map.Entry<QName, String> object : policyReference.getOtherAttributes().entrySet()) {
            Attr attr = document.createAttributeNS(object.getKey().getNamespaceURI(), object.getKey().getLocalPart());
            attr.setValue(object.getValue());
            if (object.getKey().getNamespaceURI() != null && object.getKey().getNamespaceURI().trim().length() > 0) {
                attr.setPrefix(this.getPrefix(object.getKey()));
            }
            element.setAttributeNode(attr);
        }
        for (ExtensibleElement extensibleElement : policyReference.getExtensibilityElements()) {
            element.appendChild(document.importNode(extensibleElement.getNode(), true));
        }
        return element;
    }

    private Element createDOMElement(All all, Document document) throws ElementWriterException {
        Element element = document.createElementNS("http://www.w3.org/ns/ws-policy", "All");
        element.setPrefix(this.prefixMap.get("http://www.w3.org/ns/ws-policy"));
        for (PolicyElement policyElement : all.getChildren()) {
            Element element2 = this.createDOMElement(policyElement, document);
            element.appendChild(element2);
        }
        return element;
    }

    private Element createDOMElement(ExactlyOne exactlyOne, Document document) throws ElementWriterException {
        Element element = document.createElementNS("http://www.w3.org/ns/ws-policy", "ExactlyOne");
        element.setPrefix(this.prefixMap.get("http://www.w3.org/ns/ws-policy"));
        for (PolicyElement policyElement : exactlyOne.getChildren()) {
            Element element2 = this.createDOMElement(policyElement, document);
            element.appendChild(element2);
        }
        return element;
    }

    private Element createDOMElement(Assertion assertion, Document document) throws ElementWriterException {
        Iterator<Object> iterator;
        Element element = document.createElementNS(assertion.getName().getNamespaceURI(), assertion.getName().getLocalPart());
        if (assertion.getName().getNamespaceURI() != null && assertion.getName().getNamespaceURI().trim().length() > 0) {
            iterator = this.getPrefix(assertion.getName());
            element.setPrefix((String)((Object)iterator));
        }
        if (assertion.isOptional()) {
            iterator = document.createAttributeNS("http://www.w3.org/ns/ws-policy", "Optional");
            iterator.setPrefix(this.prefixMap.get("http://www.w3.org/ns/ws-policy"));
            iterator.setValue(Boolean.TRUE.toString());
            element.setAttributeNodeNS((Attr)((Object)iterator));
        }
        if (assertion.isIgnorable()) {
            iterator = document.createAttributeNS("http://www.w3.org/ns/ws-policy", "Ignorable");
            iterator.setPrefix(this.prefixMap.get("http://www.w3.org/ns/ws-policy"));
            iterator.setValue(Boolean.TRUE.toString());
            element.setAttributeNodeNS((Attr)((Object)iterator));
        }
        for (Map.Entry<QName, String> object : assertion.getAttributeParameters().entrySet()) {
            Attr attr = document.createAttributeNS(object.getKey().getNamespaceURI(), object.getKey().getLocalPart());
            attr.setValue(object.getValue());
            if (object.getKey().getNamespaceURI() != null && object.getKey().getNamespaceURI().trim().length() > 0) {
                attr.setPrefix(this.getPrefix(object.getKey()));
            }
            element.setAttributeNode(attr);
        }
        for (ExtensibleElement extensibleElement : assertion.getElementParameters()) {
            element.appendChild(document.importNode(extensibleElement.getNode(), true));
        }
        if (assertion.getNestedPolicy() != null) {
            element.appendChild(this.createDOMElement(assertion.getNestedPolicy(), document));
        }
        return element;
    }

    private Element createDOMElement(PolicyElement policyElement, Document document) throws ElementWriterException {
        if (policyElement instanceof Policy) {
            return this.createDOMElement((Policy)policyElement, document);
        }
        if (policyElement instanceof All) {
            return this.createDOMElement((All)policyElement, document);
        }
        if (policyElement instanceof ExactlyOne) {
            return this.createDOMElement((ExactlyOne)policyElement, document);
        }
        if (policyElement instanceof Assertion) {
            return this.createDOMElement((Assertion)policyElement, document);
        }
        if (policyElement instanceof PolicyReference) {
            return this.createDOMElement((PolicyReference)policyElement, document);
        }
        throw new ElementWriterException();
    }

    private String getPrefix(QName qName) {
        String string = null;
        if (this.prefixMap.containsKey(qName.getNamespaceURI())) {
            string = this.prefixMap.get(qName.getNamespaceURI());
        } else {
            string = qName.getPrefix();
            if (string == null || string.trim().length() == 0) {
                string = "wspns" + this.count.getAndIncrement();
            }
            this.prefixMap.put(qName.getNamespaceURI(), string);
        }
        return string;
    }
}

