/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wspolicy.internal.utils;

import com.ibm.wspolicy.datamodel.Assertion;
import com.ibm.wspolicy.datamodel.Policy;
import com.ibm.wspolicy.datamodel.PolicyElement;
import com.ibm.wspolicy.internal.PolicyConstants;
import com.ibm.wspolicy.internal.alternatives.Alternative;
import com.ibm.wspolicy.internal.alternatives.AlternativeCheckUtils;
import com.ibm.wspolicy.internal.domain.DomainAssertionHandlerRegistry;
import com.ibm.wspolicy.internal.utils.CompatibilityChecker;
import com.ibm.wspolicy.processor.PolicyProcessor;
import java.util.HashSet;
import java.util.Set;
import java.util.Vector;
import javax.xml.namespace.QName;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SupplementedCompatibilityCheck
implements CompatibilityChecker {
    Set<QName> p1ExtraBucket;
    Set<QName> p2ExtraBucket;
    PolicyConstants.IntersectionType intersectionType = PolicyConstants.IntersectionType.LAX;

    public SupplementedCompatibilityCheck(Set<QName> set, Set<QName> set2, PolicyConstants.IntersectionType intersectionType) {
        this.p1ExtraBucket = set;
        this.p2ExtraBucket = set2;
        this.intersectionType = intersectionType;
    }

    @Override
    public boolean isAlternativeCompatible(Alternative alternative, Alternative alternative2) {
        Set<QName> set;
        boolean bl;
        Set<QName> set2 = null;
        Set<QName> set3 = null;
        if (PolicyConstants.IntersectionType.LAX.equals((Object)this.intersectionType)) {
            set3 = alternative.getNonIgnorableVocabulary();
            set2 = alternative2.getNonIgnorableVocabulary();
        } else {
            set3 = alternative.getIncludedVocabulary();
            set2 = alternative2.getIncludedVocabulary();
        }
        HashSet<QName> hashSet = new HashSet<QName>();
        hashSet.addAll(set3);
        hashSet.addAll(set2);
        HashSet hashSet2 = new HashSet(hashSet);
        hashSet2.removeAll(set3);
        boolean bl2 = this.p1ExtraBucket.containsAll(hashSet2);
        HashSet hashSet3 = new HashSet(hashSet);
        hashSet3.removeAll(set2);
        boolean bl3 = this.p2ExtraBucket.containsAll(hashSet3);
        boolean bl4 = bl = bl2 && bl3;
        if (!bl && PolicyConstants.IntersectionType.LAX.equals((Object)this.intersectionType)) {
            set = alternative.getIncludedVocabulary();
            Set<QName> set4 = alternative2.getIncludedVocabulary();
            if (!bl2) {
                bl2 = set.containsAll(hashSet2);
            }
            if (!bl3) {
                bl3 = set4.containsAll(hashSet3);
            }
            boolean bl5 = bl = bl2 && bl3;
        }
        if (bl) {
            set = new HashSet<QName>(set3);
            set.retainAll(set2);
            for (QName qName : hashSet) {
                boolean bl6;
                if (set.contains(qName)) {
                    if (this.checkCompatibility(qName, alternative, alternative2)) continue;
                    bl = false;
                    break;
                }
                if (set3.contains(qName)) {
                    bl6 = true;
                    for (Assertion assertion : alternative.getAssertions()) {
                        bl6 = false;
                        if (!qName.equals(assertion.getName()) || !(bl6 = this.isCompatible(assertion, null))) continue;
                        break;
                    }
                    if (bl6) continue;
                    bl = false;
                    break;
                }
                bl6 = true;
                for (Assertion assertion : alternative2.getAssertions()) {
                    bl6 = false;
                    if (!qName.equals(assertion.getName()) || !(bl6 = this.isCompatible(null, assertion))) continue;
                    break;
                }
                if (bl6) continue;
                bl = false;
                break;
            }
        }
        return bl;
    }

    private boolean checkCompatibility(QName qName, Alternative alternative, Alternative alternative2) {
        for (Assertion assertion : alternative.getAssertions()) {
            if (!qName.equals(assertion.getName())) continue;
            boolean bl = false;
            for (Assertion assertion2 : alternative2.getAssertions()) {
                if (PolicyConstants.IntersectionType.STRICT.equals((Object)this.intersectionType) || PolicyConstants.IntersectionType.LAX.equals((Object)this.intersectionType) && !assertion.isIgnorable()) {
                    if (!assertion.getName().equals(assertion2.getName()) || !this.isCompatible(assertion, assertion2)) continue;
                    bl = true;
                    break;
                }
                if (!PolicyConstants.IntersectionType.LAX.equals((Object)this.intersectionType) || !assertion.isIgnorable()) continue;
                bl = true;
                break;
            }
            if (bl) continue;
            return false;
        }
        return true;
    }

    private boolean isCompatible(Assertion assertion, Assertion assertion2) {
        Alternative alternative;
        boolean bl;
        Object object2;
        Policy policy = null;
        Policy policy2 = null;
        if (assertion != null) {
            policy = assertion.getNestedPolicy();
        }
        if (assertion2 != null) {
            policy2 = assertion2.getNestedPolicy();
        }
        if (policy == null && policy2 == null) {
            return true;
        }
        Vector<Assertion> vector = new Vector<Assertion>();
        if (policy != null) {
            for (PolicyElement object22 : policy.getChildren()) {
                if (!(object22 instanceof Assertion)) continue;
                vector.add((Assertion)object22);
            }
        }
        Vector vector2 = new Vector();
        if (policy2 != null) {
            for (Object object2 : policy2.getChildren()) {
                if (!(object2 instanceof Assertion)) continue;
                vector2.add((Assertion)object2);
            }
        }
        if (bl = this.isAlternativeCompatible(alternative = new Alternative(vector), (Alternative)(object2 = new Alternative(vector2)))) {
            // empty if block
        }
        return bl;
    }

    @Override
    public Alternative checkIfSupportedAndMergeAssertionsIfPossible(DomainAssertionHandlerRegistry domainAssertionHandlerRegistry, Alternative alternative, Alternative alternative2, PolicyProcessor.FilterType filterType, PolicyConstants.IntersectionType intersectionType) {
        Vector<Assertion> vector = new Vector<Assertion>(alternative.getAssertions().size() + alternative2.getAssertions().size());
        Alternative alternative3 = null;
        vector.addAll(alternative.getAssertions());
        vector.addAll(alternative2.getAssertions());
        alternative3 = new Alternative(vector);
        boolean bl = AlternativeCheckUtils.checkIfSupportedAndMergeAssertionsIfPossible(domainAssertionHandlerRegistry, alternative3, filterType, intersectionType);
        if (bl) {
            return alternative3;
        }
        return null;
    }
}

