/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wspolicy.internal.utils;

import com.ibm.wspolicy.datamodel.Assertion;
import com.ibm.wspolicy.datamodel.Policy;
import com.ibm.wspolicy.internal.PolicyConstants;
import com.ibm.wspolicy.internal.alternatives.Alternative;
import com.ibm.wspolicy.internal.alternatives.AlternativeCheckUtils;
import com.ibm.wspolicy.internal.domain.DomainAssertionHandlerRegistry;
import com.ibm.wspolicy.internal.utils.CompatibilityChecker;
import com.ibm.wspolicy.internal.utils.CoreUtils;
import com.ibm.wspolicy.processor.PolicyProcessor;
import java.util.Vector;

public class LogicalCompatibilityCheck
implements CompatibilityChecker {
    PolicyConstants.IntersectionType intersectionType = PolicyConstants.IntersectionType.LAX;

    public LogicalCompatibilityCheck(PolicyConstants.IntersectionType intersectionType) {
        this.intersectionType = intersectionType;
    }

    public boolean isAlternativeCompatible(Alternative alternative, Alternative alternative2) {
        boolean bl = this.isCompatible(alternative, alternative2);
        if (!bl) {
            return false;
        }
        bl = this.isCompatible(alternative2, alternative);
        return bl;
    }

    private boolean isCompatible(Alternative alternative, Alternative alternative2) {
        boolean bl = true;
        for (Assertion assertion : alternative.getAssertions()) {
            boolean bl2 = false;
            for (Assertion assertion2 : alternative2.getAssertions()) {
                if (PolicyConstants.IntersectionType.STRICT.equals((Object)this.intersectionType) || PolicyConstants.IntersectionType.LAX.equals((Object)this.intersectionType) && !assertion.isIgnorable()) {
                    if (!assertion.getName().equals(assertion2.getName())) continue;
                    if (assertion.getNestedPolicy() != null) {
                        if (!this.isCompatibleNested(assertion, assertion2)) continue;
                        bl2 = true;
                        break;
                    }
                    bl2 = true;
                    break;
                }
                if (!PolicyConstants.IntersectionType.LAX.equals((Object)this.intersectionType) || !assertion.isIgnorable()) continue;
                bl2 = true;
                break;
            }
            if (bl2) continue;
            bl = false;
            break;
        }
        return bl;
    }

    private boolean isCompatibleNested(Assertion assertion, Assertion assertion2) {
        Policy policy = assertion.getNestedPolicy();
        Policy policy2 = assertion2.getNestedPolicy();
        if (policy == null || policy2 == null) {
            return true;
        }
        Alternative alternative = CoreUtils.getQuickAlternativeForSingularizedPolicy(policy);
        Alternative alternative2 = CoreUtils.getQuickAlternativeForSingularizedPolicy(policy2);
        return this.isAlternativeCompatible(alternative, alternative2);
    }

    public Alternative checkIfSupportedAndMergeAssertionsIfPossible(DomainAssertionHandlerRegistry domainAssertionHandlerRegistry, Alternative alternative, Alternative alternative2, PolicyProcessor.FilterType filterType, PolicyConstants.IntersectionType intersectionType) {
        Vector<Assertion> vector = new Vector<Assertion>(alternative.getAssertions().size() + alternative2.getAssertions().size());
        vector.addAll(alternative.getAssertions());
        vector.addAll(alternative2.getAssertions());
        Alternative alternative3 = new Alternative(vector);
        boolean bl = AlternativeCheckUtils.checkIfSupportedAndMergeAssertionsIfPossible(domainAssertionHandlerRegistry, alternative3, filterType, intersectionType);
        if (bl) {
            return alternative3;
        }
        return null;
    }
}

