/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wspolicy.internal.utils;

import com.ibm.wspolicy.PolicyReferenceException;
import com.ibm.wspolicy.datamodel.Assertion;
import com.ibm.wspolicy.datamodel.Policy;
import com.ibm.wspolicy.factory.DataModelFactory;
import com.ibm.wspolicy.internal.PolicyConstants;
import com.ibm.wspolicy.internal.alternatives.Alternative;
import com.ibm.wspolicy.internal.alternatives.AlternativesIterator;
import com.ibm.wspolicy.internal.alternatives.NormalizeUtils;
import com.ibm.wspolicy.internal.domain.DomainAssertionHandlerRegistry;
import com.ibm.wspolicy.internal.utils.CompatibilityChecker;
import com.ibm.wspolicy.internal.utils.LogicalCompatibilityCheck;
import com.ibm.wspolicy.processor.DataModelUtility;
import com.ibm.wspolicy.processor.PolicyProcessor;
import java.util.Iterator;
import java.util.NoSuchElementException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IntersectedAlternativeIterator
implements Iterator<PolicyProcessor.Alternative> {
    DomainAssertionHandlerRegistry dahr;
    DataModelFactory dmf;
    PolicyConstants.IntersectionType mode;
    PolicyProcessor.FilterType type;
    AlternativesIterator p1iter;
    AlternativesIterator p2iter;
    Alternative p1alt = null;
    Alternative nextAlt = null;
    boolean normalizeAlts = false;
    CompatibilityChecker cc;

    public IntersectedAlternativeIterator(DomainAssertionHandlerRegistry domainAssertionHandlerRegistry, DataModelFactory dataModelFactory, DataModelUtility dataModelUtility, Policy policy, Policy policy2, PolicyProcessor.FilterType filterType, PolicyConstants.IntersectionType intersectionType, boolean bl) throws PolicyReferenceException {
        this.cc = new LogicalCompatibilityCheck(intersectionType);
        this.p1iter = new AlternativesIterator(domainAssertionHandlerRegistry, dataModelUtility, policy, filterType);
        this.p2iter = new AlternativesIterator(domainAssertionHandlerRegistry, dataModelUtility, policy2, filterType);
        this.dahr = domainAssertionHandlerRegistry;
        this.dmf = dataModelFactory;
        this.mode = intersectionType;
        this.type = filterType;
        this.normalizeAlts = bl;
        this.nextAlt = this.internalNext();
    }

    public IntersectedAlternativeIterator(DomainAssertionHandlerRegistry domainAssertionHandlerRegistry, DataModelFactory dataModelFactory, DataModelUtility dataModelUtility, Policy policy, Policy policy2, PolicyProcessor.FilterType filterType, PolicyConstants.IntersectionType intersectionType, boolean bl, CompatibilityChecker compatibilityChecker) throws PolicyReferenceException {
        this.cc = compatibilityChecker;
        this.p1iter = new AlternativesIterator(domainAssertionHandlerRegistry, dataModelUtility, policy, filterType);
        this.p2iter = new AlternativesIterator(domainAssertionHandlerRegistry, dataModelUtility, policy2, filterType);
        this.dahr = domainAssertionHandlerRegistry;
        this.dmf = dataModelFactory;
        this.mode = intersectionType;
        this.type = filterType;
        this.normalizeAlts = bl;
        this.nextAlt = this.internalNext();
    }

    @Override
    public boolean hasNext() {
        return this.nextAlt != null;
    }

    @Override
    public Alternative next() {
        if (this.nextAlt != null) {
            Alternative alternative = this.nextAlt;
            this.nextAlt = this.internalNext();
            return alternative;
        }
        throw new NoSuchElementException();
    }

    private Alternative internalNext() {
        Alternative alternative = null;
        boolean bl = false;
        while (!bl) {
            Alternative alternative2 = null;
            if (this.p1alt != null && !this.p2iter.hasNext()) {
                this.p2iter.reset();
                this.p1alt = null;
            }
            if (this.p1alt == null && this.p1iter.hasNext()) {
                this.p1alt = this.p1iter.next();
            }
            if (this.p1alt != null && this.p2iter.hasNext()) {
                alternative2 = this.p2iter.next();
            }
            if (this.p1alt != null && alternative2 != null) {
                Alternative alternative3;
                if (!this.cc.isAlternativeCompatible(this.p1alt, alternative2) || (alternative3 = this.cc.checkIfSupportedAndMergeAssertionsIfPossible(this.dahr, this.p1alt, alternative2, this.type, this.mode)) == null) continue;
                for (Assertion assertion : alternative3.getAssertions()) {
                    if (!this.normalizeAlts) continue;
                    NormalizeUtils.completeNormalisedStructure(this.dmf, assertion);
                }
                alternative = alternative3;
                bl = true;
                continue;
            }
            bl = true;
        }
        return alternative;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }
}

