/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wspolicy.internal.utils;

import com.ibm.wspolicy.datamodel.Assertion;
import com.ibm.wspolicy.datamodel.Operator;
import com.ibm.wspolicy.datamodel.Policy;
import com.ibm.wspolicy.datamodel.PolicyElement;
import com.ibm.wspolicy.internal.alternatives.Alternative;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.xml.namespace.QName;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CoreUtils {
    public static List<Assertion> getAllAssertionsForPolicy(Policy policy) {
        return CoreUtils.recursiveReturnChildAssertionsForPolicyElement(policy);
    }

    public static List<Assertion> recursiveReturnChildAssertionsForPolicyElement(PolicyElement policyElement) {
        ArrayList<Assertion> arrayList = new ArrayList<Assertion>();
        CoreUtils.populateAssertionList(policyElement, arrayList);
        return arrayList;
    }

    public static void populateAssertionList(PolicyElement policyElement, List<Assertion> list) {
        if (policyElement instanceof Assertion) {
            list.add((Assertion)policyElement);
        } else if (policyElement instanceof Operator) {
            Operator operator = (Operator)policyElement;
            for (PolicyElement policyElement2 : operator.getChildren()) {
                CoreUtils.populateAssertionList(policyElement2, list);
            }
        }
    }

    public static Set<QName> getVocabulary(Policy policy) {
        HashSet<QName> hashSet = new HashSet<QName>();
        CoreUtils.populateVocabularySet(policy, hashSet);
        return hashSet;
    }

    private static void populateVocabularySet(PolicyElement policyElement, Set<QName> set) {
        if (policyElement instanceof Assertion) {
            set.add(((Assertion)policyElement).getName());
        } else if (policyElement instanceof Operator) {
            Operator operator = (Operator)policyElement;
            for (PolicyElement policyElement2 : operator.getChildren()) {
                CoreUtils.populateVocabularySet(policyElement2, set);
            }
        }
    }

    public static Alternative getQuickAlternativeForSingularizedPolicy(Policy policy) {
        Alternative alternative = new Alternative(CoreUtils.getAllAssertionsForPolicy(policy));
        return alternative;
    }
}

