/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wspolicy.internal.processor;

import com.ibm.webservices.component.logging.Tr;
import com.ibm.webservices.component.logging.TraceComponent;
import com.ibm.wspolicy.PolicyReferenceException;
import com.ibm.wspolicy.datamodel.All;
import com.ibm.wspolicy.datamodel.Assertion;
import com.ibm.wspolicy.datamodel.ExactlyOne;
import com.ibm.wspolicy.datamodel.Operator;
import com.ibm.wspolicy.datamodel.Policy;
import com.ibm.wspolicy.datamodel.PolicyElement;
import com.ibm.wspolicy.datamodel.PolicyReference;
import com.ibm.wspolicy.factory.DataModelFactory;
import com.ibm.wspolicy.factory.WSPolicyFactory;
import com.ibm.wspolicy.internal.PolicyConstants;
import com.ibm.wspolicy.internal.alternatives.Alternative;
import com.ibm.wspolicy.internal.alternatives.AlternativesIterator;
import com.ibm.wspolicy.internal.alternatives.NormalizeUtils;
import com.ibm.wspolicy.internal.domain.DomainAssertionHandlerRegistry;
import com.ibm.wspolicy.internal.factory.InternalFactoryConfiguration;
import com.ibm.wspolicy.internal.utils.CompatibilityChecker;
import com.ibm.wspolicy.internal.utils.IntersectedAlternativeIterator;
import com.ibm.wspolicy.internal.utils.LogicalCompatibilityCheck;
import com.ibm.wspolicy.internal.utils.SupplementedCompatibilityCheck;
import com.ibm.wspolicy.processor.DataModelUtility;
import com.ibm.wspolicy.processor.PolicyProcessor;
import com.ibm.wspolicy.processor.PolicyReferenceResolver;
import com.ibm.wspolicy.processor.VocabularyConflictException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.Vector;
import javax.xml.namespace.QName;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PolicyProcessorImpl
implements PolicyProcessor {
    private static final TraceComponent tc = Tr.register(PolicyProcessorImpl.class, "WS-Policy", "com.ibm.ws.wspolicy.resources.CWPOLMessages");
    private final InternalFactoryConfiguration _ifc;
    private final DataModelFactory _dmf;
    private final DataModelUtility _dmu;
    private final WSPolicyFactory _wspf;
    private final DomainAssertionHandlerRegistry _dahr;
    public static final QName WSU_ID = new QName("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd", "Id");
    public static final QName XML_ID = new QName("http://www.w3.org/XML/1998/namespace", "id");

    @Override
    public PolicyProcessor.Alternative combineAlternatives(PolicyProcessor.Alternative alternative, PolicyProcessor.Alternative alternative2) throws VocabularyConflictException {
        Set<QName> set = alternative.getIncludedVocabulary();
        Set<QName> set2 = alternative.getNegatedVocabulary();
        Set<QName> set3 = alternative2.getIncludedVocabulary();
        Set<QName> set4 = alternative2.getNegatedVocabulary();
        for (QName serializable2 : set) {
            if (!set4.contains(serializable2)) continue;
            if (tc.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Addition forbidden since QName[" + serializable2 + "] is both negated and stated in a vocabulary:qNamesNegatedTwo.contains(qName)");
            }
            throw new VocabularyConflictException();
        }
        for (QName qName : set3) {
            if (!set2.contains(qName)) continue;
            if (tc.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Addition forbidden since QName[" + qName + "] is both negated and stated in a vocabulary:qNamesNegatedOne.contains(qName)");
            }
            throw new VocabularyConflictException();
        }
        for (QName qName : set) {
            if (!set3.contains(qName) || this._dahr.hasMergeBehavior(qName)) continue;
            if (tc.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Addition forbidden since QName[" + qName + "] is stated in both vocabularies:qNamesVocabTwo.contains(qName)");
            }
            throw new VocabularyConflictException();
        }
        Alternative alternative3 = new Alternative(new Vector<Assertion>());
        alternative3.getAssertions().addAll(alternative.getAssertions());
        alternative3.getAssertions().addAll(alternative2.getAssertions());
        HashSet<QName> hashSet = new HashSet<QName>(alternative.getNegatedVocabulary());
        hashSet.addAll(alternative2.getNegatedVocabulary());
        alternative3.setExplicitNegationQNames(hashSet);
        return alternative3;
    }

    @Override
    public Policy createPolicy(PolicyProcessor.Alternative alternative) {
        Policy policy = this._dmf.createPolicy();
        ExactlyOne exactlyOne = this._dmf.createExactlyOne();
        policy.getChildren().add(exactlyOne);
        All all = this._dmf.createAll();
        exactlyOne.getChildren().add(all);
        all.getChildren().addAll(alternative.getAssertions());
        return policy;
    }

    @Override
    public Policy createPolicy(Iterable<PolicyProcessor.Alternative> iterable) {
        Policy policy = this._dmf.createPolicy();
        ExactlyOne exactlyOne = this._dmf.createExactlyOne();
        policy.getChildren().add(exactlyOne);
        for (PolicyProcessor.Alternative alternative : iterable) {
            All all = this._dmf.createAll();
            exactlyOne.getChildren().add(all);
            all.getChildren().addAll(alternative.getAssertions());
        }
        return policy;
    }

    @Override
    public Iterable<PolicyProcessor.Alternative> getAlternatives(Policy policy) {
        return new AlternativeCollectionImpl(this._dahr, this._dmu, policy, PolicyProcessor.FilterType.LOGICAL);
    }

    @Override
    public Iterable<PolicyProcessor.Alternative> getAlternatives(Policy policy, PolicyProcessor.FilterType filterType) {
        return new AlternativeCollectionImpl(this._dahr, this._dmu, policy, filterType);
    }

    @Override
    public PolicyProcessor.Alternative getSingleAlternative(Policy policy) throws PolicyReferenceException {
        AlternativesIterator alternativesIterator = new AlternativesIterator(this._dahr, this._dmu, policy);
        if (alternativesIterator.hasNext()) {
            return alternativesIterator.next();
        }
        return null;
    }

    @Override
    public Iterable<PolicyProcessor.Alternative> intersect(Policy policy, Policy policy2, boolean bl) throws PolicyReferenceException {
        return new IntersectingAlternativeCollectionImpl(this._dahr, this._dmf, this._dmu, policy, policy2, PolicyProcessor.FilterType.LOGICAL, bl, null);
    }

    @Override
    public PolicyProcessor.Alternative getSingleAlternative(Policy policy, PolicyProcessor.FilterType filterType) throws PolicyReferenceException {
        AlternativesIterator alternativesIterator = new AlternativesIterator(this._dahr, this._dmu, policy, filterType);
        if (alternativesIterator.hasNext()) {
            return alternativesIterator.next();
        }
        return null;
    }

    @Override
    public Iterable<PolicyProcessor.Alternative> intersect(Policy policy, Policy policy2, boolean bl, PolicyProcessor.FilterType filterType) throws PolicyReferenceException {
        IntersectingAlternativeCollectionImpl intersectingAlternativeCollectionImpl = new IntersectingAlternativeCollectionImpl(this._dahr, this._dmf, this._dmu, policy, policy2, filterType, bl, null);
        return intersectingAlternativeCollectionImpl;
    }

    @Override
    public Iterable<PolicyProcessor.Alternative> supplementedIntersect(Policy policy, Set<QName> set, Policy policy2, Set<QName> set2, boolean bl, PolicyProcessor.FilterType filterType) throws PolicyReferenceException {
        PolicyConstants.IntersectionType intersectionType = bl ? PolicyConstants.IntersectionType.STRICT : PolicyConstants.IntersectionType.LAX;
        SupplementedCompatibilityCheck supplementedCompatibilityCheck = new SupplementedCompatibilityCheck(set, set2, intersectionType);
        IntersectingAlternativeCollectionImpl intersectingAlternativeCollectionImpl = new IntersectingAlternativeCollectionImpl(this._dahr, this._dmf, this._dmu, policy, policy2, filterType, bl, supplementedCompatibilityCheck);
        return intersectingAlternativeCollectionImpl;
    }

    @Override
    public boolean isPolicyNull(Policy policy) throws PolicyReferenceException {
        boolean bl = false;
        AlternativesIterator alternativesIterator = new AlternativesIterator(this._dahr, this._dmu, policy);
        if (alternativesIterator != null && !alternativesIterator.hasNext()) {
            bl = true;
        }
        return bl;
    }

    @Override
    public boolean isPolicyEmpty(Policy policy) throws PolicyReferenceException {
        Alternative alternative;
        List<Assertion> list;
        boolean bl = false;
        AlternativesIterator alternativesIterator = new AlternativesIterator(this._dahr, this._dmu, policy);
        if (alternativesIterator != null && alternativesIterator.hasNext() && (list = (alternative = alternativesIterator.next()).getAssertions()).size() == 0) {
            bl = true;
        }
        return bl;
    }

    public PolicyProcessorImpl(InternalFactoryConfiguration internalFactoryConfiguration) {
        this._ifc = internalFactoryConfiguration;
        this._dmf = this._ifc.getDataModelFactory();
        this._dmu = this._ifc.getDataModelUtility();
        this._wspf = internalFactoryConfiguration.getWSPolicyFactory();
        this._dahr = this._ifc.getAssertionProcessorRegistry();
    }

    @Override
    public Policy merge(Policy policy, Policy policy2) throws PolicyReferenceException {
        boolean bl;
        Policy policy3 = this._dmf.createPolicy();
        ExactlyOne exactlyOne = this._dmf.createExactlyOne();
        AlternativesIterator alternativesIterator = new AlternativesIterator(this._dahr, this._dmu, policy);
        AlternativesIterator alternativesIterator2 = new AlternativesIterator(this._dahr, this._dmu, policy2);
        boolean bl2 = alternativesIterator.hasNext();
        boolean bl3 = bl = alternativesIterator2.hasNext();
        if (bl2 && bl) {
            while (alternativesIterator.hasNext()) {
                Alternative alternative = alternativesIterator.next();
                alternativesIterator2.reset();
                while (alternativesIterator2.hasNext()) {
                    Alternative alternative2 = alternativesIterator2.next();
                    Vector<Assertion> vector = new Vector<Assertion>(alternative.getAssertions());
                    vector.addAll(alternative2.getAssertions());
                    for (Assertion assertion : vector) {
                        NormalizeUtils.completeNormalisedStructure(this._dmf, assertion);
                    }
                    All all = this._dmf.createAll();
                    all.getChildren().addAll(vector);
                    exactlyOne.getChildren().add(all);
                }
            }
        }
        policy3.getChildren().add(exactlyOne);
        return policy3;
    }

    @Override
    public Policy normalize(Policy policy) throws PolicyReferenceException {
        return NormalizeUtils.normalizePolicy(this._dahr, this._dmf, this._dmu, policy);
    }

    @Override
    public boolean policyContainsPolicyReferences(Policy policy) {
        return this.internalPolicyContainsPolicyReferences(policy);
    }

    private boolean internalPolicyContainsPolicyReferences(PolicyElement policyElement) {
        Assertion assertion;
        if (policyElement instanceof Operator) {
            for (PolicyElement policyElement2 : ((Operator)policyElement).getChildren()) {
                if (!(policyElement2 instanceof Operator ? this.internalPolicyContainsPolicyReferences(policyElement2) : (policyElement2 instanceof Assertion ? this.internalPolicyContainsPolicyReferences(policyElement2) : policyElement2 instanceof PolicyReference))) continue;
                return true;
            }
        } else if (policyElement instanceof Assertion && (assertion = (Assertion)policyElement).getNestedPolicy() != null) {
            return this.internalPolicyContainsPolicyReferences(assertion.getNestedPolicy());
        }
        return false;
    }

    @Override
    public Policy resolvePolicyReference(PolicyReference policyReference, PolicyReferenceResolver ... policyReferenceResolverArray) {
        for (PolicyReferenceResolver policyReferenceResolver : policyReferenceResolverArray) {
            Policy policy = policyReferenceResolver.resolveReference(this._wspf, policyReference);
            if (policy == null) continue;
            return policy;
        }
        return this.internalResolvePolicyReference(policyReference);
    }

    @Override
    public boolean resolvePolicyReferences(Policy policy, Set<PolicyReference> set, PolicyReferenceResolver ... policyReferenceResolverArray) {
        Set<PolicyReference> set2 = this.internalResolvePolicyReferences(policy, new HashSet<String>(), policyReferenceResolverArray);
        if (set != null) {
            set.addAll(set2);
        }
        return set2.isEmpty();
    }

    public Policy internalResolvePolicyReference(PolicyReference policyReference) {
        for (PolicyReferenceResolver policyReferenceResolver : this._ifc.getResolvers()) {
            Policy policy = policyReferenceResolver.resolveReference(this._wspf, policyReference);
            if (policy == null) continue;
            return policy;
        }
        return null;
    }

    @Override
    public boolean resolvePolicyReferences(Policy policy, PolicyReferenceResolver ... policyReferenceResolverArray) {
        return this.internalResolvePolicyReferences(policy, new HashSet<String>(), policyReferenceResolverArray).isEmpty();
    }

    private Set<PolicyReference> internalResolvePolicyReferences(PolicyElement policyElement, Set<String> set, PolicyReferenceResolver ... policyReferenceResolverArray) {
        Assertion assertion;
        HashSet<PolicyReference> hashSet = new HashSet<PolicyReference>();
        if (policyElement instanceof Operator) {
            ArrayList<PolicyElement> arrayList = new ArrayList<PolicyElement>();
            for (PolicyElement policyElement2 : ((Operator)policyElement).getChildren()) {
                if (policyElement2 instanceof Operator) {
                    hashSet.addAll(this.internalResolvePolicyReferences(policyElement2, set, policyReferenceResolverArray));
                    arrayList.add(policyElement2);
                    continue;
                }
                if (policyElement2 instanceof Assertion) {
                    hashSet.addAll(this.internalResolvePolicyReferences(policyElement2, set, policyReferenceResolverArray));
                    arrayList.add(policyElement2);
                    continue;
                }
                if (!(policyElement2 instanceof PolicyReference)) continue;
                PolicyReference policyReference = (PolicyReference)policyElement2;
                Policy policy = null;
                if (!set.contains(policyReference.getURI())) {
                    policy = this.resolvePolicyReference((PolicyReference)policyElement2, policyReferenceResolverArray);
                }
                if (policy != null) {
                    All all = this._ifc.getDataModelFactory().createAll();
                    set.add(policyReference.getURI());
                    hashSet.addAll(this.internalResolvePolicyReferences(policy, set, policyReferenceResolverArray));
                    set.remove(policyReference.getURI());
                    all.getChildren().addAll(policy.getChildren());
                    arrayList.add(all);
                    continue;
                }
                arrayList.add(policyElement2);
                hashSet.add(policyReference);
            }
            Operator operator = (Operator)policyElement;
            operator.getChildren().clear();
            operator.getChildren().addAll(arrayList);
        } else if (policyElement instanceof Assertion && (assertion = (Assertion)policyElement).getNestedPolicy() != null) {
            hashSet.addAll(this.internalResolvePolicyReferences(assertion.getNestedPolicy(), set, policyReferenceResolverArray));
        }
        return hashSet;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class IntersectingAlternativeCollectionImpl
    implements Iterable<PolicyProcessor.Alternative> {
        Policy policy1;
        Policy policy2;
        DataModelFactory dmf;
        DataModelUtility dmu;
        DomainAssertionHandlerRegistry dahr;
        PolicyProcessor.FilterType filterType;
        PolicyConstants.IntersectionType intersectionType = PolicyConstants.IntersectionType.LAX;
        CompatibilityChecker compatibilityChecker;

        IntersectingAlternativeCollectionImpl(DomainAssertionHandlerRegistry domainAssertionHandlerRegistry, DataModelFactory dataModelFactory, DataModelUtility dataModelUtility, Policy policy, Policy policy2, PolicyProcessor.FilterType filterType, boolean bl, CompatibilityChecker compatibilityChecker) {
            this.policy1 = policy;
            this.policy2 = policy2;
            this.dahr = domainAssertionHandlerRegistry;
            this.dmf = dataModelFactory;
            this.dmu = dataModelUtility;
            this.filterType = filterType;
            if (bl) {
                this.intersectionType = PolicyConstants.IntersectionType.STRICT;
            }
            this.compatibilityChecker = compatibilityChecker != null ? compatibilityChecker : new LogicalCompatibilityCheck(this.intersectionType);
        }

        @Override
        public Iterator<PolicyProcessor.Alternative> iterator() {
            try {
                return new IntersectedAlternativeIterator(this.dahr, this.dmf, this.dmu, this.policy1, this.policy2, this.filterType, this.intersectionType, true, this.compatibilityChecker);
            }
            catch (PolicyReferenceException policyReferenceException) {
                if (tc.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "IntersectingAlternativeCollectionImpl.iterator() caught exception ", policyReferenceException);
                }
                Tr.processException(policyReferenceException, "com.ibm.wspolicy.internal.processor.PolicyProcessorImpl.IntersectingAlternativeCollectionImpl.iterator", "135");
                throw new RuntimeException(policyReferenceException);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class AlternativeCollectionImpl
    implements Iterable<PolicyProcessor.Alternative> {
        Policy policy;
        DataModelUtility dmu;
        DomainAssertionHandlerRegistry dahr;
        PolicyProcessor.FilterType filterType;

        AlternativeCollectionImpl(DomainAssertionHandlerRegistry domainAssertionHandlerRegistry, DataModelUtility dataModelUtility, Policy policy, PolicyProcessor.FilterType filterType) {
            this.policy = policy;
            this.dmu = dataModelUtility;
            this.dahr = domainAssertionHandlerRegistry;
            this.filterType = filterType;
        }

        @Override
        public Iterator<PolicyProcessor.Alternative> iterator() {
            try {
                return new AlternativesIterator(this.dahr, this.dmu, this.policy, this.filterType);
            }
            catch (PolicyReferenceException policyReferenceException) {
                if (tc.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "AlternativesIterator.iterator() caught exception ", policyReferenceException);
                }
                Tr.processException(policyReferenceException, "com.ibm.wspolicy.internal.processor.PolicyProcessorImpl.AlternativeCollectionImpl.iterator", "96");
                throw new RuntimeException(policyReferenceException);
            }
        }
    }
}

