/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wspolicy.internal.processor;

import com.ibm.webservices.component.logging.Tr;
import com.ibm.webservices.component.logging.TraceComponent;
import com.ibm.wspolicy.WSPolicyException;
import com.ibm.wspolicy.datamodel.All;
import com.ibm.wspolicy.datamodel.Assertion;
import com.ibm.wspolicy.datamodel.ExactlyOne;
import com.ibm.wspolicy.datamodel.ExtensibleElement;
import com.ibm.wspolicy.datamodel.Policy;
import com.ibm.wspolicy.datamodel.PolicyElement;
import com.ibm.wspolicy.datamodel.PolicyReference;
import com.ibm.wspolicy.factory.DataModelFactory;
import com.ibm.wspolicy.internal.datamodel.DOMExtensibleElement;
import com.ibm.wspolicy.internal.utils.CoreUtils;
import com.ibm.wspolicy.processor.DataModelUtility;
import java.util.List;
import java.util.Set;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class DataModelUtilityImpl
implements DataModelUtility {
    private static final TraceComponent tc = Tr.register(DataModelUtility.class, "WS-Policy", "com.ibm.ws.wspolicy.resources.CWPOLMessages");
    private final DataModelFactory dmf;

    public DataModelUtilityImpl(DataModelFactory dataModelFactory) {
        this.dmf = dataModelFactory;
    }

    @Override
    public String getTextParameter(Assertion assertion) throws WSPolicyException {
        String string = null;
        List<ExtensibleElement> list = assertion.getElementParameters();
        if (list.size() != 1) {
            if (tc.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "ExtensibleElement list size not 1 " + list.size());
            }
            throw new WSPolicyException();
        }
        ExtensibleElement extensibleElement = list.get(0);
        Node node = extensibleElement.getNode();
        if (node.getNodeType() != 3) {
            if (tc.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Node type not TEXT_NODE " + node.getNodeType());
            }
            throw new WSPolicyException();
        }
        string = node.getTextContent();
        return string;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void setTextParameter(Assertion assertion, String string) throws WSPolicyException {
        List<ExtensibleElement> list = assertion.getElementParameters();
        if (list.size() == 0) {
            DOMExtensibleElement dOMExtensibleElement = new DOMExtensibleElement();
            Text text = null;
            try {
                DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
                documentBuilderFactory.setNamespaceAware(true);
                DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
                Document document = documentBuilder.newDocument();
                text = document.createTextNode(string);
            }
            catch (Exception exception) {
                if (tc.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "Caught Exception ", exception);
                }
                Tr.processException(exception, "com.ibm.wspolicy.internal.processor.DataModelUtilityImpl.getTextParameter", "108");
                throw (WSPolicyException)new WSPolicyException().initCause(exception);
            }
            dOMExtensibleElement.setNode(text);
            list.add(dOMExtensibleElement);
            return;
        }
        if (list.size() != 1) {
            if (!tc.isAnyTracingEnabled()) throw new WSPolicyException();
            if (!tc.isDebugEnabled()) throw new WSPolicyException();
            Tr.debug(tc, "ExtensibleElement list size not 1 " + list.size());
            throw new WSPolicyException();
        }
        ExtensibleElement extensibleElement = list.get(0);
        Node node = extensibleElement.getNode();
        if (node.getNodeType() == 3) {
            node.setTextContent(string);
            return;
        }
        if (!tc.isAnyTracingEnabled()) throw new WSPolicyException();
        if (!tc.isDebugEnabled()) throw new WSPolicyException();
        Tr.debug(tc, "Node type not TEXT_NODE " + node.getNodeType());
        throw new WSPolicyException();
    }

    @Override
    public Set<QName> getVocabulary(Policy policy) {
        return CoreUtils.getVocabulary(policy);
    }

    @Override
    public All createAll(All all) {
        All all2 = this.dmf.createAll();
        for (PolicyElement policyElement : all.getChildren()) {
            if (policyElement instanceof Policy) {
                all2.getChildren().add(this.createPolicy((Policy)policyElement));
                continue;
            }
            if (policyElement instanceof All) {
                all2.getChildren().add(this.createAll((All)policyElement));
                continue;
            }
            if (policyElement instanceof ExactlyOne) {
                all2.getChildren().add(this.createExactlyOne((ExactlyOne)policyElement));
                continue;
            }
            if (policyElement instanceof PolicyReference) {
                all2.getChildren().add(this.createPolicyReference((PolicyReference)policyElement));
                continue;
            }
            if (!(policyElement instanceof Assertion)) continue;
            all2.getChildren().add(this.createAssertion((Assertion)policyElement));
        }
        return all2;
    }

    @Override
    public Assertion createAssertion(Assertion assertion) {
        Assertion assertion2 = this.dmf.createAssertion(assertion.getName());
        assertion2.setOptional(assertion.isOptional());
        assertion2.setIgnorable(assertion.isIgnorable());
        if (assertion.getNestedPolicy() != null) {
            Policy policy = this.createPolicy(assertion.getNestedPolicy());
            assertion2.setNestedPolicy(policy);
        }
        assertion2.getAttributeParameters().putAll(assertion.getAttributeParameters());
        for (ExtensibleElement extensibleElement : assertion.getElementParameters()) {
            ExtensibleElement extensibleElement2 = this.createExtensibleElement(extensibleElement);
            if (extensibleElement2 == null) continue;
            assertion2.getElementParameters().add(extensibleElement2);
        }
        return assertion2;
    }

    @Override
    public ExactlyOne createExactlyOne(ExactlyOne exactlyOne) {
        ExactlyOne exactlyOne2 = this.dmf.createExactlyOne();
        for (PolicyElement policyElement : exactlyOne.getChildren()) {
            if (policyElement instanceof Policy) {
                exactlyOne2.getChildren().add(this.createPolicy((Policy)policyElement));
                continue;
            }
            if (policyElement instanceof All) {
                exactlyOne2.getChildren().add(this.createAll((All)policyElement));
                continue;
            }
            if (policyElement instanceof ExactlyOne) {
                exactlyOne2.getChildren().add(this.createExactlyOne((ExactlyOne)policyElement));
                continue;
            }
            if (policyElement instanceof PolicyReference) {
                exactlyOne2.getChildren().add(this.createPolicyReference((PolicyReference)policyElement));
                continue;
            }
            if (!(policyElement instanceof Assertion)) continue;
            exactlyOne2.getChildren().add(this.createAssertion((Assertion)policyElement));
        }
        return exactlyOne2;
    }

    @Override
    public Policy createPolicy(Policy policy) {
        Policy policy2 = this.dmf.createPolicy();
        policy2.setName(policy.getName());
        policy2.getOtherAttributes().putAll(policy.getOtherAttributes());
        for (PolicyElement policyElement : policy.getChildren()) {
            if (policyElement instanceof Policy) {
                policy2.getChildren().add(this.createPolicy((Policy)policyElement));
                continue;
            }
            if (policyElement instanceof All) {
                policy2.getChildren().add(this.createAll((All)policyElement));
                continue;
            }
            if (policyElement instanceof ExactlyOne) {
                policy2.getChildren().add(this.createExactlyOne((ExactlyOne)policyElement));
                continue;
            }
            if (policyElement instanceof PolicyReference) {
                policy2.getChildren().add(this.createPolicyReference((PolicyReference)policyElement));
                continue;
            }
            if (!(policyElement instanceof Assertion)) continue;
            policy2.getChildren().add(this.createAssertion((Assertion)policyElement));
        }
        return policy2;
    }

    @Override
    public PolicyReference createPolicyReference(PolicyReference policyReference) {
        PolicyReference policyReference2 = this.dmf.createPolicyReference();
        policyReference2.setURI(policyReference.getURI());
        policyReference2.setDigest(policyReference.getDigest());
        policyReference2.setDigestAlgorithm(policyReference.getDigestAlgorithm());
        policyReference2.getOtherAttributes().putAll(policyReference.getOtherAttributes());
        for (ExtensibleElement extensibleElement : policyReference.getExtensibilityElements()) {
            ExtensibleElement extensibleElement2 = this.createExtensibleElement(extensibleElement);
            if (extensibleElement2 == null) continue;
            policyReference2.getExtensibilityElements().add(extensibleElement2);
        }
        return policyReference2;
    }

    @Override
    public ExtensibleElement createExtensibleElement(ExtensibleElement extensibleElement) {
        ExtensibleElement extensibleElement2 = this.dmf.createExtensibleElement(extensibleElement.getNode());
        return extensibleElement2;
    }
}

