/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wspolicy.internal.factory;

import com.ibm.wspolicy.datamodel.All;
import com.ibm.wspolicy.datamodel.Assertion;
import com.ibm.wspolicy.datamodel.ExactlyOne;
import com.ibm.wspolicy.datamodel.ExtensibleElement;
import com.ibm.wspolicy.datamodel.Policy;
import com.ibm.wspolicy.datamodel.PolicyElement;
import com.ibm.wspolicy.datamodel.PolicyReference;
import com.ibm.wspolicy.domain.AssertionProcessor;
import com.ibm.wspolicy.factory.ConfigurationException;
import com.ibm.wspolicy.factory.DataModelFactory;
import com.ibm.wspolicy.factory.FactoryConfiguration;
import com.ibm.wspolicy.factory.SimpleFactoryConfiguration;
import com.ibm.wspolicy.factory.WSDigestValidator;
import com.ibm.wspolicy.factory.WSPolicyFactory;
import com.ibm.wspolicy.internal.datamodel.AllImpl;
import com.ibm.wspolicy.internal.datamodel.AssertionImpl;
import com.ibm.wspolicy.internal.datamodel.DOMExtensibleElement;
import com.ibm.wspolicy.internal.datamodel.ExactlyOneImpl;
import com.ibm.wspolicy.internal.datamodel.PolicyImpl;
import com.ibm.wspolicy.internal.datamodel.PolicyReferenceImpl;
import com.ibm.wspolicy.internal.factory.ElementReaderRegistry;
import com.ibm.wspolicy.internal.factory.ElementWriterRegistry;
import com.ibm.wspolicy.internal.factory.InternalFactoryConfiguration;
import com.ibm.wspolicy.internal.processor.DataModelUtilityImpl;
import com.ibm.wspolicy.internal.processor.PolicyProcessorImpl;
import com.ibm.wspolicy.internal.xml.DOMDocumentElementWriter;
import com.ibm.wspolicy.internal.xml.DOMElementElementReader;
import com.ibm.wspolicy.internal.xml.InputStreamElementReader;
import com.ibm.wspolicy.internal.xml.OutputStreamElementWriter;
import com.ibm.wspolicy.internal.xml.ReaderElementReader;
import com.ibm.wspolicy.internal.xml.StringBufferElementWriter;
import com.ibm.wspolicy.internal.xml.StringElementReader;
import com.ibm.wspolicy.internal.xml.WriterElementWriter;
import com.ibm.wspolicy.processor.DataModelUtility;
import com.ibm.wspolicy.processor.PolicyProcessor;
import com.ibm.wspolicy.xml.ElementReader;
import com.ibm.wspolicy.xml.ElementReaderException;
import com.ibm.wspolicy.xml.ElementWriter;
import com.ibm.wspolicy.xml.ElementWriterException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.util.Map;
import javax.xml.namespace.QName;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class WSPolicyFactoryImpl
extends WSPolicyFactory
implements DataModelFactory {
    private final ElementReaderRegistry elementReaders = new ElementReaderRegistry();
    private final ElementWriterRegistry elementWriters = new ElementWriterRegistry();
    private final InternalFactoryConfiguration internalConfiguration;

    public WSPolicyFactoryImpl(FactoryConfiguration factoryConfiguration) throws ConfigurationException {
        if (factoryConfiguration == null) {
            factoryConfiguration = new SimpleFactoryConfiguration(new AssertionProcessor[0]);
        }
        this.internalConfiguration = new InternalFactoryConfiguration(factoryConfiguration, this);
        DOMElementElementReader dOMElementElementReader = new DOMElementElementReader(this.internalConfiguration.getDataModelFactory());
        this.elementReaders.put(Element.class, dOMElementElementReader);
        InputStreamElementReader inputStreamElementReader = new InputStreamElementReader(dOMElementElementReader);
        this.elementReaders.put(InputStream.class, inputStreamElementReader);
        this.elementReaders.put(String.class, new StringElementReader(inputStreamElementReader));
        this.elementReaders.put(Reader.class, new ReaderElementReader(dOMElementElementReader));
        DOMDocumentElementWriter dOMDocumentElementWriter = new DOMDocumentElementWriter();
        this.elementWriters.put(Document.class, dOMDocumentElementWriter);
        OutputStreamElementWriter outputStreamElementWriter = new OutputStreamElementWriter(dOMDocumentElementWriter);
        this.elementWriters.put(OutputStream.class, outputStreamElementWriter);
        this.elementWriters.put(StringBuffer.class, new StringBufferElementWriter(outputStreamElementWriter));
        this.elementWriters.put(Writer.class, new WriterElementWriter(dOMDocumentElementWriter));
        this.processCustomElementReaders(factoryConfiguration);
        this.processCustomElementWriters(factoryConfiguration);
    }

    private void processCustomElementReaders(FactoryConfiguration factoryConfiguration) {
        if (factoryConfiguration.getCustomElementReaders() != null) {
            for (Map.Entry<Class, FactoryConfiguration.CustomElementReader> entry : factoryConfiguration.getCustomElementReaders().entrySet()) {
                this.elementReaders.put(entry.getKey(), new ReaderWrapper(this, entry.getValue()));
            }
        }
    }

    private void processCustomElementWriters(FactoryConfiguration factoryConfiguration) {
        if (factoryConfiguration.getCustomElementWriters() != null) {
            for (Map.Entry<Class, FactoryConfiguration.CustomElementWriter> entry : factoryConfiguration.getCustomElementWriters().entrySet()) {
                this.elementWriters.put(entry.getKey(), new WriterWrapper(this, entry.getValue()));
            }
        }
    }

    @Override
    public <T> ElementReader<T> getReader(Class<T> clazz) throws ElementReaderException {
        ElementReader<T> elementReader = this.elementReaders.get(clazz);
        if (elementReader == null) {
            throw new ElementReaderException();
        }
        return elementReader;
    }

    @Override
    public <T> ElementWriter<T> getWriter(Class<T> clazz) throws ElementWriterException {
        ElementWriter<T> elementWriter = this.elementWriters.get(clazz);
        if (elementWriter == null) {
            throw new ElementWriterException();
        }
        return elementWriter;
    }

    @Override
    public DataModelUtility createDataModelUtility() {
        return new DataModelUtilityImpl(this.createDataModelFactory());
    }

    @Override
    public DataModelFactory createDataModelFactory() {
        return this.internalConfiguration.getDataModelFactory();
    }

    @Override
    public PolicyProcessor createWSPolicyProcessor() {
        return new PolicyProcessorImpl(this.internalConfiguration);
    }

    @Override
    public All createAll() {
        return new AllImpl();
    }

    @Override
    public Assertion createAssertion(QName qName) {
        AssertionImpl assertionImpl = new AssertionImpl();
        assertionImpl.setName(qName);
        return assertionImpl;
    }

    @Override
    public ExactlyOne createExactlyOne() {
        return new ExactlyOneImpl();
    }

    @Override
    public Policy createPolicy() {
        return new PolicyImpl();
    }

    @Override
    public PolicyReference createPolicyReference() {
        return new PolicyReferenceImpl();
    }

    @Override
    public ExtensibleElement createExtensibleElement(Node node) {
        DOMExtensibleElement dOMExtensibleElement = new DOMExtensibleElement();
        dOMExtensibleElement.setNode(node);
        return dOMExtensibleElement;
    }

    @Override
    public WSDigestValidator getDigestValidator(String string) {
        return this.internalConfiguration.getDigestValidator(string);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ReaderWrapper<T>
    implements ElementReader<T> {
        private final FactoryConfiguration.CustomElementReader<T> cer;
        private final WSPolicyFactory wspf;

        public ReaderWrapper(WSPolicyFactory wSPolicyFactory, FactoryConfiguration.CustomElementReader<T> customElementReader) {
            this.cer = customElementReader;
            this.wspf = wSPolicyFactory;
        }

        @Override
        public PolicyElement read(T t) throws ElementReaderException {
            return this.cer.read(this.wspf, t);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class WriterWrapper<T>
    implements ElementWriter<T> {
        private final FactoryConfiguration.CustomElementWriter<T> cew;
        private final WSPolicyFactory wspf;

        public WriterWrapper(WSPolicyFactory wSPolicyFactory, FactoryConfiguration.CustomElementWriter<T> customElementWriter) {
            this.cew = customElementWriter;
            this.wspf = wSPolicyFactory;
        }

        @Override
        public void write(PolicyElement policyElement, T t) throws ElementWriterException {
            this.cew.write(this.wspf, policyElement, t);
        }
    }
}

