/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wspolicy.internal.factory;

import com.ibm.wspolicy.factory.ConfigurationException;
import com.ibm.wspolicy.factory.DataModelFactory;
import com.ibm.wspolicy.factory.FactoryConfiguration;
import com.ibm.wspolicy.factory.WSDigestValidator;
import com.ibm.wspolicy.factory.WSPolicyFactory;
import com.ibm.wspolicy.internal.domain.DomainAssertionHandlerRegistry;
import com.ibm.wspolicy.internal.factory.WSPolicyFactoryImpl;
import com.ibm.wspolicy.processor.DataModelUtility;
import com.ibm.wspolicy.processor.PolicyReferenceResolver;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class InternalFactoryConfiguration {
    private final DomainAssertionHandlerRegistry registry;
    private final WSPolicyFactory wspf;
    private final List<PolicyReferenceResolver> resolvers;
    private final DataModelFactory dmf;
    private final Map<String, WSDigestValidator> digestProcessors;

    public InternalFactoryConfiguration(FactoryConfiguration factoryConfiguration, WSPolicyFactoryImpl wSPolicyFactoryImpl) throws ConfigurationException {
        this.wspf = wSPolicyFactoryImpl;
        this.resolvers = Collections.unmodifiableList(factoryConfiguration.getPolicyReferenceResolvers());
        this.digestProcessors = Collections.unmodifiableMap(new HashMap<String, WSDigestValidator>(factoryConfiguration.getWSDigestValidators()));
        DataModelFactory dataModelFactory = factoryConfiguration.getDataModelFactory();
        this.dmf = dataModelFactory != null ? dataModelFactory : wSPolicyFactoryImpl;
        this.registry = new DomainAssertionHandlerRegistry(this.getDataModelFactory(), factoryConfiguration.getAssertionProcessors());
    }

    public DomainAssertionHandlerRegistry getAssertionProcessorRegistry() {
        return this.registry;
    }

    public DataModelFactory getDataModelFactory() {
        return this.dmf;
    }

    public DataModelUtility getDataModelUtility() {
        return this.wspf.createDataModelUtility();
    }

    public List<PolicyReferenceResolver> getResolvers() {
        return this.resolvers;
    }

    public WSPolicyFactory getWSPolicyFactory() {
        return this.wspf;
    }

    public WSDigestValidator getDigestValidator(String string) {
        return this.digestProcessors.get(string);
    }
}

