/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wspolicy.internal.domain;

import com.ibm.webservices.component.logging.Tr;
import com.ibm.webservices.component.logging.TraceComponent;
import com.ibm.wspolicy.datamodel.Assertion;
import com.ibm.wspolicy.datamodel.Policy;
import com.ibm.wspolicy.domain.AssertionProcessor;
import com.ibm.wspolicy.factory.ConfigurationException;
import com.ibm.wspolicy.factory.DataModelFactory;
import com.ibm.wspolicy.internal.domain.DefaultAssertionMerger;
import com.ibm.wspolicy.internal.utils.CoreUtils;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DomainAssertionHandlerRegistry {
    private static final TraceComponent tc = Tr.register(DomainAssertionHandlerRegistry.class, "WS-Policy", "com.ibm.ws.wspolicy.resources.CWPOLMessages");
    private final DefaultAssertionMerger _defaultAssertionMerger;
    private final Map<QName, AssertionInformation> _assertionInformationMap = new HashMap<QName, AssertionInformation>();

    public DomainAssertionHandlerRegistry(DataModelFactory dataModelFactory) throws ConfigurationException {
        this(dataModelFactory, null);
    }

    public DomainAssertionHandlerRegistry(DataModelFactory dataModelFactory, List<AssertionProcessor> list) throws ConfigurationException {
        if (tc.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "PolicyProviderRegistry CTOR");
        }
        this._defaultAssertionMerger = new DefaultAssertionMerger(dataModelFactory);
        if (list != null) {
            for (AssertionProcessor assertionProcessor : list) {
                Map<QName, AssertionProcessor.AssertionInformation> map = assertionProcessor.getAssertionInformationMap();
                if (map == null) continue;
                for (Map.Entry<QName, AssertionProcessor.AssertionInformation> entry : map.entrySet()) {
                    AssertionInformation assertionInformation = new AssertionInformation();
                    assertionInformation.name = entry.getKey();
                    assertionInformation.assertionProcessor = assertionProcessor;
                    AssertionProcessor.AssertionInformation assertionInformation2 = entry.getValue();
                    assertionInformation.customSupportsBehaviour = assertionInformation2.hasCustomSupportsBehavior;
                    assertionInformation.customMergeBehaviour = assertionInformation2.hasCustomCombineBehavior;
                    assertionInformation.preferenceScore = assertionInformation2.preferenceScore;
                    assertionInformation.preferencePreferAbsent = assertionInformation2.preferencePreferAbsent;
                    assertionInformation.preferencePreferWithNested = assertionInformation2.preferencePreferWithNested;
                    if (this._assertionInformationMap.put(assertionInformation.name, assertionInformation) == null) continue;
                    if (tc.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug(tc, "Duplicate QName found in supported list " + assertionInformation.name.toString());
                    }
                    ConfigurationException configurationException = new ConfigurationException();
                    Tr.processException(configurationException, "com.ibm.wspolicy.internal.domain.DomainAssertionHandlerRegistry CTOR", "119");
                    throw configurationException;
                }
            }
        }
        if (tc.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "PolicyProviderRegistry CTOR");
        }
    }

    public boolean hasMergeBehavior(QName qName) {
        AssertionInformation assertionInformation = this._assertionInformationMap.get(qName);
        if (assertionInformation != null) {
            return assertionInformation.customMergeBehaviour;
        }
        return false;
    }

    public DefaultAssertionMerger getDefaultAssertionMerger() {
        return this._defaultAssertionMerger;
    }

    public AssertionProcessor getWSPolicyProcessor(Assertion assertion) {
        AssertionInformation assertionInformation = this._assertionInformationMap.get(assertion.getName());
        if (assertionInformation != null) {
            return assertionInformation.assertionProcessor;
        }
        return null;
    }

    public AssertionProcessor getWSPolicyProcessor(QName qName) {
        AssertionInformation assertionInformation = this._assertionInformationMap.get(qName);
        if (assertionInformation != null) {
            return assertionInformation.assertionProcessor;
        }
        return null;
    }

    public int getPreferenceScore(QName qName) {
        AssertionInformation assertionInformation = this._assertionInformationMap.get(qName);
        if (assertionInformation != null) {
            return assertionInformation.preferenceScore;
        }
        return 0;
    }

    public boolean getPreferencePreferAbsent(QName qName) {
        AssertionInformation assertionInformation = this._assertionInformationMap.get(qName);
        if (assertionInformation != null) {
            return assertionInformation.preferencePreferAbsent;
        }
        return false;
    }

    public boolean getPreferencePreferWithNested(QName qName) {
        AssertionInformation assertionInformation = this._assertionInformationMap.get(qName);
        if (assertionInformation != null) {
            return assertionInformation.preferencePreferWithNested;
        }
        return false;
    }

    public boolean isSupported(Assertion assertion) {
        boolean bl = false;
        if (assertion.getNestedPolicy() != null) {
            Policy policy = assertion.getNestedPolicy();
            List<Assertion> list = CoreUtils.getAllAssertionsForPolicy(policy);
            for (int i = 0; i < list.size(); ++i) {
                Assertion assertion2 = list.get(i);
                boolean bl2 = bl = assertion2.isOptional() || this.isSupported(assertion2);
                if (bl) continue;
                if (tc.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "Assertion not supported " + list.get(i).getName());
                }
                return bl;
            }
        }
        bl = this.verifySupport(assertion);
        return bl;
    }

    private boolean verifySupport(Assertion assertion) {
        boolean bl = false;
        AssertionInformation assertionInformation = this._assertionInformationMap.get(assertion.getName());
        if (assertionInformation != null) {
            if (assertionInformation.customSupportsBehaviour) {
                if (tc.isEntryEnabled()) {
                    Tr.debug(tc, ">>> Registered SUPPORT behavior, calling WSPolicyProcessor");
                }
                bl = assertionInformation.assertionProcessor.supports(assertion);
            } else {
                bl = true;
            }
        } else if (!assertion.isIgnorable()) {
            bl = false;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, ">>> SUPPORT for ASSERTION[" + assertion.getName() + "] = " + bl + ": No declared PolicyDomain");
            }
        } else {
            bl = true;
        }
        return bl;
    }

    private static class AssertionInformation {
        public QName name;
        public AssertionProcessor assertionProcessor;
        public boolean customSupportsBehaviour = false;
        public boolean customMergeBehaviour = false;
        public int preferenceScore = 0;
        public boolean preferencePreferAbsent = false;
        public boolean preferencePreferWithNested = false;

        private AssertionInformation() {
        }
    }
}

