/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wspolicy.internal.alternatives.inodes;

import com.ibm.webservices.component.logging.Tr;
import com.ibm.webservices.component.logging.TraceComponent;
import com.ibm.wspolicy.PolicyReferenceException;
import com.ibm.wspolicy.datamodel.Assertion;
import com.ibm.wspolicy.datamodel.ExactlyOne;
import com.ibm.wspolicy.datamodel.Operator;
import com.ibm.wspolicy.datamodel.PolicyElement;
import com.ibm.wspolicy.datamodel.PolicyReference;
import com.ibm.wspolicy.internal.PolicyConstants;
import com.ibm.wspolicy.internal.alternatives.inodes.AllNode;
import com.ibm.wspolicy.internal.alternatives.inodes.AssertionNode;
import com.ibm.wspolicy.internal.alternatives.inodes.ExactlyOneNode;
import com.ibm.wspolicy.internal.alternatives.inodes.StatefulPolicyNode;
import com.ibm.wspolicy.internal.domain.DomainAssertionHandlerRegistry;
import com.ibm.wspolicy.processor.DataModelUtility;
import com.ibm.wspolicy.processor.PolicyProcessor;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class NodeTreeBuilder {
    private static final TraceComponent tc = Tr.register(NodeTreeBuilder.class, "WS-Policy", "com.ibm.ws.wspolicy.resources.CWPOLMessages");

    public static StatefulPolicyNode getNodeForPolicyElement(PolicyElement policyElement, DomainAssertionHandlerRegistry domainAssertionHandlerRegistry, DataModelUtility dataModelUtility, PolicyProcessor.FilterType filterType, PolicyConstants.IntersectionType intersectionType) throws PolicyReferenceException {
        WrapperedStatefulPolicyNode wrapperedStatefulPolicyNode = NodeTreeBuilder.getWrapperedNodeForPolicyElement(policyElement, domainAssertionHandlerRegistry, dataModelUtility, filterType, intersectionType);
        return wrapperedStatefulPolicyNode._wrappered;
    }

    private static WrapperedStatefulPolicyNode getWrapperedNodeForPolicyElement(PolicyElement policyElement, DomainAssertionHandlerRegistry domainAssertionHandlerRegistry, DataModelUtility dataModelUtility, PolicyProcessor.FilterType filterType, PolicyConstants.IntersectionType intersectionType) throws PolicyReferenceException {
        if (policyElement instanceof PolicyReference) {
            if (tc.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "getWrapperedNodeForPolicyElement found PolicyReference");
            }
            PolicyReferenceException policyReferenceException = new PolicyReferenceException(((PolicyReference)policyElement).getURI());
            Tr.processException(policyReferenceException, "com.ibm.wspolicy.internal.alternatives.inodes.NodeTreebuilder.getWrapperedNodeForPolicyElement", "135");
            throw policyReferenceException;
        }
        WrapperedStatefulPolicyNode wrapperedStatefulPolicyNode = policyElement instanceof Operator ? NodeTreeBuilder.getNodeForOperator((Operator)policyElement, domainAssertionHandlerRegistry, dataModelUtility, filterType, intersectionType) : (policyElement instanceof Assertion ? NodeTreeBuilder.getNodeForAssertion((Assertion)policyElement, domainAssertionHandlerRegistry, dataModelUtility, filterType, intersectionType) : null);
        return wrapperedStatefulPolicyNode;
    }

    /*
     * WARNING - void declaration
     */
    private static WrapperedStatefulPolicyNode getNodeForOperator(Operator operator, DomainAssertionHandlerRegistry domainAssertionHandlerRegistry, DataModelUtility dataModelUtility, PolicyProcessor.FilterType filterType, PolicyConstants.IntersectionType intersectionType) throws PolicyReferenceException {
        void var9_14;
        ArrayList<WrapperedStatefulPolicyNode> arrayList;
        WrapperedStatefulPolicyNode.NodeType nodeType = operator instanceof ExactlyOne ? WrapperedStatefulPolicyNode.NodeType.EXACTLY_ONE : WrapperedStatefulPolicyNode.NodeType.ALL;
        ArrayList<WrapperedStatefulPolicyNode> arrayList2 = new ArrayList<WrapperedStatefulPolicyNode>();
        WrapperedStatefulPolicyNode wrapperedStatefulPolicyNode = new WrapperedStatefulPolicyNode(null, nodeType, arrayList2);
        wrapperedStatefulPolicyNode._canReturnEmpty = false;
        wrapperedStatefulPolicyNode._willOnlyReturnEmpty = true;
        for (PolicyElement object2 : operator.getChildren()) {
            WrapperedStatefulPolicyNode wrapperedStatefulPolicyNode2 = NodeTreeBuilder.getWrapperedNodeForPolicyElement(object2, domainAssertionHandlerRegistry, dataModelUtility, filterType, intersectionType);
            if (wrapperedStatefulPolicyNode2._isNull) {
                if (nodeType == WrapperedStatefulPolicyNode.NodeType.ALL && !wrapperedStatefulPolicyNode._isNull) {
                    wrapperedStatefulPolicyNode._isNull = true;
                    wrapperedStatefulPolicyNode._containedInside.clear();
                    ArrayList<StatefulPolicyNode> arrayList3 = new ArrayList<StatefulPolicyNode>(0);
                    ExactlyOneNode exactlyOneNode = new ExactlyOneNode(arrayList3);
                    ArrayList<WrapperedStatefulPolicyNode> arrayList4 = new ArrayList<WrapperedStatefulPolicyNode>(0);
                    WrapperedStatefulPolicyNode wrapperedStatefulPolicyNode3 = new WrapperedStatefulPolicyNode(exactlyOneNode, WrapperedStatefulPolicyNode.NodeType.EXACTLY_ONE, arrayList4);
                    wrapperedStatefulPolicyNode3._isNull = true;
                    wrapperedStatefulPolicyNode3._canReturnEmpty = false;
                    wrapperedStatefulPolicyNode3._willOnlyReturnEmpty = false;
                    wrapperedStatefulPolicyNode._containedInside.add(wrapperedStatefulPolicyNode3);
                    break;
                }
                if (nodeType == WrapperedStatefulPolicyNode.NodeType.EXACTLY_ONE) {
                    // empty if block
                }
            }
            if (wrapperedStatefulPolicyNode2._isNull) continue;
            NodeTreeBuilder.blendNewNodeToList(wrapperedStatefulPolicyNode, wrapperedStatefulPolicyNode2);
        }
        if (wrapperedStatefulPolicyNode._nodeType == WrapperedStatefulPolicyNode.NodeType.EXACTLY_ONE && wrapperedStatefulPolicyNode._containedInside.size() == 0) {
            wrapperedStatefulPolicyNode._isNull = true;
            wrapperedStatefulPolicyNode._canReturnEmpty = false;
            wrapperedStatefulPolicyNode._willOnlyReturnEmpty = false;
        } else {
            NodeTreeBuilder.stage2Collapse(wrapperedStatefulPolicyNode);
        }
        if (nodeType == WrapperedStatefulPolicyNode.NodeType.EXACTLY_ONE) {
            arrayList = NodeTreeBuilder.sortByPrefInfo(wrapperedStatefulPolicyNode._containedInside, domainAssertionHandlerRegistry);
            wrapperedStatefulPolicyNode._containedInside = arrayList;
        }
        arrayList = new ArrayList<WrapperedStatefulPolicyNode>(wrapperedStatefulPolicyNode._containedInside.size());
        for (WrapperedStatefulPolicyNode wrapperedStatefulPolicyNode2 : wrapperedStatefulPolicyNode._containedInside) {
            arrayList.add((WrapperedStatefulPolicyNode)((Object)wrapperedStatefulPolicyNode2._wrappered));
        }
        Object var9_11 = null;
        if (nodeType == WrapperedStatefulPolicyNode.NodeType.ALL) {
            AllNode allNode = new AllNode(arrayList);
        } else if (nodeType == WrapperedStatefulPolicyNode.NodeType.EXACTLY_ONE) {
            ExactlyOneNode exactlyOneNode = new ExactlyOneNode(arrayList);
        }
        wrapperedStatefulPolicyNode._wrappered = var9_14;
        return wrapperedStatefulPolicyNode;
    }

    private static List<WrapperedStatefulPolicyNode> sortByPrefInfo(List<WrapperedStatefulPolicyNode> list, DomainAssertionHandlerRegistry domainAssertionHandlerRegistry) {
        if (tc.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "NodeTreebuilder", new Object[]{list});
        }
        ArrayList<ScoreAndNode> arrayList = new ArrayList<ScoreAndNode>(list.size());
        for (WrapperedStatefulPolicyNode object : list) {
            int n = Integer.MIN_VALUE;
            if (object._nodeType == WrapperedStatefulPolicyNode.NodeType.ASSERTION) {
                AssertionNode assertionNode = (AssertionNode)object._wrappered;
                int n2 = domainAssertionHandlerRegistry.getPreferenceScore(assertionNode.baseAssertion.getName());
                n = Integer.MIN_VALUE + n2;
                if (domainAssertionHandlerRegistry.getPreferencePreferWithNested(assertionNode.baseAssertion.getName()) && assertionNode.nestedPolicy != null) {
                    AllNode allNode = assertionNode.nestedPolicy;
                    allNode.reset();
                    boolean bl = false;
                    Object object2 = allNode.next();
                    if (object2.size() == 0 && !allNode.hasNext()) {
                        bl = true;
                    }
                    allNode.reset();
                    if (bl) {
                        n = n2;
                    }
                }
            }
            arrayList.add(new ScoreAndNode(object, n));
        }
        Collections.sort(arrayList, ScoreComparator.INSTANCE);
        ArrayList arrayList2 = new ArrayList(list.size());
        for (ScoreAndNode scoreAndNode : arrayList) {
            arrayList2.add(scoreAndNode.node);
        }
        if (tc.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "NodeTreebuilder", new Object[]{arrayList2});
        }
        return arrayList2;
    }

    private static WrapperedStatefulPolicyNode getNodeForAssertion(Assertion assertion, DomainAssertionHandlerRegistry domainAssertionHandlerRegistry, DataModelUtility dataModelUtility, PolicyProcessor.FilterType filterType, PolicyConstants.IntersectionType intersectionType) throws PolicyReferenceException {
        boolean bl = false;
        AllNode allNode = null;
        if (assertion.getNestedPolicy() != null) {
            WrapperedStatefulPolicyNode wrapperedStatefulPolicyNode = NodeTreeBuilder.getNodeForOperator(assertion.getNestedPolicy(), domainAssertionHandlerRegistry, dataModelUtility, filterType, intersectionType);
            bl = wrapperedStatefulPolicyNode._isNull;
            allNode = (AllNode)wrapperedStatefulPolicyNode._wrappered;
        }
        boolean bl2 = true;
        if (filterType == PolicyProcessor.FilterType.SUPPORTED) {
            bl2 = domainAssertionHandlerRegistry.isSupported(assertion);
        }
        boolean bl3 = domainAssertionHandlerRegistry.getPreferencePreferAbsent(assertion.getName());
        AssertionNode assertionNode = new AssertionNode(assertion, bl2, bl3, dataModelUtility, allNode, bl);
        WrapperedStatefulPolicyNode wrapperedStatefulPolicyNode = new WrapperedStatefulPolicyNode(assertionNode, WrapperedStatefulPolicyNode.NodeType.ASSERTION, null);
        wrapperedStatefulPolicyNode._canReturnEmpty = assertion.isOptional();
        wrapperedStatefulPolicyNode._willOnlyReturnEmpty = assertion.isOptional() && !bl2 || assertion.isOptional() && bl;
        wrapperedStatefulPolicyNode._isNull = !assertionNode.hasNext();
        return wrapperedStatefulPolicyNode;
    }

    private static void blendNewNodeToList(WrapperedStatefulPolicyNode wrapperedStatefulPolicyNode, WrapperedStatefulPolicyNode wrapperedStatefulPolicyNode2) {
        WrapperedStatefulPolicyNode.NodeType nodeType = wrapperedStatefulPolicyNode._nodeType;
        WrapperedStatefulPolicyNode.NodeType nodeType2 = wrapperedStatefulPolicyNode2._nodeType;
        if ((nodeType2 == WrapperedStatefulPolicyNode.NodeType.EXACTLY_ONE && nodeType == WrapperedStatefulPolicyNode.NodeType.EXACTLY_ONE || nodeType2 == WrapperedStatefulPolicyNode.NodeType.ALL && nodeType == WrapperedStatefulPolicyNode.NodeType.ALL) && wrapperedStatefulPolicyNode2._containedInside.size() > 0) {
            wrapperedStatefulPolicyNode._containedInside.addAll(wrapperedStatefulPolicyNode2._containedInside);
            if (wrapperedStatefulPolicyNode2._canReturnEmpty || wrapperedStatefulPolicyNode2._willOnlyReturnEmpty) {
                wrapperedStatefulPolicyNode._canReturnEmpty = true;
            }
            wrapperedStatefulPolicyNode._willOnlyReturnEmpty &= wrapperedStatefulPolicyNode2._willOnlyReturnEmpty;
        } else if ((wrapperedStatefulPolicyNode2._nodeType == WrapperedStatefulPolicyNode.NodeType.EXACTLY_ONE || wrapperedStatefulPolicyNode2._nodeType == WrapperedStatefulPolicyNode.NodeType.ALL) && wrapperedStatefulPolicyNode2._containedInside.size() == 1) {
            wrapperedStatefulPolicyNode._containedInside.addAll(wrapperedStatefulPolicyNode2._containedInside);
            if (wrapperedStatefulPolicyNode2._canReturnEmpty || wrapperedStatefulPolicyNode2._willOnlyReturnEmpty) {
                wrapperedStatefulPolicyNode._canReturnEmpty = true;
            }
            wrapperedStatefulPolicyNode._willOnlyReturnEmpty &= wrapperedStatefulPolicyNode2._willOnlyReturnEmpty;
        } else if (nodeType != WrapperedStatefulPolicyNode.NodeType.ALL || nodeType2 != WrapperedStatefulPolicyNode.NodeType.ALL || wrapperedStatefulPolicyNode2._containedInside.size() != 0) {
            if (nodeType == WrapperedStatefulPolicyNode.NodeType.EXACTLY_ONE && nodeType2 == WrapperedStatefulPolicyNode.NodeType.ALL && wrapperedStatefulPolicyNode2._containedInside.size() == 0) {
                if (!wrapperedStatefulPolicyNode._canReturnEmpty) {
                    wrapperedStatefulPolicyNode._containedInside.add(wrapperedStatefulPolicyNode2);
                    if (wrapperedStatefulPolicyNode2._canReturnEmpty || wrapperedStatefulPolicyNode2._willOnlyReturnEmpty) {
                        wrapperedStatefulPolicyNode._canReturnEmpty = true;
                    }
                    wrapperedStatefulPolicyNode._willOnlyReturnEmpty &= wrapperedStatefulPolicyNode2._willOnlyReturnEmpty;
                }
            } else if (!wrapperedStatefulPolicyNode2._willOnlyReturnEmpty || !wrapperedStatefulPolicyNode._canReturnEmpty) {
                wrapperedStatefulPolicyNode._containedInside.add(wrapperedStatefulPolicyNode2);
                if (wrapperedStatefulPolicyNode2._canReturnEmpty || wrapperedStatefulPolicyNode2._willOnlyReturnEmpty) {
                    wrapperedStatefulPolicyNode._canReturnEmpty = true;
                }
                wrapperedStatefulPolicyNode._willOnlyReturnEmpty &= wrapperedStatefulPolicyNode2._willOnlyReturnEmpty;
            }
        }
    }

    private static void stage2Collapse(WrapperedStatefulPolicyNode wrapperedStatefulPolicyNode) {
        if (wrapperedStatefulPolicyNode._nodeType == WrapperedStatefulPolicyNode.NodeType.EXACTLY_ONE && wrapperedStatefulPolicyNode._canReturnEmpty) {
            ArrayList<WrapperedStatefulPolicyNode> arrayList = new ArrayList<WrapperedStatefulPolicyNode>();
            WrapperedStatefulPolicyNode wrapperedStatefulPolicyNode2 = null;
            for (WrapperedStatefulPolicyNode wrapperedStatefulPolicyNode3 : wrapperedStatefulPolicyNode._containedInside) {
                if (wrapperedStatefulPolicyNode3._willOnlyReturnEmpty) {
                    wrapperedStatefulPolicyNode2 = wrapperedStatefulPolicyNode3;
                    continue;
                }
                if (wrapperedStatefulPolicyNode3._wrappered instanceof AssertionNode) {
                    AssertionNode assertionNode = (AssertionNode)wrapperedStatefulPolicyNode3._wrappered;
                    assertionNode.makeOptional();
                }
                arrayList.add(wrapperedStatefulPolicyNode3);
            }
            if (arrayList.size() == 0 && wrapperedStatefulPolicyNode2 != null) {
                arrayList.add(wrapperedStatefulPolicyNode2);
            }
            wrapperedStatefulPolicyNode._containedInside = arrayList;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class WrapperedStatefulPolicyNode {
        public final NodeType _nodeType;
        public boolean _canReturnEmpty = true;
        public boolean _willOnlyReturnEmpty = true;
        public boolean _isNull = false;
        public List<WrapperedStatefulPolicyNode> _containedInside;
        public StatefulPolicyNode _wrappered = null;

        public WrapperedStatefulPolicyNode(StatefulPolicyNode statefulPolicyNode, NodeType nodeType, List<WrapperedStatefulPolicyNode> list) {
            this._wrappered = statefulPolicyNode;
            this._nodeType = nodeType;
            this._containedInside = list;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static enum NodeType {
            EXACTLY_ONE,
            ALL,
            ASSERTION;

        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class ScoreComparator
    implements Comparator<ScoreAndNode>,
    Serializable {
        public static ScoreComparator INSTANCE = new ScoreComparator();
        private static final long serialVersionUID = 1L;

        private ScoreComparator() {
        }

        @Override
        public int compare(ScoreAndNode scoreAndNode, ScoreAndNode scoreAndNode2) {
            if (scoreAndNode.score < scoreAndNode2.score) {
                return 1;
            }
            if (scoreAndNode.score > scoreAndNode2.score) {
                return -1;
            }
            return 0;
        }
    }

    private static final class ScoreAndNode {
        public final WrapperedStatefulPolicyNode node;
        public final int score;

        public ScoreAndNode(WrapperedStatefulPolicyNode wrapperedStatefulPolicyNode, int n) {
            this.node = wrapperedStatefulPolicyNode;
            this.score = n;
        }
    }
}

