/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wspolicy.internal.alternatives.inodes;

import com.ibm.wspolicy.datamodel.Assertion;
import com.ibm.wspolicy.datamodel.ExactlyOne;
import com.ibm.wspolicy.datamodel.PolicyElement;
import com.ibm.wspolicy.factory.DataModelFactory;
import com.ibm.wspolicy.internal.alternatives.inodes.IteratorWithReset;
import com.ibm.wspolicy.internal.alternatives.inodes.IteratorWithResetImpl;
import com.ibm.wspolicy.internal.alternatives.inodes.StatefulPolicyNode;
import com.ibm.wspolicy.processor.DataModelUtility;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExactlyOneNode
implements StatefulPolicyNode {
    List<StatefulPolicyNode> baseList;
    IteratorWithReset<StatefulPolicyNode> children;
    StatefulPolicyNode current;
    boolean hasReturnedBlank;
    List<Assertion> cachedResult;

    public ExactlyOneNode(List<StatefulPolicyNode> list) {
        this.children = new IteratorWithResetImpl<StatefulPolicyNode>(list);
        this.cachedResult = null;
        this.baseList = list;
        this.reset();
    }

    @Override
    public void reset() {
        this.children.reset();
        while (this.children.hasNext()) {
            StatefulPolicyNode statefulPolicyNode = (StatefulPolicyNode)this.children.next();
            statefulPolicyNode.reset();
        }
        this.children.reset();
        this.hasReturnedBlank = false;
        this.current = null;
        this.cachedResult = null;
    }

    @Override
    public boolean hasNext() {
        if (this.cachedResult == null) {
            this.cachedResult = this.internalNext();
        }
        return this.cachedResult != null;
    }

    @Override
    public List<Assertion> next() {
        if (this.cachedResult == null) {
            this.cachedResult = this.internalNext();
        }
        if (this.cachedResult == null) {
            throw new NoSuchElementException();
        }
        List<Assertion> list = this.cachedResult;
        this.cachedResult = null;
        return list;
    }

    private List<Assertion> internalNext() {
        if (this.baseList.size() == 0) {
            return null;
        }
        List list = null;
        while ((this.children.hasNext() || this.current.hasNext()) && list == null) {
            if (this.current == null || !this.current.hasNext()) {
                if (this.children.hasNext()) {
                    this.current = (StatefulPolicyNode)this.children.next();
                } else {
                    return null;
                }
            }
            if (!this.current.hasNext() || (list = (List)this.current.next()).size() != 0) continue;
            if (this.hasReturnedBlank) {
                list = null;
                continue;
            }
            this.hasReturnedBlank = true;
        }
        return list;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    @Override
    public PolicyElement getAsPolicyElement(DataModelFactory dataModelFactory, DataModelUtility dataModelUtility) {
        ExactlyOne exactlyOne = null;
        ExactlyOne exactlyOne2 = dataModelFactory.createExactlyOne();
        Vector<PolicyElement> vector = new Vector<PolicyElement>(this.baseList.size());
        for (StatefulPolicyNode statefulPolicyNode : this.baseList) {
            vector.add(statefulPolicyNode.getAsPolicyElement(dataModelFactory, dataModelUtility));
        }
        exactlyOne2.getChildren().addAll(vector);
        exactlyOne = exactlyOne2;
        return exactlyOne;
    }
}

