/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wspolicy.internal.alternatives.inodes;

import com.ibm.wspolicy.PolicyReferenceException;
import com.ibm.wspolicy.datamodel.Assertion;
import com.ibm.wspolicy.datamodel.PolicyElement;
import com.ibm.wspolicy.factory.DataModelFactory;
import com.ibm.wspolicy.internal.alternatives.inodes.AllNode;
import com.ibm.wspolicy.internal.alternatives.inodes.StatefulPolicyNode;
import com.ibm.wspolicy.processor.DataModelUtility;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AssertionNode
implements StatefulPolicyNode {
    private static final List<Assertion> BLANK = new ArrayList<Assertion>(0);
    StateSequence configuredStateFlow;
    Iterator<State> currentStateIter;
    State currentState;
    Assertion baseAssertion;
    Assertion clonedAssertion;
    AllNode nestedPolicy;
    Assertion clonedAssertionWithEmptyNestedPolicy;
    DataModelUtility dmu;

    public AssertionNode(Assertion assertion, boolean bl, boolean bl2, DataModelUtility dataModelUtility, AllNode allNode, boolean bl3) throws PolicyReferenceException {
        this.baseAssertion = assertion;
        this.configuredStateFlow = this.obtainFlowForAssertion(this.baseAssertion, bl, bl2, bl3);
        this.nestedPolicy = allNode;
        this.dmu = dataModelUtility;
        this.clonedAssertion = dataModelUtility.createAssertion(this.baseAssertion);
        this.clonedAssertion.setOptional(false);
        if (this.nestedPolicy != null) {
            this.clonedAssertionWithEmptyNestedPolicy = dataModelUtility.createAssertion(this.clonedAssertion);
            this.clonedAssertionWithEmptyNestedPolicy.getNestedPolicy().getChildren().clear();
        }
        this.reset();
    }

    private StateSequence obtainFlowForAssertion(Assertion assertion, boolean bl, boolean bl2, boolean bl3) {
        StateSequence stateSequence = null;
        stateSequence = bl3 ? (assertion.isOptional() ? StateSequence.UNSUPPORTED_OPTIONAL : StateSequence.UNSUPPORTED) : (assertion.isOptional() && !bl ? StateSequence.UNSUPPORTED_OPTIONAL : (assertion.isOptional() && bl ? (bl2 ? StateSequence.SUPPORTED_OPTIONAL_PREFERABSENT : StateSequence.SUPPORTED_OPTIONAL) : (bl ? (bl2 ? StateSequence.SUPPORTED_PREFERABSENT : StateSequence.SUPPORTED) : StateSequence.UNSUPPORTED)));
        return stateSequence;
    }

    @Override
    public void reset() {
        this.currentStateIter = this.configuredStateFlow.iterator();
        this.currentState = null;
        if (this.nestedPolicy != null) {
            this.nestedPolicy.reset();
        }
    }

    @Override
    public boolean hasNext() {
        if (this.currentStateIter.hasNext()) {
            return true;
        }
        if (State.VALUE == this.currentState && this.nestedPolicy != null) {
            return this.nestedPolicy.hasNext();
        }
        return false;
    }

    @Override
    public List<Assertion> next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        if (this.nestedPolicy == null || this.nestedPolicy != null && this.currentState != State.VALUE || this.nestedPolicy != null && this.currentState == State.VALUE && !this.nestedPolicy.hasNext()) {
            this.currentState = this.currentStateIter.next();
        }
        List<Assertion> list = new ArrayList<Assertion>(1);
        switch (this.currentState) {
            case BLANK: {
                list = BLANK;
                break;
            }
            case VALUE: {
                if (this.nestedPolicy == null) {
                    list.add(this.clonedAssertion);
                    break;
                }
                Assertion assertion = this.dmu.createAssertion(this.clonedAssertionWithEmptyNestedPolicy);
                Object object = this.nestedPolicy.next();
                assertion.getNestedPolicy().getChildren().addAll((Collection<PolicyElement>)object);
                list.add(assertion);
            }
        }
        return list;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    @Override
    public PolicyElement getAsPolicyElement(DataModelFactory dataModelFactory, DataModelUtility dataModelUtility) {
        Assertion assertion = null;
        Assertion assertion2 = null;
        assertion2 = dataModelUtility.createAssertion(this.baseAssertion);
        switch (this.configuredStateFlow) {
            case SUPPORTED: 
            case SUPPORTED_PREFERABSENT: 
            case UNSUPPORTED: {
                assertion2.setOptional(false);
                break;
            }
            case SUPPORTED_OPTIONAL: 
            case SUPPORTED_OPTIONAL_PREFERABSENT: 
            case UNSUPPORTED_OPTIONAL: {
                assertion2.setOptional(true);
            }
        }
        assertion = assertion2;
        return assertion;
    }

    public String toString() {
        String string = "";
        string = string + "{A:";
        string = string + this.baseAssertion.getName().getLocalPart();
        string = string + ":O?" + this.baseAssertion.isOptional();
        string = string + ":" + (Object)((Object)this.configuredStateFlow);
        string = string + ":" + (Object)((Object)this.currentState);
        string = string + ":" + this.nestedPolicy;
        string = string + "}";
        return string;
    }

    public void makeOptional() {
        switch (this.configuredStateFlow) {
            case UNSUPPORTED: {
                this.configuredStateFlow = StateSequence.UNSUPPORTED_OPTIONAL;
                break;
            }
            case SUPPORTED: {
                this.configuredStateFlow = StateSequence.SUPPORTED_OPTIONAL;
                break;
            }
            case SUPPORTED_PREFERABSENT: {
                this.configuredStateFlow = StateSequence.SUPPORTED_OPTIONAL_PREFERABSENT;
            }
        }
        this.reset();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum StateSequence {
        UNSUPPORTED(new ArrayList<State>()),
        UNSUPPORTED_OPTIONAL(new ArrayList<State>(Arrays.asList(State.BLANK))),
        SUPPORTED(new ArrayList<State>(Arrays.asList(State.VALUE))),
        SUPPORTED_PREFERABSENT(new ArrayList<State>(Arrays.asList(State.VALUE))),
        SUPPORTED_OPTIONAL(new ArrayList<State>(Arrays.asList(State.VALUE, State.BLANK))),
        SUPPORTED_OPTIONAL_PREFERABSENT(new ArrayList<State>(Arrays.asList(State.BLANK, State.VALUE)));

        private final List<State> _stateList;

        private StateSequence(List<State> list) {
            this._stateList = list;
        }

        public Iterator<State> iterator() {
            return this._stateList.iterator();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum State {
        BLANK,
        VALUE;

    }
}

