/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wspolicy.internal.alternatives.inodes;

import com.ibm.wspolicy.datamodel.All;
import com.ibm.wspolicy.datamodel.Assertion;
import com.ibm.wspolicy.datamodel.PolicyElement;
import com.ibm.wspolicy.factory.DataModelFactory;
import com.ibm.wspolicy.internal.alternatives.inodes.StatefulPolicyNode;
import com.ibm.wspolicy.processor.DataModelUtility;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AllNode
implements StatefulPolicyNode {
    List<StatefulPolicyNode> children;
    Map<StatefulPolicyNode, List<Assertion>> current;
    boolean specialCaseBlankReturn = false;
    private static final ArrayList<Assertion> blank = new ArrayList(0);
    boolean specialCaseContainsNodeWithNoOptions = false;
    Boolean _cachedHasNext = null;

    public AllNode(List<StatefulPolicyNode> list) {
        this.children = list;
        this.current = new HashMap<StatefulPolicyNode, List<Assertion>>(list.size());
        this.reset();
        for (StatefulPolicyNode statefulPolicyNode : this.children) {
            boolean bl = statefulPolicyNode.hasNext();
            if (bl) continue;
            this.specialCaseContainsNodeWithNoOptions = true;
        }
    }

    @Override
    public void reset() {
        for (StatefulPolicyNode statefulPolicyNode : this.children) {
            statefulPolicyNode.reset();
        }
        this.current.clear();
        this._cachedHasNext = null;
        if (this.children.size() == 0) {
            this.specialCaseBlankReturn = true;
        }
    }

    @Override
    public boolean hasNext() {
        if (this.specialCaseContainsNodeWithNoOptions) {
            return false;
        }
        if (this.children.size() > 0) {
            if (this._cachedHasNext != null) {
                return this._cachedHasNext;
            }
            boolean bl = false;
            for (StatefulPolicyNode statefulPolicyNode : this.children) {
                if (bl |= statefulPolicyNode.hasNext()) break;
            }
            this._cachedHasNext = bl;
            return bl;
        }
        return this.specialCaseBlankReturn;
    }

    @Override
    public List<Assertion> next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        if (this.specialCaseBlankReturn) {
            this.specialCaseBlankReturn = false;
            return blank;
        }
        this._cachedHasNext = null;
        boolean bl = false;
        for (StatefulPolicyNode iterator : this.children) {
            if (iterator.hasNext()) {
                this.current.put(iterator, (List<Assertion>)iterator.next());
                bl = true;
                break;
            }
            iterator.reset();
            this.current.put(iterator, (List<Assertion>)iterator.next());
        }
        if (!bl) {
            throw new NoSuchElementException();
        }
        if (this.children.size() != this.current.size()) {
            for (StatefulPolicyNode statefulPolicyNode : this.children) {
                if (this.current.containsKey(statefulPolicyNode)) continue;
                this.current.put(statefulPolicyNode, (List<Assertion>)statefulPolicyNode.next());
            }
        }
        ArrayList arrayList = new ArrayList();
        for (List<Assertion> list : this.current.values()) {
            arrayList.addAll(list);
        }
        return arrayList;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    @Override
    public PolicyElement getAsPolicyElement(DataModelFactory dataModelFactory, DataModelUtility dataModelUtility) {
        All all = null;
        All all2 = dataModelFactory.createAll();
        Vector<PolicyElement> vector = new Vector<PolicyElement>(this.children.size());
        for (StatefulPolicyNode statefulPolicyNode : this.children) {
            vector.add(statefulPolicyNode.getAsPolicyElement(dataModelFactory, dataModelUtility));
        }
        all2.getChildren().addAll(vector);
        all = all2;
        return all;
    }
}

