/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wspolicy.internal.alternatives;

import com.ibm.webservices.component.logging.Tr;
import com.ibm.webservices.component.logging.TraceComponent;
import com.ibm.wspolicy.PolicyReferenceException;
import com.ibm.wspolicy.datamodel.All;
import com.ibm.wspolicy.datamodel.Assertion;
import com.ibm.wspolicy.datamodel.ExactlyOne;
import com.ibm.wspolicy.datamodel.Policy;
import com.ibm.wspolicy.datamodel.PolicyElement;
import com.ibm.wspolicy.factory.DataModelFactory;
import com.ibm.wspolicy.internal.alternatives.Alternative;
import com.ibm.wspolicy.internal.alternatives.AlternativesIterator;
import com.ibm.wspolicy.internal.domain.DomainAssertionHandlerRegistry;
import com.ibm.wspolicy.processor.DataModelUtility;
import com.ibm.wspolicy.processor.PolicyProcessor;

public class NormalizeUtils {
    private static final TraceComponent tc = Tr.register(NormalizeUtils.class, null, null);

    public static Policy normalizePolicy(DomainAssertionHandlerRegistry domainAssertionHandlerRegistry, DataModelFactory dataModelFactory, DataModelUtility dataModelUtility, Policy policy) throws PolicyReferenceException {
        Object object;
        if (tc.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "normalizePolicy", new Object[]{domainAssertionHandlerRegistry, dataModelFactory, dataModelUtility, policy});
        }
        ExactlyOne exactlyOne = dataModelFactory.createExactlyOne();
        AlternativesIterator alternativesIterator = new AlternativesIterator(domainAssertionHandlerRegistry, dataModelUtility, policy, PolicyProcessor.FilterType.LOGICAL);
        while (alternativesIterator.hasNext()) {
            object = alternativesIterator.next();
            All all = dataModelFactory.createAll();
            for (Assertion assertion : ((Alternative)object).getAssertions()) {
                NormalizeUtils.completeNormalisedStructure(dataModelFactory, assertion);
                all.getChildren().add(assertion);
            }
            exactlyOne.getChildren().add(all);
        }
        object = dataModelFactory.createPolicy();
        object.setName(policy.getName());
        object.getOtherAttributes().putAll(policy.getOtherAttributes());
        object.getChildren().clear();
        object.getChildren().add(exactlyOne);
        if (tc.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "normalizePolicy", object);
        }
        return object;
    }

    public static void completeNormalisedStructure(DataModelFactory dataModelFactory, Assertion assertion) {
        if (tc.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "completeNormalisedStructure", new Object[]{dataModelFactory, assertion});
        }
        if (assertion.getNestedPolicy() != null) {
            Object object;
            All all = dataModelFactory.createAll();
            Policy policy = assertion.getNestedPolicy();
            boolean bl = true;
            if (policy.getChildren().size() == 1 && policy.getChildren().get(0) instanceof ExactlyOne && (object = (ExactlyOne)policy.getChildren().get(0)).getChildren().size() == 1 && object.getChildren().get(0) instanceof All) {
                bl = false;
            }
            for (PolicyElement policyElement : policy.getChildren()) {
                if (policyElement instanceof Assertion) {
                    NormalizeUtils.completeNormalisedStructure(dataModelFactory, (Assertion)policyElement);
                } else if (bl && tc.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "Unexpected non-Assertion PolicyElement: " + policyElement);
                }
                all.getChildren().add(policyElement);
            }
            if (bl) {
                object = dataModelFactory.createExactlyOne();
                object.getChildren().add(all);
                policy.getChildren().clear();
                policy.getChildren().add((PolicyElement)object);
            }
        }
        if (tc.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "completeNormalisedStructure");
        }
    }
}

