/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wspolicy.internal.alternatives;

import com.ibm.wspolicy.PolicyReferenceException;
import com.ibm.wspolicy.datamodel.All;
import com.ibm.wspolicy.datamodel.Policy;
import com.ibm.wspolicy.factory.DataModelFactory;
import com.ibm.wspolicy.internal.PolicyConstants;
import com.ibm.wspolicy.internal.alternatives.Alternative;
import com.ibm.wspolicy.internal.alternatives.AlternativeCheckUtils;
import com.ibm.wspolicy.internal.alternatives.inodes.NodeTreeBuilder;
import com.ibm.wspolicy.internal.alternatives.inodes.StatefulPolicyNode;
import com.ibm.wspolicy.internal.domain.DomainAssertionHandlerRegistry;
import com.ibm.wspolicy.internal.utils.CoreUtils;
import com.ibm.wspolicy.processor.DataModelUtility;
import com.ibm.wspolicy.processor.PolicyProcessor;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;
import javax.xml.namespace.QName;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AlternativesIterator
implements Iterator<PolicyProcessor.Alternative> {
    private final StatefulPolicyNode _rootNode;
    private Alternative _cachedAlternative;
    private Boolean _deliveredFlag;
    private boolean _finalDelivered;
    PolicyProcessor.FilterType _iterationType = PolicyProcessor.FilterType.LOGICAL;
    private boolean _nullDelivered;
    private Policy _owningPolicy;
    private Set<QName> _owningPolicyVocabulary;
    final DomainAssertionHandlerRegistry _dahr;
    PolicyConstants.IntersectionType _intersectionType = PolicyConstants.IntersectionType.STRICT;

    public AlternativesIterator(DomainAssertionHandlerRegistry domainAssertionHandlerRegistry, DataModelUtility dataModelUtility, Policy policy, PolicyProcessor.FilterType filterType) throws PolicyReferenceException {
        this(domainAssertionHandlerRegistry, dataModelUtility, policy, filterType, null);
    }

    public AlternativesIterator(DomainAssertionHandlerRegistry domainAssertionHandlerRegistry, DataModelUtility dataModelUtility, Policy policy, PolicyProcessor.FilterType filterType, PolicyConstants.IntersectionType intersectionType) throws PolicyReferenceException {
        this._dahr = domainAssertionHandlerRegistry;
        if (intersectionType != null) {
            this._intersectionType = intersectionType;
        }
        if (filterType != null) {
            this._iterationType = filterType;
        }
        this._owningPolicy = policy;
        this._owningPolicyVocabulary = this._owningPolicy != null ? CoreUtils.getVocabulary(this._owningPolicy) : new HashSet<QName>();
        this._rootNode = NodeTreeBuilder.getNodeForPolicyElement(policy, domainAssertionHandlerRegistry, dataModelUtility, filterType, intersectionType);
        this._rootNode.reset();
    }

    public AlternativesIterator(DomainAssertionHandlerRegistry domainAssertionHandlerRegistry, DataModelUtility dataModelUtility, Policy policy) throws PolicyReferenceException {
        this(domainAssertionHandlerRegistry, dataModelUtility, policy, PolicyProcessor.FilterType.LOGICAL, null);
    }

    @Override
    public boolean hasNext() {
        if (this._deliveredFlag != null && !this._deliveredFlag.booleanValue()) {
            return true;
        }
        if (this._finalDelivered) {
            return false;
        }
        this._cachedAlternative = this.internalNext();
        if (this._cachedAlternative == null) {
            this._finalDelivered = true;
            return false;
        }
        this._deliveredFlag = false;
        return true;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Alternative next() {
        Alternative alternative = this.internalNext();
        if (alternative == null) {
            throw new NoSuchElementException();
        }
        return alternative;
    }

    private Alternative internalNext() {
        Alternative alternative = null;
        alternative = this.nextAlternative();
        if (this._iterationType.equals((Object)PolicyProcessor.FilterType.SUPPORTED)) {
            boolean bl = false;
            while (alternative != null && !bl) {
                PolicyConstants.IntersectionType intersectionType = null;
                intersectionType = this._intersectionType == null ? PolicyConstants.IntersectionType.STRICT : this._intersectionType;
                bl = AlternativeCheckUtils.checkIfSupportedAndMergeAssertionsIfPossible(this._dahr, alternative, this._iterationType, intersectionType);
                if (bl) break;
                alternative = this.nextAlternative();
            }
        }
        return alternative;
    }

    public void reset() {
        this._rootNode.reset();
        this._deliveredFlag = null;
        this._nullDelivered = false;
        this._finalDelivered = false;
    }

    private Alternative nextAlternative() {
        List list;
        if (this._deliveredFlag != null && !this._deliveredFlag.booleanValue()) {
            this._deliveredFlag = true;
            return this._cachedAlternative;
        }
        if (this._finalDelivered) {
            return null;
        }
        Alternative alternative = null;
        while (alternative == null && this._rootNode.hasNext() && (list = (List)this._rootNode.next()) != null) {
            alternative = new Alternative(list);
            alternative.setOwningPolicyVocabulary(this._owningPolicyVocabulary);
            if (list.size() != 0) continue;
            if (!this._nullDelivered) {
                this._nullDelivered = true;
                continue;
            }
            alternative = null;
        }
        return alternative;
    }

    public String toString() {
        return "Todo.";
    }

    public Policy getCompressedPolicy(DataModelFactory dataModelFactory, DataModelUtility dataModelUtility) {
        All all = (All)this._rootNode.getAsPolicyElement(dataModelFactory, dataModelUtility);
        Policy policy = dataModelFactory.createPolicy();
        policy.getChildren().addAll(all.getChildren());
        return policy;
    }
}

