/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wspolicy.internal.alternatives;

import com.ibm.webservices.component.logging.Tr;
import com.ibm.webservices.component.logging.TraceComponent;
import com.ibm.wspolicy.WSPolicyException;
import com.ibm.wspolicy.datamodel.Assertion;
import com.ibm.wspolicy.datamodel.Policy;
import com.ibm.wspolicy.domain.AssertionProcessor;
import com.ibm.wspolicy.internal.PolicyConstants;
import com.ibm.wspolicy.internal.WSPolicyInternalException;
import com.ibm.wspolicy.internal.alternatives.Alternative;
import com.ibm.wspolicy.internal.domain.DomainAssertionHandlerRegistry;
import com.ibm.wspolicy.internal.utils.CoreUtils;
import com.ibm.wspolicy.processor.PolicyProcessor;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import javax.xml.namespace.QName;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AlternativeCheckUtils {
    private static final TraceComponent tc = Tr.register(AlternativeCheckUtils.class, "WS-Policy", "com.ibm.ws.wspolicy.resources.CWPOLMessages");

    private static boolean mergeAssertionsByQNameWithinAlternativeIfPossible(DomainAssertionHandlerRegistry domainAssertionHandlerRegistry, Alternative alternative, PolicyProcessor.FilterType filterType, PolicyConstants.IntersectionType intersectionType) {
        int n;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "mergeAssertionsByQNameWithinAlternativeIfPossible");
        }
        if ((n = alternative.getAssertions().size()) < 2) {
            return true;
        }
        Set<QName> set = alternative.getIncludedVocabulary();
        if (n == set.size()) {
            return true;
        }
        Vector<Assertion> vector = new Vector<Assertion>(n);
        boolean bl = true;
        try {
            for (QName qName : set) {
                List<Assertion> list = alternative.getAssertions(qName);
                boolean bl2 = false;
                if (PolicyConstants.IntersectionType.LAX.equals((Object)intersectionType)) {
                    bl2 = true;
                    for (int i = 0; i < list.size(); ++i) {
                        boolean bl3 = bl2 = bl2 && list.get(i).isIgnorable();
                        if (!bl2) break;
                    }
                }
                if (!bl2) {
                    list = AlternativeCheckUtils.mergeAssertionsByQNameWithinVectorIfPossible(domainAssertionHandlerRegistry, list, intersectionType);
                }
                vector.addAll(list);
            }
        }
        catch (WSPolicyException wSPolicyException) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "checkAlternative", "   >>> INVALID ALTERNATIVE[" + alternative + "] SUPPORT = false");
            }
            bl = false;
        }
        if (bl) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "mergeAssertionsByQNameWithinAlternativeIfPossible", "   >>> ALTERNATIVE[" + alternative + "] SUPPORT = true");
            }
            alternative.setAssertions(vector);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "mergeAssertionsByQNameWithinAlternativeIfPossible", bl + "");
        }
        return bl;
    }

    private static List<Assertion> mergeAssertionsByQNameWithinVectorIfPossible(DomainAssertionHandlerRegistry domainAssertionHandlerRegistry, List<Assertion> list, PolicyConstants.IntersectionType intersectionType) throws WSPolicyInternalException {
        int n;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "mergeAssertionsByQNameWithinVectorIfPossible", new Object[]{list});
        }
        if ((n = list.size()) < 2) {
            return list;
        }
        Assertion assertion = list.get(0);
        Assertion assertion2 = null;
        Assertion assertion3 = null;
        for (int i = 1; i < n && (assertion3 = AlternativeCheckUtils.merge(domainAssertionHandlerRegistry, assertion, assertion2 = list.get(i), intersectionType)) != null; ++i) {
            assertion = assertion3;
        }
        if (assertion3 == null) {
            if (tc.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "mergeAssertionsByQNameWithinVectorIfPossible could not merge assertions");
            }
            throw new WSPolicyInternalException("");
        }
        Vector<Assertion> vector = new Vector<Assertion>(1);
        vector.add(assertion3);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "mergeAssertionsByQNameWithinVectorIfPossible", vector + "");
        }
        return vector;
    }

    public static boolean checkIfSupportedAndMergeAssertionsIfPossible(DomainAssertionHandlerRegistry domainAssertionHandlerRegistry, Alternative alternative, PolicyProcessor.FilterType filterType, PolicyConstants.IntersectionType intersectionType) {
        boolean bl = true;
        if (bl && PolicyProcessor.FilterType.SUPPORTED == filterType) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Alternative passed initial tests; examining the COMBINATIONS");
            }
            bl = AlternativeCheckUtils.mergeAssertionsByQNameWithinAlternativeIfPossible(domainAssertionHandlerRegistry, alternative, filterType, intersectionType);
        }
        return bl;
    }

    private static Assertion merge(DomainAssertionHandlerRegistry domainAssertionHandlerRegistry, Assertion assertion, Assertion assertion2, PolicyConstants.IntersectionType intersectionType) throws WSPolicyInternalException {
        AssertionProcessor assertionProcessor = domainAssertionHandlerRegistry.getWSPolicyProcessor(assertion);
        if (assertionProcessor == null && !assertion.isIgnorable()) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Policy processor object (a1) was unexpectedly null");
            }
            throw new WSPolicyInternalException();
        }
        if (assertionProcessor != domainAssertionHandlerRegistry.getWSPolicyProcessor(assertion2) && !assertion2.isIgnorable()) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Policy processor object (a2) was unexpectedly null");
            }
            throw new WSPolicyInternalException();
        }
        Assertion assertion3 = null;
        Policy policy = null;
        if (domainAssertionHandlerRegistry.hasMergeBehavior(assertion.getName())) {
            try {
                if (assertion.getNestedPolicy() != null && assertion2.getNestedPolicy() != null) {
                    Vector vector = new Vector();
                    Alternative alternative = CoreUtils.getQuickAlternativeForSingularizedPolicy(assertion.getNestedPolicy());
                    Alternative alternative2 = CoreUtils.getQuickAlternativeForSingularizedPolicy(assertion2.getNestedPolicy());
                    HashMap<QName, List<Object>> hashMap = new HashMap<QName, List<Object>>();
                    HashMap<QName, Boolean> hashMap2 = new HashMap<QName, Boolean>();
                    for (Assertion object : alternative.getAssertions()) {
                        if (hashMap.get(object.getName()) == null) {
                            hashMap.put(object.getName(), new Vector());
                        }
                        ((List)hashMap.get(object.getName())).add(object);
                        if (object.isIgnorable()) continue;
                        hashMap2.put(object.getName(), Boolean.FALSE);
                    }
                    for (Assertion assertion4 : alternative2.getAssertions()) {
                        if (hashMap.get(assertion4.getName()) == null) {
                            hashMap.put(assertion4.getName(), new Vector());
                        }
                        ((List)hashMap.get(assertion4.getName())).add(assertion4);
                        if (assertion4.isIgnorable()) continue;
                        hashMap2.put(assertion4.getName(), Boolean.FALSE);
                    }
                    for (Map.Entry entry : hashMap.entrySet()) {
                        if (hashMap2.get(entry.getKey()) == null && intersectionType != PolicyConstants.IntersectionType.STRICT) continue;
                        hashMap.put((QName)entry.getKey(), (List<Object>)AlternativeCheckUtils.mergeAssertionsByQNameWithinVectorIfPossible(domainAssertionHandlerRegistry, (List)entry.getValue(), intersectionType));
                    }
                    for (List list : hashMap.values()) {
                        vector.addAll(list);
                    }
                    assertion.getNestedPolicy().getChildren().clear();
                    assertion.getNestedPolicy().getChildren().addAll(vector);
                    policy = assertion.getNestedPolicy();
                } else {
                    policy = assertion.getNestedPolicy();
                    if (policy == null || policy.getChildren().size() == 0) {
                        policy = assertion2.getNestedPolicy();
                    }
                }
                assertion3 = assertionProcessor.combine(assertion, assertion2);
            }
            catch (Exception exception) {
                if (tc.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "merge caught exception ", exception);
                }
                Tr.processException(exception, "com.ibm.wspolicy.internal.alternatives.AlternativeCheckUtils.merge", "333");
                throw new WSPolicyInternalException(exception);
            }
        }
        try {
            policy = assertion.getNestedPolicy();
            assertion3 = domainAssertionHandlerRegistry.getDefaultAssertionMerger().combine(assertion, assertion2);
        }
        catch (Exception exception) {
            if (tc.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "merge caught exception ", exception);
            }
            Tr.processException(exception, "com.ibm.wspolicy.internal.alternatives.AlternativeCheckUtils.merge", "398");
            throw new WSPolicyInternalException(exception);
        }
        if (assertion3 == null) {
            if (tc.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "merged result is null");
            }
            throw new WSPolicyInternalException("Assertions are incompatible for combine");
        }
        assertion3.setNestedPolicy(policy);
        return assertion3;
    }

    public static boolean isEachAssertionInAlternativeSupported(DomainAssertionHandlerRegistry domainAssertionHandlerRegistry, Alternative alternative) {
        return AlternativeCheckUtils.isEachAssertionInAlternativeSupported(domainAssertionHandlerRegistry, alternative, PolicyProcessor.FilterType.SUPPORTED);
    }

    private static boolean isEachAssertionInAlternativeSupported(DomainAssertionHandlerRegistry domainAssertionHandlerRegistry, Alternative alternative, PolicyProcessor.FilterType filterType) {
        boolean bl = true;
        if (filterType == PolicyProcessor.FilterType.SUPPORTED) {
            List<Assertion> list = alternative.getAssertions();
            for (int i = 0; i < list.size(); ++i) {
                Assertion assertion = list.get(i);
                if (domainAssertionHandlerRegistry.isSupported(assertion)) continue;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "isEachAssertionInAlternativeSupported", ">>> SUPPORT for ASSERTION[" + assertion.getName() + "] = false");
                }
                bl = false;
                break;
            }
        }
        return bl;
    }
}

