/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wspolicy.internal.alternatives;

import com.ibm.webservices.component.logging.Tr;
import com.ibm.webservices.component.logging.TraceComponent;
import com.ibm.wspolicy.datamodel.Assertion;
import com.ibm.wspolicy.processor.PolicyProcessor;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.xml.namespace.QName;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Alternative
implements PolicyProcessor.Alternative {
    private static final TraceComponent TRACE_COMPONENT = Tr.register(Alternative.class, "WS-Policy", "com.ibm.ws.wspolicy.resources.CWPOLMessages");
    private List<Assertion> _assertions;
    private Set<QName> _owningPolicyVocabulary;
    private Set<QName> _negatedQnames;

    public Alternative(List<Assertion> list) {
        this._assertions = list;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("(");
        if (this._assertions == null) {
            stringBuffer.append(" ... EMPTY ... ");
        } else {
            for (int i = 0; i < this._assertions.size(); ++i) {
                Assertion assertion = this._assertions.get(i);
                stringBuffer.append(" " + assertion.toString());
            }
        }
        stringBuffer.append(")");
        return stringBuffer.toString();
    }

    @Override
    public List<Assertion> getAssertions() {
        if (this._assertions == null) {
            this._assertions = new ArrayList<Assertion>();
        }
        return this._assertions;
    }

    protected void setAssertions(List<Assertion> list) {
        this._assertions = list;
    }

    public List<Assertion> getAssertions(QName qName) {
        ArrayList<Assertion> arrayList = new ArrayList<Assertion>();
        if (qName == null) {
            return arrayList;
        }
        for (Assertion assertion : this._assertions) {
            QName qName2 = assertion.getName();
            if (!qName2.equals(qName)) continue;
            if (TRACE_COMPONENT.isDebugEnabled()) {
                Tr.debug(TRACE_COMPONENT, "getAssertions", "Matching QName for assertion " + qName2);
            }
            arrayList.add(assertion);
        }
        return arrayList;
    }

    public Set<QName> getNonIgnorableVocabulary() {
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "getNonIgnorableVocabulary");
        }
        HashSet<QName> hashSet = new HashSet<QName>();
        if (this._assertions != null) {
            for (Assertion assertion : this._assertions) {
                if (assertion.isIgnorable()) continue;
                hashSet.add(assertion.getName());
            }
        }
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "getNonIgnorableVocabulary", hashSet);
        }
        return hashSet;
    }

    private Set<QName> getVocabulary() {
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "getVocabulary");
        }
        HashSet<QName> hashSet = new HashSet<QName>();
        if (this._assertions != null) {
            for (Assertion assertion : this._assertions) {
                hashSet.add(assertion.getName());
            }
        }
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "getVocabulary", hashSet);
        }
        return hashSet;
    }

    protected void setOwningPolicyVocabulary(Set<QName> set) {
        this._owningPolicyVocabulary = set;
    }

    @Override
    public Set<QName> getNegatedVocabulary() {
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "getExplicitNegationQNames");
        }
        if (this._negatedQnames == null) {
            this._negatedQnames = new HashSet<QName>();
            if (this._owningPolicyVocabulary != null) {
                this._negatedQnames.addAll(this._owningPolicyVocabulary);
                this._negatedQnames.removeAll(this.getVocabulary());
            }
        }
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "getExplicitNegationQNames", this._negatedQnames);
        }
        return new HashSet<QName>(this._negatedQnames);
    }

    public void setExplicitNegationQNames(Set<QName> set) {
        this._negatedQnames = set;
    }

    @Override
    public Set<QName> getIncludedVocabulary() {
        return this.getVocabulary();
    }
}

