/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wspolicy.factory;

import com.ibm.webservices.component.logging.Tr;
import com.ibm.webservices.component.logging.TraceComponent;
import com.ibm.wspolicy.factory.ConfigurationException;
import com.ibm.wspolicy.factory.DataModelFactory;
import com.ibm.wspolicy.factory.FactoryConfiguration;
import com.ibm.wspolicy.factory.WSDigestValidator;
import com.ibm.wspolicy.processor.DataModelUtility;
import com.ibm.wspolicy.processor.PolicyProcessor;
import com.ibm.wspolicy.xml.ElementReader;
import com.ibm.wspolicy.xml.ElementReaderException;
import com.ibm.wspolicy.xml.ElementWriter;
import com.ibm.wspolicy.xml.ElementWriterException;
import java.lang.reflect.Constructor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class WSPolicyFactory {
    private static final TraceComponent tc = Tr.register(WSPolicyFactory.class, null, null);
    private static Constructor<WSPolicyFactory> constructor;

    public static WSPolicyFactory newInstance() {
        if (tc.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "newInstance");
        }
        try {
            WSPolicyFactory wSPolicyFactory = WSPolicyFactory.newInstance(null);
            if (tc.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "newInstance", wSPolicyFactory);
            }
            return wSPolicyFactory;
        }
        catch (ConfigurationException configurationException) {
            Tr.processException(configurationException, "com.ibm.wspolicy.factory.WSPolicyFactory.newInstance", "63");
            throw new RuntimeException();
        }
    }

    public static WSPolicyFactory newInstance(FactoryConfiguration factoryConfiguration) throws ConfigurationException {
        if (tc.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "newInstance", factoryConfiguration);
        }
        try {
            WSPolicyFactory wSPolicyFactory = constructor.newInstance(factoryConfiguration);
            if (tc.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "newInstance", wSPolicyFactory);
            }
            return wSPolicyFactory;
        }
        catch (Exception exception) {
            Tr.processException(exception, "com.ibm.wspolicy.factory.WSPolicyFactory.newInstance", "65");
            if (exception instanceof ConfigurationException) {
                throw (ConfigurationException)exception;
            }
            if (tc.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "newInstance", null);
            }
            throw new ConfigurationException();
        }
    }

    public abstract DataModelUtility createDataModelUtility();

    public abstract DataModelFactory createDataModelFactory();

    public abstract PolicyProcessor createWSPolicyProcessor();

    public abstract <T> ElementWriter<T> getWriter(Class<T> var1) throws ElementWriterException;

    public abstract <T> ElementReader<T> getReader(Class<T> var1) throws ElementReaderException;

    public abstract WSDigestValidator getDigestValidator(String var1);

    static {
        try {
            Class<?> clazz = Class.forName("com.ibm.wspolicy.internal.factory.WSPolicyFactoryImpl");
            constructor = clazz.getConstructor(FactoryConfiguration.class);
        }
        catch (Exception exception) {
            Tr.processException(exception, "com.ibm.wspolicy.factory.WSPolicyFactory.<clinit>", "52");
        }
    }
}

