/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws390.sm.smf;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.ras.Traceable;
import com.ibm.ws390.sm.smf.SmfContainerInfo;
import com.ibm.ws390.sm.smf.SmfJActivity;
import com.ibm.ws390.sm.smf.SmfProperty;
import com.ibm.ws390.sm.smf.SmfPropertyVector;
import com.ibm.ws390.sm.smf.SmfRequestTracker;
import com.ibm.ws390.sm.smf.SmfWebContainerCookie;
import com.ibm.ws390.sm.smf.SmfWebContainerCookieTable;
import com.ibm.ws390.sm.smf.SmfWebContainerDataCollector;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public final class SmfWebContainerDataCollectorImpl
implements SmfWebContainerDataCollector,
Traceable {
    private static final int s_initialCapacity = 29;
    private static SmfWebContainerDataCollectorImpl s_instance = null;
    private boolean m_activityRecordingEnabled = SmfJActivity.isContainerActivityRecordingEnabled();
    private boolean m_intervalRecordingEnabled = SmfJActivity.isContainerIntervalRecordingEnabled();
    private Map m_intervalCookieMap = Collections.synchronizedMap(new HashMap(29));
    private int m_liveSessionCount = 0;
    private int m_activeSessionCount = 0;
    private static TraceComponent m_tc = Tr.register("com.ibm.ws390.sm.smf.SmfWebContainerDataCollectorImpl", null, "com.ibm.ws390.sm.smf.SmfWebContainer");

    private SmfWebContainerDataCollectorImpl() {
    }

    protected SmfWebContainerDataCollectorImpl(boolean anActivityRecordingFlag, boolean anIntervalRecordingFlag) {
        this();
        this.m_activityRecordingEnabled = anActivityRecordingFlag;
        this.m_intervalRecordingEnabled = anIntervalRecordingFlag;
    }

    public void activeSessionCount(int anActiveSessionCount) {
        if (this.m_intervalRecordingEnabled) {
            if (m_tc.isEntryEnabled()) {
                Tr.entry(m_tc, "activeSessionCount", new Integer(anActiveSessionCount));
            }
            this.m_activeSessionCount = anActiveSessionCount;
            if (m_tc.isEntryEnabled()) {
                Tr.exit(m_tc, "activeSessionCount");
            }
        }
    }

    private SmfWebContainerCookie findCurrentCookie() {
        return SmfWebContainerCookieTable.getInstance().findCookie();
    }

    private SmfWebContainerCookie findIntervalCookie(String aWebAppName) {
        return (SmfWebContainerCookie)this.m_intervalCookieMap.get(aWebAppName);
    }

    private SmfWebContainerCookie findOrCreateIntervalCookie(String aWebAppName) {
        SmfWebContainerCookie cookie = this.findIntervalCookie(aWebAppName);
        if (cookie == null) {
            cookie = new SmfWebContainerCookie(aWebAppName);
            this.m_intervalCookieMap.put(aWebAppName, cookie);
        }
        return cookie;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flush() {
        if (this.m_intervalRecordingEnabled) {
            if (m_tc.isEntryEnabled()) {
                Tr.entry(m_tc, "flush");
            }
            SmfPropertyVector v = new SmfPropertyVector();
            SmfProperty prop = new SmfProperty(0, 7);
            v.addElement(prop);
            if (this.m_activeSessionCount > 0) {
                prop = new SmfProperty(1, this.m_activeSessionCount);
                v.addElement(prop);
            }
            if (this.m_liveSessionCount > 0) {
                prop = new SmfProperty(5, this.m_liveSessionCount);
                v.addElement(prop);
            }
            Map map = this.m_intervalCookieMap;
            synchronized (map) {
                Iterator iterator = this.m_intervalCookieMap.values().iterator();
                SmfWebContainerCookie cookie = null;
                while (iterator.hasNext()) {
                    cookie = (SmfWebContainerCookie)iterator.next();
                    while (!cookie.addTo(v) || v.size() > 1) {
                        SmfJActivity activity = new SmfJActivity();
                        activity.addGenericEvent(7, v.toByteArray());
                        prop = new SmfProperty(0, 7);
                        v.addElement(prop);
                    }
                }
            }
            if (v.size() > 1 && m_tc.isEventEnabled()) {
                Tr.event(m_tc, "flush internal error: unable to flush all data");
            }
            this.m_activeSessionCount = 0;
            this.m_liveSessionCount = 0;
            this.m_intervalCookieMap.clear();
            if (m_tc.isEntryEnabled()) {
                Tr.exit(m_tc, "flush");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static SmfWebContainerDataCollector getInstance() {
        if (s_instance != null) return s_instance;
        Class<SmfWebContainerDataCollectorImpl> clazz = SmfWebContainerDataCollectorImpl.class;
        synchronized (SmfWebContainerDataCollectorImpl.class) {
            if (s_instance != null) return s_instance;
            s_instance = new SmfWebContainerDataCollectorImpl();
            // ** MonitorExit[var0] (shouldn't be in output)
            return s_instance;
        }
    }

    public void httpSessionCreated() {
        if (this.m_activityRecordingEnabled || this.m_intervalRecordingEnabled) {
            SmfWebContainerCookie cookie;
            if (m_tc.isEntryEnabled()) {
                Tr.entry(m_tc, "httpSessionCreated");
            }
            if ((cookie = this.findCurrentCookie()) != null) {
                cookie.incrementHttpSessionCreateCount();
            } else {
                this.traceUnableToFindServlet("httpSessionCreated");
            }
            if (m_tc.isEntryEnabled()) {
                Tr.exit(m_tc, "httpSessionCreated");
            }
        }
    }

    public void httpSessionFinalized() {
        if (this.m_activityRecordingEnabled || this.m_intervalRecordingEnabled) {
            SmfWebContainerCookie cookie;
            if (m_tc.isEntryEnabled()) {
                Tr.entry(m_tc, "httpSessionFinalized");
            }
            if ((cookie = this.findCurrentCookie()) != null) {
                cookie.incrementHttpSessionFinalizeCount();
            } else {
                this.traceUnableToFindServlet("httpSessionFinalized");
            }
            if (m_tc.isEntryEnabled()) {
                Tr.exit(m_tc, "httpSessionFinalized");
            }
        }
    }

    public void httpSessionInvalidated() {
        if (this.m_activityRecordingEnabled || this.m_intervalRecordingEnabled) {
            SmfWebContainerCookie cookie;
            if (m_tc.isEntryEnabled()) {
                Tr.entry(m_tc, "httpSessionInvalidated");
            }
            if ((cookie = this.findCurrentCookie()) != null) {
                cookie.incrementHttpSessionInvalidateCount();
            } else {
                this.traceUnableToFindServlet("httpSessionInvalidated");
            }
            if (m_tc.isEntryEnabled()) {
                Tr.exit(m_tc, "httpSessionInvalidated");
            }
        }
    }

    public void httpSessionInvalidateTime(int aNewInvalidateTime) {
        if (this.m_activityRecordingEnabled || this.m_intervalRecordingEnabled) {
            SmfWebContainerCookie cookie;
            if (m_tc.isEntryEnabled()) {
                Tr.entry(m_tc, "httpSessionInvalidateTime", new Integer(aNewInvalidateTime));
            }
            if ((cookie = this.findCurrentCookie()) != null) {
                cookie.setHttpSessionInvalidateTime(aNewInvalidateTime);
            } else {
                this.traceUnableToFindServlet("httpSessionInvalidateTime");
            }
            if (m_tc.isEntryEnabled()) {
                Tr.exit(m_tc, "httpSessionInvalidateTime");
            }
        }
    }

    public void httpSessionLifeTime(int aNewLifeTime) {
        if (this.m_activityRecordingEnabled || this.m_intervalRecordingEnabled) {
            SmfWebContainerCookie cookie;
            if (m_tc.isEntryEnabled()) {
                Tr.entry(m_tc, "httpSessionLifeTime", new Integer(aNewLifeTime));
            }
            if ((cookie = this.findCurrentCookie()) != null) {
                cookie.setHttpSessionLifeTime(aNewLifeTime);
            } else {
                this.traceUnableToFindServlet("httpSessionLifeTime");
            }
            if (m_tc.isEntryEnabled()) {
                Tr.exit(m_tc, "httpSessionLifeTime");
            }
        }
    }

    public boolean isSmfRecordingEnabled() {
        return this.m_activityRecordingEnabled || this.m_intervalRecordingEnabled || SmfContainerInfo.isSmf120St9AndCpuUsageEnabled();
    }

    public void liveSessionCount(int aLiveSessionCount) {
        if (this.m_intervalRecordingEnabled) {
            if (m_tc.isEntryEnabled()) {
                Tr.entry(m_tc, "liveSessionCount", new Integer(aLiveSessionCount));
            }
            this.m_liveSessionCount = aLiveSessionCount;
            if (m_tc.isEntryEnabled()) {
                Tr.exit(m_tc, "liveSessionCount");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void print() {
        System.out.println("SmfWebContainerDataCollector.print:");
        System.out.println("   activityRecordingEnabled: " + this.m_activityRecordingEnabled);
        System.out.println("   intervalRecordingEnabled: " + this.m_intervalRecordingEnabled);
        System.out.println("   activeSessionCount: " + this.m_activeSessionCount);
        System.out.println("   liveSessionCount:   " + this.m_liveSessionCount);
        System.out.println("Interval-related cookies:");
        Map map = this.m_intervalCookieMap;
        synchronized (map) {
            Iterator iterator = this.m_intervalCookieMap.values().iterator();
            SmfWebContainerCookie cookie = null;
            while (iterator.hasNext()) {
                cookie = (SmfWebContainerCookie)iterator.next();
                cookie.print();
            }
        }
    }

    public void servletError(String aWebAppName, String aServletName) {
        if (this.m_activityRecordingEnabled || this.m_intervalRecordingEnabled) {
            SmfWebContainerCookie cookie;
            if (m_tc.isEntryEnabled()) {
                Object[] objs = new Object[]{aWebAppName, aServletName};
                Tr.entry(m_tc, "servletError", objs);
            }
            if ((cookie = this.findCurrentCookie()) != null) {
                cookie.processServletError(aWebAppName, aServletName);
            } else {
                this.traceUnableToFindServlet("servletError");
            }
            if (m_tc.isEntryEnabled()) {
                Tr.exit(m_tc, "servletError");
            }
        }
    }

    public void servletLoaded(String aWebAppName, String aServletName, long aLoadedSince) {
        if (this.m_activityRecordingEnabled || this.m_intervalRecordingEnabled) {
            SmfWebContainerCookie cookie;
            if (m_tc.isEntryEnabled()) {
                Object[] objs = new Object[]{aWebAppName, aServletName, new Long(aLoadedSince)};
                Tr.entry(m_tc, "servletLoaded", objs);
            }
            if ((cookie = this.findCurrentCookie()) == null) {
                if (this.m_intervalRecordingEnabled) {
                    cookie = this.findOrCreateIntervalCookie(aWebAppName);
                } else {
                    if (m_tc.isEntryEnabled()) {
                        Tr.exit(m_tc, "servletLoaded", "Ignore method request: interval recording is not enabled.");
                    }
                    return;
                }
            }
            cookie.processServletLoaded(aWebAppName, aServletName, aLoadedSince);
            if (m_tc.isEntryEnabled()) {
                Tr.exit(m_tc, "servletLoaded");
            }
        }
    }

    public void servletRequestEnds(String aWebAppName, String aServletName, long aLoadedSince, int aResponseElapsedTime) {
        boolean smf120St9Enabled = SmfContainerInfo.isSmf120St9AndCpuUsageEnabled();
        if (this.m_activityRecordingEnabled || this.m_intervalRecordingEnabled || smf120St9Enabled) {
            SmfWebContainerCookie cookie;
            if (m_tc.isEntryEnabled()) {
                Object[] objs = new Object[]{aWebAppName, aServletName, new Long(aLoadedSince), new Integer(aResponseElapsedTime)};
                Tr.entry(m_tc, "servletRequestEnds", objs);
            }
            if ((cookie = this.findCurrentCookie()) != null) {
                cookie.processServletRequestEnds(aWebAppName, aServletName, aLoadedSince, aResponseElapsedTime);
                if (smf120St9Enabled) {
                    SmfRequestTracker smfRequestTracker = SmfContainerInfo.smfReqTrackerStackIntThreadLocal.get().stack.pop();
                    smfRequestTracker.setEndCpTime(cookie.getServletCpuEndTime(aServletName));
                    smfRequestTracker.setEndTime();
                    if (SmfContainerInfo.smfReqTrackerStackIntThreadLocal.get().stack.empty()) {
                        SmfJActivity.saveSmfRequestTrackerValues(SmfRequestTracker.computeTotals(SmfContainerInfo.smfReqTrackerArrayListThreadLocal.get()));
                        SmfContainerInfo.smfReqTrackerArrayListThreadLocal.get().clear();
                    }
                }
            } else {
                this.traceUnableToFindServlet("servletRequestEnds");
            }
            if (m_tc.isEntryEnabled()) {
                Tr.exit(m_tc, "servletRequestEnds");
            }
        }
    }

    public void servletRequestBegins(String aWebAppName, String aServletName) {
        boolean smf120St9Enabled = SmfContainerInfo.isSmf120St9AndCpuUsageEnabled();
        if (this.m_activityRecordingEnabled || this.m_intervalRecordingEnabled || smf120St9Enabled) {
            SmfWebContainerCookie cookie;
            if (m_tc.isEntryEnabled()) {
                Object[] objs = new Object[]{aWebAppName, aServletName};
                Tr.entry(m_tc, "servletRequestBegins", objs);
            }
            if ((cookie = this.findCurrentCookie()) != null) {
                cookie.processServletRequestBegins(aWebAppName, aServletName);
                if (smf120St9Enabled) {
                    if (SmfContainerInfo.smf120St9CpuLastDisabled > SmfContainerInfo.smfReqTrackerStackIntThreadLocal.get().lastDisabled) {
                        SmfContainerInfo.smfReqTrackerStackIntThreadLocal.get().stack.clear();
                        SmfContainerInfo.smfReqTrackerArrayListThreadLocal.get().clear();
                        SmfContainerInfo.smfReqTrackerStackIntThreadLocal.get().lastDisabled = SmfContainerInfo.smf120St9CpuLastDisabled;
                    }
                    SmfRequestTracker smfRequestTracker = new SmfRequestTracker(SmfContainerInfo.smfReqTrackerArrayListThreadLocal.get(), aServletName, aWebAppName, cookie.getServletCpuStartTime(aServletName), 2);
                    SmfContainerInfo.smfReqTrackerStackIntThreadLocal.get().stack.push(smfRequestTracker);
                }
            } else {
                this.traceUnableToFindServlet("servletRequestBegins");
            }
            if (m_tc.isEntryEnabled()) {
                Tr.exit(m_tc, "servletRequestBegins");
            }
        }
    }

    public void servletsLoaded(String aWebAppName, int aLoadedServletCount) {
        if (this.m_intervalRecordingEnabled) {
            if (m_tc.isEntryEnabled()) {
                Object[] objs = new Object[]{aWebAppName, new Integer(aLoadedServletCount)};
                Tr.entry(m_tc, "servletsLoaded", objs);
            }
            SmfWebContainerCookie cookie = this.findOrCreateIntervalCookie(aWebAppName);
            cookie.setServletLoadCount(aLoadedServletCount);
            if (m_tc.isEntryEnabled()) {
                Tr.exit(m_tc, "servletsLoaded");
            }
        }
    }

    public String toTraceString() {
        StringBuffer sb = new StringBuffer("SmfWebContainerDataCollectorImpl (");
        sb.append("activityRecordingEnabled=").append(this.m_activityRecordingEnabled).append(", ");
        sb.append("intervalRecordingEnabled=").append(this.m_intervalRecordingEnabled).append(")");
        return sb.toString();
    }

    private void traceUnableToFindServlet(String aMethodName) {
        if (m_tc.isEventEnabled()) {
            Object[] objs = new Object[]{aMethodName};
            StringBuffer sb = new StringBuffer("Method {0}: ");
            sb.append("Unexpectedly, no SmfWebContainerCookie object could ").append("be found for the current thread.");
            Tr.event(m_tc, sb.toString(), objs);
        }
    }

    public void webContainerDispatchBegins() {
        if (this.m_activityRecordingEnabled || this.m_intervalRecordingEnabled || SmfContainerInfo.isSmf120St9AndCpuUsageEnabled()) {
            if (m_tc.isEntryEnabled()) {
                Tr.entry(m_tc, "webContainerDispatchBegins");
            }
            SmfWebContainerCookieTable table = SmfWebContainerCookieTable.getInstance();
            table.findOrCreateCookie();
            if (m_tc.isEntryEnabled()) {
                Tr.exit(m_tc, "webContainerDispatchBegins");
            }
        }
    }

    public void webContainerDispatchEnds() {
        if (this.m_activityRecordingEnabled || this.m_intervalRecordingEnabled || SmfContainerInfo.isSmf120St9AndCpuUsageEnabled()) {
            SmfWebContainerCookie cookie;
            if (m_tc.isEntryEnabled()) {
                Tr.entry(m_tc, "webContainerDispatchEnds");
            }
            if ((cookie = this.findCurrentCookie()) != null) {
                SmfPropertyVector v = new SmfPropertyVector();
                SmfProperty prop = new SmfProperty(0, 6);
                v.addElement(prop);
                while (!cookie.addTo(v) || v.size() > 1) {
                    SmfJActivity activity = new SmfJActivity();
                    activity.addGenericEvent(6, v.toByteArray());
                    prop = new SmfProperty(0, 6);
                    v.addElement(prop);
                }
                if (v.size() > 1 && m_tc.isEventEnabled()) {
                    Tr.event(m_tc, "webContainerDispatchEnds internal error: unable to flush all data");
                }
                SmfWebContainerCookieTable.getInstance().removeCookie();
            } else {
                this.traceUnableToFindServlet("webContainerDispatchEnds");
            }
            if (m_tc.isEntryEnabled()) {
                Tr.exit(m_tc, "webContainerDispatchEnds");
            }
        }
    }
}

