/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws390.sm.smf;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws390.sm.smf.SmfConst;
import java.io.ByteArrayOutputStream;
import java.io.UnsupportedEncodingException;

public final class SmfOutputStream
extends ByteArrayOutputStream {
    private static TraceComponent m_tc = Tr.register("com.ibm.ws390.sm.smf.SmfOutputStream", null, "com.ibm.ws390.sm.smf.SmfWebContainer");

    public void putBytes(byte[] someBytes) {
        this.write(someBytes, 0, someBytes.length);
    }

    public void putInteger4(int anInt) {
        this.write(anInt >>> 24 & 0xFF);
        this.write(anInt >>> 16 & 0xFF);
        this.write(anInt >>> 8 & 0xFF);
        this.write(anInt >>> 0 & 0xFF);
    }

    public void putString(String aString, String anEncoding, int aNumBytes) {
        if (aString == null || aNumBytes <= 0) {
            return;
        }
        if (anEncoding == null) {
            anEncoding = SmfConst.UNICODE_BE;
        }
        int numCharacters = aNumBytes - SmfConst.getPaddingByteNumber(anEncoding);
        if (SmfConst.isDoubleByte(anEncoding)) {
            numCharacters /= 2;
        }
        String sourceString = aString;
        int numExtraCharacers = aString.length() - numCharacters;
        if (numExtraCharacers > 0) {
            sourceString = aString.substring(0, numCharacters);
        } else if (numExtraCharacers < 0) {
            StringBuffer sb = new StringBuffer(numCharacters);
            sb.append(sourceString);
            for (int i = 0; i > numExtraCharacers; --i) {
                sb.append(" ");
            }
            sourceString = sb.toString();
        }
        byte[] bArray = null;
        try {
            bArray = sourceString.getBytes(anEncoding);
        }
        catch (UnsupportedEncodingException e) {
            if (m_tc.isEventEnabled()) {
                Object[] objs = new Object[]{anEncoding};
                String str = "putString: UnsupportedEncodingException caught for encoding {0}.";
                Tr.event(m_tc, str, objs);
            }
            StringBuffer sb = new StringBuffer(numCharacters);
            for (int i = 0; i < numCharacters; ++i) {
                sb.append(" ");
            }
            sourceString = sb.toString();
            bArray = sourceString.getBytes();
        }
        if (bArray.length != aNumBytes && m_tc.isEventEnabled()) {
            Object[] objs = new Object[]{sourceString, new Integer(bArray.length), new Integer(aNumBytes)};
            String str = "putString >{0}<: Internal error: bArray.length={1}, aNumBytes={2}.";
            Tr.event(m_tc, str, objs);
        }
        this.write(bArray, 0, bArray.length);
    }
}

