/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws390.sm.smf;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.smf.SmfEventInfrastructure;
import com.ibm.websphere.smf.SmfEventNotifier;
import com.ibm.ws390.sm.smf.Smf120St9UserDataObject;
import com.ibm.ws390.sm.smf.Smf120St9UserDataTracker;
import com.ibm.ws390.sm.smf.SmfContainerInfo;
import com.ibm.ws390.sm.smf.SmfEventInfrastructureFactory;
import java.util.ArrayList;
import javax.naming.NamingException;
import javax.naming.Reference;
import javax.naming.Referenceable;

public class SmfEventInfrastructureImpl
implements SmfEventInfrastructure,
Referenceable {
    static TraceComponent tc = Tr.register(SmfEventInfrastructureImpl.class, "PMI", null);
    private static final int USER_DATA_HEADER_LENGTH = 12;
    private static final int MAX_USER_DATA_LEN = 2048;
    private static final int MAX_NUM_USER_DATA = 5;
    private static final String _factoryName = SmfEventInfrastructureFactory.class.getName();

    public SmfEventInfrastructureImpl() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "<init>");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "<init>", this);
        }
    }

    public Reference getReference() throws NamingException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getReference");
        }
        Reference ref = new Reference(this.getClass().getName(), _factoryName, null);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getReference", ref);
        }
        return ref;
    }

    public int register(SmfEventNotifier sen) {
        int rc;
        block6: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "register");
            }
            rc = 0;
            try {
                ArrayList<SmfEventNotifier> notifiers = SmfContainerInfo.getSmfEventNotifierArrayListThreadLocal();
                if (!notifiers.contains(sen)) {
                    notifiers.add(sen);
                } else {
                    rc = 1;
                }
            }
            catch (Exception e) {
                rc = 1;
                if (!tc.isDebugEnabled()) break block6;
                Tr.debug(tc, "Exception while registering SmfEventNotifier: " + sen.identifySelf() + " Exception: " + e);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "register rc= " + rc);
        }
        return rc;
    }

    public int deregister(SmfEventNotifier sen) {
        int rc;
        block4: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "deregister");
            }
            rc = 0;
            try {
                ArrayList<SmfEventNotifier> registeredSENs = SmfContainerInfo.getSmfEventNotifierArrayListThreadLocal();
                rc = !registeredSENs.contains(sen) ? 1 : (registeredSENs.remove(sen) ? 0 : 2);
            }
            catch (Exception e) {
                rc = 1;
                if (!tc.isDebugEnabled()) break block4;
                Tr.debug(tc, "Exception while deregistering SmfEventNotifier: " + sen.identifySelf() + " Exception: " + e);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "deregister rc= " + rc);
        }
        return rc;
    }

    public Boolean isSMF120Subtype9Enabled() {
        return new Boolean(SmfContainerInfo.isSmf120St9Enabled());
    }

    public int addDataToSMF120Subtype9Record(int type, byte[] data) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "addDataToSMF120Subtype9Record");
        }
        Smf120St9UserDataTracker userDataTracker = SmfContainerInfo.getSmfUserDataThreadLocal();
        ArrayList userData = userDataTracker.getUserData();
        int rc = 0;
        int size = userData.size();
        if (!this.isSMF120Subtype9Enabled().booleanValue()) {
            rc = 16;
        } else if (!userDataTracker.isDispatchThread()) {
            rc = 20;
        } else if (data.length > 2048) {
            rc = 8;
        } else {
            for (int i = 0; i < size; ++i) {
                Smf120St9UserDataObject tmp = (Smf120St9UserDataObject)userData.get(i);
                if (tmp.getType() != type) continue;
                userData.set(i, new Smf120St9UserDataObject(type, data));
                rc = 4;
                break;
            }
            if (rc == 0) {
                if (size == 5) {
                    rc = 12;
                } else {
                    userData.add(new Smf120St9UserDataObject(type, data));
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "addDataToSMF120Subtype9Record rc= " + rc);
        }
        return rc;
    }
}

