/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws390.sm.smf;

import com.ibm.websphere.csi.EJBMethodInfo;
import com.ibm.ws.csi.DispatchEventListener;
import com.ibm.ws.csi.DispatchEventListenerCookie;
import com.ibm.ws390.sm.smf.SmfContainerInfo;
import com.ibm.ws390.sm.smf.SmfEventRecorderCookie;
import com.ibm.ws390.sm.smf.SmfJActivity;
import com.ibm.ws390.sm.smf.SmfRequestTracker;

public class SmfDispatchEventRecorder
implements DispatchEventListener {
    private boolean nonSubtype9Recording = false;

    public boolean initialize() {
        String CurrentBitmode = System.getProperty("com.ibm.vm.bitmode");
        int bitmode = Integer.parseInt(CurrentBitmode);
        if (bitmode == 64) {
            System.loadLibrary("bbgosmf");
        } else {
            System.loadLibrary("bboosmf");
        }
        int recordingStatus = SmfJActivity.smfState();
        if ((recordingStatus & Integer.MIN_VALUE) == 0 && ((recordingStatus & 0x10000000) == 0x10000000 || (recordingStatus & 0x8000000) == 0x8000000)) {
            this.nonSubtype9Recording = true;
        }
        return this.nonSubtype9Recording || SmfContainerInfo.isSmf120St9AndCpuUsageEnabled();
    }

    public DispatchEventListenerCookie beginDispatch(EJBMethodInfo info) {
        SmfEventRecorderCookie cookie = new SmfEventRecorderCookie();
        cookie.cpuTimeUsedStart();
        if (SmfContainerInfo.isSmf120St9AndCpuUsageEnabled()) {
            if (SmfContainerInfo.smf120St9CpuLastDisabled > SmfContainerInfo.smfReqTrackerStackIntThreadLocal.get().lastDisabled) {
                SmfContainerInfo.smfReqTrackerStackIntThreadLocal.get().stack.clear();
                SmfContainerInfo.smfReqTrackerArrayListThreadLocal.get().clear();
                SmfContainerInfo.smfReqTrackerStackIntThreadLocal.get().lastDisabled = SmfContainerInfo.smf120St9CpuLastDisabled;
            }
            SmfRequestTracker smfRequestTracker = new SmfRequestTracker(SmfContainerInfo.smfReqTrackerArrayListThreadLocal.get(), info.getMethodSignature(), info.getAMCName(), cookie.getMethodCpuTimeUsedStart(), 1);
            SmfContainerInfo.smfReqTrackerStackIntThreadLocal.get().stack.push(smfRequestTracker);
        }
        return cookie;
    }

    public void beforeEjbActivate(EJBMethodInfo info, DispatchEventListenerCookie cookie) {
        if (this.nonSubtype9Recording) {
            try {
                SmfEventRecorderCookie smfCookie = (SmfEventRecorderCookie)cookie;
                smfCookie.start(0);
            }
            catch (ClassCastException classCastException) {
                // empty catch block
            }
        }
    }

    public void afterEjbActivate(EJBMethodInfo info, DispatchEventListenerCookie cookie) {
        if (this.nonSubtype9Recording) {
            try {
                SmfEventRecorderCookie smfCookie = (SmfEventRecorderCookie)cookie;
                smfCookie.stop(0);
            }
            catch (ClassCastException classCastException) {
                // empty catch block
            }
        }
    }

    public void beforeEjbLoad(EJBMethodInfo info, DispatchEventListenerCookie cookie) {
        if (this.nonSubtype9Recording) {
            try {
                SmfEventRecorderCookie smfCookie = (SmfEventRecorderCookie)cookie;
                smfCookie.start(1);
            }
            catch (ClassCastException classCastException) {
                // empty catch block
            }
        }
    }

    public void afterEjbLoad(EJBMethodInfo info, DispatchEventListenerCookie cookie) {
        if (this.nonSubtype9Recording) {
            try {
                SmfEventRecorderCookie smfCookie = (SmfEventRecorderCookie)cookie;
                smfCookie.stop(1);
            }
            catch (ClassCastException classCastException) {
                // empty catch block
            }
        }
    }

    public void beforeEjbMethod(EJBMethodInfo info, DispatchEventListenerCookie cookie) {
        if (this.nonSubtype9Recording) {
            try {
                SmfEventRecorderCookie smfCookie = (SmfEventRecorderCookie)cookie;
                smfCookie.start(2);
            }
            catch (ClassCastException classCastException) {
                // empty catch block
            }
        }
    }

    public void afterEjbMethod(EJBMethodInfo info, DispatchEventListenerCookie cookie) {
        if (this.nonSubtype9Recording) {
            try {
                SmfEventRecorderCookie smfCookie = (SmfEventRecorderCookie)cookie;
                smfCookie.stop(2);
            }
            catch (ClassCastException classCastException) {
                // empty catch block
            }
        }
    }

    public void beforeEjbStore(EJBMethodInfo info, DispatchEventListenerCookie cookie) {
        if (this.nonSubtype9Recording) {
            try {
                SmfEventRecorderCookie smfCookie = (SmfEventRecorderCookie)cookie;
                smfCookie.start(3);
            }
            catch (ClassCastException classCastException) {
                // empty catch block
            }
        }
    }

    public void afterEjbStore(EJBMethodInfo info, DispatchEventListenerCookie cookie) {
        if (this.nonSubtype9Recording) {
            try {
                SmfEventRecorderCookie smfCookie = (SmfEventRecorderCookie)cookie;
                smfCookie.stop(3);
            }
            catch (ClassCastException classCastException) {
                // empty catch block
            }
        }
    }

    public void beforeEjbPassivate(EJBMethodInfo info, DispatchEventListenerCookie cookie) {
        if (this.nonSubtype9Recording) {
            try {
                SmfEventRecorderCookie smfCookie = (SmfEventRecorderCookie)cookie;
                smfCookie.start(4);
            }
            catch (ClassCastException classCastException) {
                // empty catch block
            }
        }
    }

    public void afterEjbPassivate(EJBMethodInfo info, DispatchEventListenerCookie cookie) {
        if (this.nonSubtype9Recording) {
            try {
                SmfEventRecorderCookie smfCookie = (SmfEventRecorderCookie)cookie;
                smfCookie.stop(4);
            }
            catch (ClassCastException classCastException) {
                // empty catch block
            }
        }
    }

    public void endDispatch(EJBMethodInfo info, DispatchEventListenerCookie cookie) {
        try {
            SmfEventRecorderCookie smfCookie = (SmfEventRecorderCookie)cookie;
            smfCookie.cpuTimeUsedEnd();
            if (SmfContainerInfo.isSmf120St9AndCpuUsageEnabled()) {
                SmfRequestTracker smfRequestTracker = SmfContainerInfo.smfReqTrackerStackIntThreadLocal.get().stack.pop();
                smfRequestTracker.setEndCpTime(smfCookie.getMethodCpuTimeUsedEnd());
                smfRequestTracker.setEndTime();
                if (SmfContainerInfo.smfReqTrackerStackIntThreadLocal.get().stack.empty()) {
                    SmfJActivity.saveSmfRequestTrackerValues(SmfRequestTracker.computeTotals(SmfContainerInfo.smfReqTrackerArrayListThreadLocal.get()));
                    SmfContainerInfo.smfReqTrackerArrayListThreadLocal.get().clear();
                }
            }
            if (this.nonSubtype9Recording) {
                smfCookie.writeSmfRecord(info);
            }
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
    }
}

