/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws390.product;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.product.WASProduct;
import com.ibm.websphere.product.xml.product.buildInfo;
import com.ibm.websphere.product.xml.product.product;
import com.ibm.websphere.product.xml.registrar.registrar;
import com.ibm.ws.exception.RuntimeWarning;
import com.ibm.ws.runtime.component.ComponentImpl;
import com.ibm.ws390.product.Registration;
import java.util.Iterator;
import java.util.StringTokenizer;

public final class ProductRegistrationComponentImpl
extends ComponentImpl {
    private static final int REG_IFAUSAGE = 1;
    private static final int REG_IFAEDREG = 2;
    private static final TraceComponent tc = Tr.register(ProductRegistrationComponentImpl.class, "ORB", "com.ibm.ejs.resources.ws390Messages");
    private static Registration registration = null;

    public void start() throws RuntimeWarning {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "start");
        }
        registration = new Registration();
        try {
            registrar r;
            WASProduct product2 = new WASProduct();
            registrar baseRegistrar = null;
            Iterator registrars = product2.getRegistrars();
            while (registrars.hasNext()) {
                r = (registrar)registrars.next();
                if (r.getId().equals("BASE")) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Detected BASE registrar: " + r.getProductName() + "; " + r.getProductId());
                    }
                    if (baseRegistrar == null) {
                        baseRegistrar = r;
                        continue;
                    }
                    Tr.audit(tc, "BBOJ0105", new Object[]{r.getProductName() + "; " + r.getProductId(), baseRegistrar.getProductName() + "; " + baseRegistrar.getProductId()});
                    continue;
                }
                if (!r.getId().equals("ADD")) continue;
                registration.setProductName(r.getProductName());
                registration.setFeatureName(r.getFeatureName());
                registration.setProductID(r.getProductId());
                int regMethod = r.getSmf89Type();
                registration.setRegistrationMethod(regMethod);
                registration.setProductRelease("0");
                registration.setProductVersion("0");
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Registering ADD registrar: " + r.getProductName() + "; " + r.getProductId() + "; " + (regMethod == 1 ? "IFAUSAGE" : "IFAEDREG"));
                }
                registration.register();
            }
            if (baseRegistrar != null) {
                r = baseRegistrar;
                registration.setProductName(r.getProductName());
                registration.setFeatureName(r.getFeatureName());
                registration.setProductID(r.getProductId());
                registration.setRegistrationMethod(r.getSmf89Type());
                registration.setProductRelease("0");
                registration.setProductVersion("0");
            } else {
                product p = null;
                if (product2.productPresent("PME")) {
                    p = product2.getProductById("PME");
                    registration.setProductName("ProcessServerZOS");
                    registration.setFeatureName("ProcessServerZOS");
                    registration.setProductID("5655-N53");
                } else {
                    p = product2.getProductById("ND");
                    if (p == null) {
                        p = product2.getProductById("BASE");
                    }
                    registration.setProductName("WAS FOR Z/OS");
                    registration.setFeatureName("WAS Z/OS");
                    registration.setProductID("5655-N02");
                }
                registration.setRegistrationMethod(1);
                if (p != null) {
                    StringTokenizer st = new StringTokenizer(p.getVersion(), ".");
                    if (st.hasMoreTokens()) {
                        registration.setProductVersion(st.nextToken());
                    } else {
                        registration.setProductVersion("0");
                    }
                    if (st.hasMoreTokens()) {
                        registration.setProductRelease(st.nextToken());
                    } else {
                        registration.setProductRelease("0");
                    }
                    buildInfo b = p.getBuildInfo();
                    if (b != null) {
                        Tr.audit(tc, "BBOJ0096", new Object[]{b.getLevel(), b.getDate()});
                    }
                }
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Product Name", registration.getProductName());
                Tr.debug(tc, "Product Id", registration.getProductID());
            }
            registration.register();
        }
        catch (Throwable t) {
            String msg = "Unable to determine configured product type";
            Tr.event(tc, "Unable to determine configured product type", t);
            throw new RuntimeWarning("Unable to determine configured product type", t);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "start");
        }
    }

    public void stop() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "stop");
        }
        if (registration != null) {
            try {
                registration.deregister();
            }
            catch (Exception e) {
                Tr.debug(tc, "Failed to deregister", e);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "stop");
        }
    }
}

