/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws390.orb;

import com.ibm.CORBA.iiop.CDROutputStream;
import com.ibm.CORBA.iiop.ExtendedIORInfo;
import com.ibm.CORBA.iiop.ExtendedORBInitInfo;
import com.ibm.CORBA.iiop.Profile;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.orb.GlobalORBFactory;
import com.ibm.ws390.orb.ORB;
import com.ibm.ws390.orb.ORBEJSBridge;
import org.omg.CORBA.LocalObject;
import org.omg.PortableInterceptor.IORInfo;
import org.omg.PortableInterceptor.IORInterceptor;
import org.omg.PortableInterceptor.ORBInitInfo;
import org.omg.PortableInterceptor.ORBInitInfoPackage.DuplicateName;
import org.omg.PortableInterceptor.ORBInitializer;

public class WS390IORInterceptor
extends LocalObject
implements ORBInitializer,
IORInterceptor {
    private static final TraceComponent tc = Tr.register(WS390IORInterceptor.class, "ORB", null);
    public static final int TAG_ORB_TYPE = 0;
    public static final int TAG_Native390_IPC = 1229081869;
    public static final int IIOP_Native390ORBType = 1229081856;
    private ORB _orb = null;
    Profile.TaggedComponent[] directTags = null;
    private Profile.TaggedComponent orbTypeTag = null;
    private Profile.TaggedComponent localCommTag = null;

    public void pre_init(ORBInitInfo info) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "pre_init", info);
        }
        WS390IORInterceptor interceptor = new WS390IORInterceptor();
        try {
            ((ExtendedORBInitInfo)info).add_ior_interceptor_first((IORInterceptor)interceptor);
        }
        catch (DuplicateName dne) {
            if (tc.isEventEnabled()) {
                Tr.event(tc, "caught DuplicateName exception", (Object)dne);
            }
            throw new RuntimeException(dne);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "pre_init");
        }
    }

    public void post_init(ORBInitInfo info) {
    }

    public void establish_components(IORInfo info) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "establish_components", info);
        }
        try {
            if (this._orb == null) {
                this.getORB();
            }
            if (this._orb != null) {
                Profile p = ((ExtendedIORInfo)info).getProfile();
                this.createDirectTags();
                this.addTags(p, this.directTags);
            }
        }
        catch (Exception e) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "caught exception in WS390IORInterceptor.establish_components", e);
            }
            throw new RuntimeException(e);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "establish_components");
        }
    }

    private ORB getORB() {
        this._orb = (ORB)GlobalORBFactory.globalORB();
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "getORB", this._orb);
        }
        return this._orb;
    }

    private void addTags(Profile p, Profile.TaggedComponent[] tags) {
        if (tags != null) {
            for (int i = 0; i < tags.length; ++i) {
                p.putTaggedComponent(tags[i].tag(), tags[i].componentData(), true);
            }
        }
    }

    private void createDirectTags() {
        if (this.directTags != null) {
            return;
        }
        if (this.getLocalCommTag() == null) {
            return;
        }
        if (this.getORBTypeTag() == null) {
            return;
        }
        this.directTags = new Profile.TaggedComponent[2];
        this.directTags[0] = this.orbTypeTag;
        this.directTags[1] = this.localCommTag;
    }

    private Profile.TaggedComponent getORBTypeTag() {
        if (this.orbTypeTag != null) {
            return this.orbTypeTag;
        }
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getORBTypeTag");
        }
        CDROutputStream out = ORB.createCDROutputStream();
        out.putEndian();
        out.write_long(1229081856);
        this.orbTypeTag = ORB.createTaggedComponent((int)0, (byte[])out.toByteArray());
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getORBTypeTag", this.orbTypeTag.componentData());
        }
        return this.orbTypeTag;
    }

    private Profile.TaggedComponent getLocalCommTag() {
        byte[] localCommTagData;
        if (this.localCommTag != null) {
            return this.localCommTag;
        }
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getLocalCommTag");
        }
        if ((localCommTagData = ORBEJSBridge.getLocalCommIORTagData()) != null) {
            this.localCommTag = ORB.createTaggedComponent((int)1229081869, (byte[])localCommTagData);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getLocalCommTag", this.localCommTag != null ? this.localCommTag.componentData() : null);
        }
        return this.localCommTag;
    }

    public String name() {
        return ((Object)((Object)this)).getClass().getName();
    }

    public void destroy() {
    }
}

