/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws390.orb;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws390.orb.XmlNotValidException;
import java.util.ArrayList;
import java.util.List;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class SibClassificationParser {
    private static final TraceComponent TC = Tr.register(SibClassificationParser.class, "ORB", null);
    public static final String SCHEMA_VERSION = "1.0";
    private List elements = new ArrayList();
    private boolean gotJmsRa = false;
    private boolean gotDestinationMediation = false;
    private static final SibClassificationParser INSTANCE = new SibClassificationParser();

    private SibClassificationParser() {
    }

    public void parse(Element element) throws XmlNotValidException {
        String methodName = "parse";
        if (TC.isEntryEnabled()) {
            Tr.entry(TC, "parse");
        }
        String type = element.getAttribute("type");
        String version = element.getAttribute("schema_version");
        String defaultTansactionClass = element.getAttribute("default_transaction_class");
        if (TC.isDebugEnabled()) {
            Tr.debug(TC, "parse", new Object[]{"element " + element.getTagName(), "type=" + type, "default_transaction_class=" + defaultTansactionClass, "schema_version=" + version});
        }
        if (!version.equals(SCHEMA_VERSION)) {
            String message = "Unsupported version of SibClassification element (supported version is 1.0)";
            if (TC.isDebugEnabled()) {
                Tr.debug(TC, "Unsupported version of SibClassification element (supported version is 1.0)");
            }
            throw new XmlNotValidException("Unsupported version of SibClassification element (supported version is 1.0)");
        }
        boolean knownType = false;
        if (type.equals("jmsra")) {
            if (this.gotJmsRa) {
                String message = "More than one SibClassification element of type \"" + type + "\" was found";
                if (TC.isDebugEnabled()) {
                    Tr.debug(TC, message);
                }
                throw new XmlNotValidException(message);
            }
            this.gotJmsRa = true;
            knownType = true;
        } else if (type.equals("destinationmediation")) {
            if (this.gotDestinationMediation) {
                String message = "More than one SibClassification element of type \"" + type + "\" was found";
                if (TC.isDebugEnabled()) {
                    Tr.debug(TC, message);
                }
                throw new XmlNotValidException(message);
            }
            this.gotDestinationMediation = true;
            knownType = true;
        }
        if (knownType) {
            SibClassificationParser.validateTransactionClass(defaultTansactionClass);
            NodeList nodes = element.getElementsByTagName("sib_classification_info");
            int count = nodes.getLength();
            for (int i = 0; i < count; ++i) {
                this.validateClassificationInfo((Element)nodes.item(i));
            }
            this.getElements().add(element);
        }
        if (TC.isEntryEnabled()) {
            Tr.exit(TC, "parse");
        }
    }

    private void validateClassificationInfo(Element element) throws XmlNotValidException {
        String methodName = "parseClassificationInfo";
        if (TC.isEntryEnabled()) {
            Tr.entry(TC, "parseClassificationInfo");
        }
        String transactionClass = element.getAttribute("transaction_class");
        String selector = element.getAttribute("selector");
        String bus = element.getAttribute("bus");
        String destination = element.getAttribute("destination");
        String discriminator = element.getAttribute("discriminator");
        if (TC.isDebugEnabled()) {
            Tr.debug(TC, "parseClassificationInfo", new Object[]{"element " + element.getTagName(), "transaction_class=" + transactionClass, "selector=" + selector, "bus=" + bus, "destination=" + destination, "discriminator=" + discriminator, "description=" + element.getAttribute("description")});
        }
        SibClassificationParser.validateTransactionClass(transactionClass);
        if (selector.trim().equals("") && bus.trim().equals("") && destination.trim().equals("") && discriminator.trim().equals("")) {
            String message = "At least one of the attributes selector, bus, destination and discriminator must be specified";
            if (TC.isDebugEnabled()) {
                Tr.debug(TC, "At least one of the attributes selector, bus, destination and discriminator must be specified");
            }
            throw new XmlNotValidException("At least one of the attributes selector, bus, destination and discriminator must be specified");
        }
        if (TC.isEntryEnabled()) {
            Tr.exit(TC, "parseClassificationInfo");
        }
    }

    public void clear() {
        String methodName = "clear";
        if (TC.isEntryEnabled()) {
            Tr.entry(TC, "clear");
        }
        this.elements = new ArrayList();
        this.gotJmsRa = false;
        this.gotDestinationMediation = false;
        if (TC.isEntryEnabled()) {
            Tr.exit(TC, "clear");
        }
    }

    public List getElements() {
        return this.elements;
    }

    public static SibClassificationParser getInstance() {
        return INSTANCE;
    }

    private static void validateTransactionClass(String transactionClass) throws XmlNotValidException {
        if (transactionClass.trim().equals("") || transactionClass.length() > 8) {
            String message = "Transaction class \"" + transactionClass + "\" must not be empty or longer than 8 characters";
            if (TC.isDebugEnabled()) {
                Tr.debug(TC, message);
            }
            throw new XmlNotValidException(message);
        }
    }
}

