/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws390.orb;

import com.ibm.CORBA.iiop.ExtendedServerRequestInfo;
import com.ibm.CORBA.iiop.ORB;
import com.ibm.CORBA.iiop.ServiceContext;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws390.orb.BaseCDRFragmentHandler;
import com.ibm.ws390.orb.GIOPFragmentCppUtilities;
import com.ibm.ws390.orb.ResponseHandlerImpl;
import com.ibm.ws390.orb.WS390InterceptorManager;
import com.ibm.ws390.orb.parameters.ORBEJSBridgeInvoke;
import com.ibm.ws390.ziop.ServiceContextManager;
import com.ibm.wsspi.buffermgmt.WsByteBuffer;
import com.ibm.wsspi.buffermgmt.WsByteBufferUtils;
import java.io.IOException;
import java.nio.ByteBuffer;
import org.omg.PortableInterceptor.ForwardRequest;

public class OutboundResponseCDRFragmentHandler
extends BaseCDRFragmentHandler {
    private static final TraceComponent tc = Tr.register(OutboundResponseCDRFragmentHandler.class, "ORB", "com.ibm.ejs.resources.ws390Messages");
    public ORBEJSBridgeInvoke inv_params = null;
    private ExtendedServerRequestInfo sri;
    private ResponseHandlerImpl rh;

    public OutboundResponseCDRFragmentHandler() {
        this.inv_params = null;
        this.sri = null;
        this.rh = null;
    }

    public OutboundResponseCDRFragmentHandler(ORBEJSBridgeInvoke inv, ORB orb) {
        super(orb, inv.endian, new WsByteBuffer[]{wsByteBufferManager.wrap(inv.params)});
        this.inv_params = inv;
        this.sri = null;
        this.rh = null;
    }

    public void setSRIInfo(ExtendedServerRequestInfo sri, ResponseHandlerImpl rh) {
        this.sri = sri;
        this.rh = rh;
    }

    public void flush(WsByteBuffer[] data) throws IOException {
        IOException ioe;
        int curPos;
        byte[] tempBytes;
        int i;
        int rc = -1;
        WsByteBuffer outboundMessage = null;
        ByteBuffer scDataOutbound = null;
        WsByteBuffer scDataManagedBuffer = null;
        String methodName = "flush";
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "flush");
        }
        if (tc.isDebugEnabled()) {
            for (i = 0; i < data.length; ++i) {
                tempBytes = new byte[data[i].remaining()];
                curPos = data[i].position();
                data[i].get(tempBytes);
                Tr.debug(tc, "flush fragment buffer[" + i + "]: ", tempBytes);
                data[i].position(curPos);
            }
        }
        try {
            if (!this.firstWriteComplete) {
                this.firstWriteComplete = true;
                data[0].position(data[0].position() + 8);
                if (tc.isDebugEnabled()) {
                    for (i = 0; i < data.length; ++i) {
                        tempBytes = new byte[data[i].remaining()];
                        curPos = data[i].position();
                        data[i].get(tempBytes);
                        Tr.debug(tc, "flush AFTER 8 BYTE ADJUST fragment buffer[" + i + "]: ", tempBytes);
                        data[i].position(curPos);
                    }
                }
                try {
                    WS390InterceptorManager.interceptOutboundResponse(this.orb, this.sri, null, this.rh);
                }
                catch (ForwardRequest fr) {
                    ioe = new IOException("Outbound response fragment flush failed running the WS390 interceptor filters due to a ForwardRequest exception");
                    ioe.initCause(fr);
                    throw ioe;
                }
                byte[] scBytes = ServiceContextManager.marshalServiceContextData((ServiceContext[])this.sri.getReplyServiceContextList(), (boolean)this.endian);
                if (scBytes != null) {
                    scDataManagedBuffer = this.getBuffer(scBytes.length);
                    scDataManagedBuffer.put(scBytes);
                    scDataOutbound = scDataManagedBuffer.getWrappedByteBuffer();
                }
            }
            if (data.length == 1) {
                outboundMessage = data[0];
            } else {
                outboundMessage = this.getBuffer(WsByteBufferUtils.lengthOf(data));
                outboundMessage.put(data);
                outboundMessage.rewind();
            }
            rc = GIOPFragmentCppUtilities.flushResponseFragment(scDataOutbound, outboundMessage.getWrappedByteBuffer().slice(), this.inv_params.orbrPtr, this.inv_params.reqPtr);
        }
        catch (Throwable t) {
            ioe = new IOException("Native GIOP outbound response flush failed");
            ioe.initCause(t);
            throw ioe;
        }
        finally {
            WsByteBufferUtils.releaseBufferArray(data);
            if (data.length > 1) {
                outboundMessage.release();
            }
            if (scDataManagedBuffer != null) {
                scDataManagedBuffer.release();
            }
        }
        if (rc < 0) {
            throw new IOException("Native GIOP outbound response flush failed");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "flush");
        }
    }
}

