/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws390.orb;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.util.JVMListenerInterface;
import java.util.LinkedList;

public class JVMListenerNotifier {
    private static final char[] charValues = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    private static final TraceComponent tc = Tr.register(JVMListenerNotifier.class, "ORB", "com.ibm.ejs.resources.ws390Messages");
    private static LinkedList Listenerlist = new LinkedList();

    private static native void setListenerHandle();

    public static synchronized void registerListener(JVMListenerInterface listener) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "JVMListenerNotifier::registerLister(..)");
        }
        Listenerlist.add(listener);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "JVMListenerNotifier::registerLister(..)");
        }
    }

    public static void servantTerminated(byte[] stoken) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "JVMListenerNotifier::servantTerminated", stoken);
        }
        String stringStoken = null;
        if (stoken != null && stoken.length > 0) {
            StringBuffer stokenBuf = new StringBuffer();
            for (int i = 0; i < stoken.length; ++i) {
                int hoNibble = (stoken[i] & 0xF0) / 16;
                int loNibble = stoken[i] & 0xF;
                stokenBuf.append(charValues[hoNibble]);
                stokenBuf.append(charValues[loNibble]);
            }
            stringStoken = stokenBuf.toString();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "stringStoken", stringStoken);
            }
            for (JVMListenerInterface CurrentListener : Listenerlist) {
                try {
                    CurrentListener.servantTerminated(stringStoken);
                }
                catch (Exception ex) {
                    Tr.error(tc, "Unable to invoke listener", ex);
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "JVMListenerNotifier::servantTerminated");
        }
    }

    static {
        String CurrentBitmode = System.getProperty("com.ibm.vm.bitmode");
        int bitmode = Integer.parseInt(CurrentBitmode);
        if (bitmode == 64) {
            System.loadLibrary("bbgojmx");
        } else {
            System.loadLibrary("bboojmx");
        }
        JVMListenerNotifier.setListenerHandle();
    }
}

