/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws390.orb;

import com.ibm.CORBA.iiop.ORB;
import com.ibm.CORBA.nio.BufferFactory;
import com.ibm.CORBA.nio.Sink;
import com.ibm.CORBA.nio.Source;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.buffermgmt.impl.WsByteBufferPoolManagerImpl;
import com.ibm.ws.util.PlatformHelper;
import com.ibm.ws.util.PlatformHelperFactory;
import com.ibm.wsspi.buffermgmt.WsByteBuffer;
import java.io.IOException;

public abstract class BaseCDRFragmentHandler
implements BufferFactory,
Source,
Sink {
    private static final TraceComponent tc;
    protected static WsByteBufferPoolManagerImpl wsByteBufferManager;
    protected static PlatformHelper ph;
    protected WsByteBuffer[] inputData;
    protected boolean firstWriteComplete;
    protected ORB orb;
    protected boolean endian;

    public BaseCDRFragmentHandler() {
        this.firstWriteComplete = false;
        this.inputData = null;
        this.orb = null;
        this.endian = false;
    }

    public BaseCDRFragmentHandler(ORB orb) {
        this.firstWriteComplete = false;
        this.inputData = null;
        this.orb = orb;
    }

    public BaseCDRFragmentHandler(ORB orb, boolean endian) {
        this.firstWriteComplete = false;
        this.inputData = null;
        this.orb = orb;
        this.endian = endian;
    }

    public BaseCDRFragmentHandler(ORB orb, boolean endian, WsByteBuffer[] input) {
        this.inputData = input;
        this.firstWriteComplete = false;
        this.orb = orb;
        this.endian = endian;
    }

    public WsByteBuffer getBuffer(int size) {
        String methodName = "getBuffer";
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "getBuffer size=" + size);
        }
        return wsByteBufferManager.allocateDirect(size);
    }

    public WsByteBuffer[] moreData() {
        String methodName = "moreData";
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "moreData");
        }
        WsByteBuffer[] currentData = null;
        if (this.inputData != null) {
            currentData = this.inputData;
            this.inputData = null;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "moreData");
        }
        return currentData;
    }

    public abstract void flush(WsByteBuffer[] var1) throws IOException;

    public boolean isFirstWriteComplete() {
        return this.firstWriteComplete;
    }

    static {
        ph = null;
        wsByteBufferManager = (WsByteBufferPoolManagerImpl)WsByteBufferPoolManagerImpl.getRef();
        ph = PlatformHelperFactory.getPlatformHelper();
        tc = Tr.register(BaseCDRFragmentHandler.class, "ORB", "com.ibm.ejs.resources.ws390Messages");
    }
}

