/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws390.jfap;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.AdminService;
import com.ibm.websphere.management.AdminServiceFactory;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.management.ServantMBeanStatus;
import com.ibm.ws.runtime.component.ComponentImpl;
import com.ibm.ws.tcpchannelproxy.jfap.Identifier;
import com.ibm.ws.tcpchannelproxy.jfap.TCPProxyBridgeServicesImpl;
import com.ibm.ws.util.PlatformHelper;
import com.ibm.ws.util.PlatformHelperFactory;
import javax.management.Notification;
import javax.management.NotificationFilterSupport;
import javax.management.NotificationListener;
import javax.management.ObjectName;

public class JFAPProxyComponentImpl
extends ComponentImpl
implements NotificationListener {
    private static final TraceComponent tc = Tr.register(JFAPProxyComponentImpl.class, "JFAP", null);
    private Identifier localIdentifier;

    public void start() {
        PlatformHelper platformHelper = PlatformHelperFactory.getPlatformHelper();
        this.localIdentifier = new Identifier(platformHelper.getStoken());
        this.registerNotificationListener();
    }

    private void registerNotificationListener() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "registerNotificationListener");
        }
        try {
            AdminService adminService = AdminServiceFactory.getAdminService();
            String nodeName = adminService.getNodeName();
            String processName = adminService.getProcessName();
            String notificationPattern = adminService.getDomainName();
            if (notificationPattern == null) {
                notificationPattern = "*";
            }
            notificationPattern = notificationPattern + ":name=ControlAdminService,node=" + nodeName + ",process=" + processName + ",*";
            ObjectName on = new ObjectName(notificationPattern);
            NotificationFilterSupport filter = new NotificationFilterSupport();
            filter.enableType("websphere.ws390.servant.started");
            adminService.addNotificationListenerExtended(on, this, filter, this);
        }
        catch (Throwable t) {
            FFDCFilter.processException(t, "JFAPProxyComponentImpl.registerNotificationListener", "101", this);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "registerNotificationListener");
        }
    }

    public void handleNotification(Notification notification, Object handback) {
        ServantMBeanStatus status;
        String stoken;
        Identifier servantIdentifier;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "handleNotification", notification);
        }
        String type = notification.getType();
        Object userData = notification.getUserData();
        if ("websphere.ws390.servant.started".equals(type) && userData instanceof ServantMBeanStatus && this.localIdentifier.equals((Object)(servantIdentifier = new Identifier(stoken = (status = (ServantMBeanStatus)userData).getServantStoken())))) {
            TCPProxyBridgeServicesImpl.serverInitialized();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "handleNotification");
        }
    }
}

