/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws390.container.resref;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws390.container.resref.BaseResourceFactory;
import com.ibm.ws390.container.resref.ResourceInfo;
import com.ibm.ws390.container.resref.ResourceRefAddr;
import java.lang.reflect.Method;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.RefAddr;
import javax.naming.Reference;
import javax.naming.spi.ObjectFactory;

public class MQJMSAdminObjectFactory
implements ObjectFactory {
    static TraceComponent tc = Tr.register(MQJMSAdminObjectFactory.class);
    private static Class JMSCClass = null;
    private static final String JMSCClassName = "com.ibm.mq.jms.JMSC";
    private static final String RRSQCFClassName = "com.ibm.mq.jms.MQRRSQueueConnectionFactory";
    private static final String RRSTCFClassName = "com.ibm.mq.jms.MQRRSTopicConnectionFactory";
    private static final String QCFClassName = "com.ibm.mq.jms.MQQueueConnectionFactory";
    private static final String TCFClassName = "com.ibm.mq.jms.MQTopicConnectionFactory";
    private static final String QueueClassName = "com.ibm.mq.jms.MQQueue";
    private static final String TopicClassName = "com.ibm.mq.jms.MQTopic";

    public Object getObjectInstance(Object p1, Name p2, Context p3, Hashtable p4) throws Exception {
        String className;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getObjectInstance", (Reference)p1);
        }
        Reference ref = (Reference)p1;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getObjectInstance");
        }
        if ((className = ref.getClassName()).equals(RRSQCFClassName)) {
            return this.getMQQueueConnectionFactory(ref);
        }
        if (className.equals(RRSTCFClassName)) {
            return this.getMQTopicConnectionFactory(ref);
        }
        if (className.equals(QCFClassName)) {
            return this.getMQQueueConnectionFactory(ref);
        }
        if (className.equals(TCFClassName)) {
            return this.getMQTopicConnectionFactory(ref);
        }
        if (className.equals(QueueClassName)) {
            return this.getMQDestination(ref);
        }
        if (className.equals(TopicClassName)) {
            return this.getMQDestination(ref);
        }
        return null;
    }

    private Object getMQQueueConnectionFactory(Reference ref) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getMQQueueConnectionFactory");
        }
        Enumeration<RefAddr> addrLst = ref.getAll();
        ResourceRefAddr refaddr = null;
        Object content = null;
        Class<?> qcfClass = Class.forName(ref.getClassName());
        Object qcfInstance = qcfClass.newInstance();
        while (addrLst.hasMoreElements()) {
            refaddr = (ResourceRefAddr)addrLst.nextElement();
            BaseResourceFactory.driveSetter(refaddr, qcfInstance);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getMQQueueConnectionFactory", qcfInstance);
        }
        return qcfInstance;
    }

    private Object getMQTopicConnectionFactory(Reference ref) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getMQTopicConnectionFactory");
        }
        Enumeration<RefAddr> addrLst = ref.getAll();
        ResourceRefAddr refaddr = null;
        Object content = null;
        Class<?> tcfClass = Class.forName(ref.getClassName());
        Object tcfInstance = tcfClass.newInstance();
        while (addrLst.hasMoreElements()) {
            refaddr = (ResourceRefAddr)addrLst.nextElement();
            BaseResourceFactory.driveSetter(refaddr, tcfInstance);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getMQTopicConnectionFactory", tcfInstance);
        }
        return tcfInstance;
    }

    private Object getMQDestination(Reference ref) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getMQDestination");
        }
        Enumeration<RefAddr> addrLst = ref.getAll();
        ResourceRefAddr refaddr = null;
        ResourceInfo content = null;
        String param = null;
        Class<?> destClass = Class.forName(ref.getClassName());
        Object destInstance = destClass.newInstance();
        while (addrLst.hasMoreElements()) {
            Object[] args;
            Class[] parms;
            int setterValue;
            refaddr = (ResourceRefAddr)addrLst.nextElement();
            String type = refaddr.getType();
            if (type.equals("MessageRetention")) {
                content = (ResourceInfo)refaddr.getContent();
                param = content.getParam();
                if (param == null) continue;
                setterValue = param.equalsIgnoreCase("Yes") ? this.findJMSConstant("MQJMS_MRET_YES") : this.findJMSConstant("MQJMS_MRET_NO");
                parms = new Class[]{Integer.TYPE};
                args = new Object[]{new Integer(setterValue)};
                Method mretMethod = destClass.getMethod("setMessageRetention", parms);
                mretMethod.invoke(destInstance, args);
                continue;
            }
            if (type.equals("CCSID")) {
                content = (ResourceInfo)refaddr.getContent();
                param = content.getParam();
                if (param == null) continue;
                setterValue = this.getCCSID(param);
                parms = new Class[]{Integer.TYPE};
                args = new Object[]{new Integer(setterValue)};
                Method ccsidMethod = destClass.getMethod("setCCSID", parms);
                ccsidMethod.invoke(destInstance, args);
                continue;
            }
            if (type.equals("Expiry")) {
                content = (ResourceInfo)refaddr.getContent();
                param = content.getParam();
                if (param == null) continue;
                setterValue = param.equals("APP") || param.equals("Application") ? this.findJMSConstant("MQJMS_EXP_APP") : (param.equals("UNLIM") || param.equals("Unlimited") ? this.findJMSConstant("MQJMS_EXP_UNLIMITED") : Integer.decode(content.getParam()).intValue());
                parms = new Class[]{Long.TYPE};
                args = new Object[]{new Integer(setterValue)};
                Method expMethod = destClass.getMethod("setExpiry", parms);
                expMethod.invoke(destInstance, args);
                continue;
            }
            if (type.equals("Priority")) {
                content = (ResourceInfo)refaddr.getContent();
                param = content.getParam();
                if (param == null) continue;
                setterValue = param.equals("Application") ? this.findJMSConstant("MQJMS_PRI_APP") : (param.equals("Queue Default") ? this.findJMSConstant("MQJMS_PRI_QDEF") : Integer.decode(content.getParam()).intValue());
                parms = new Class[]{Integer.TYPE};
                args = new Object[]{new Integer(setterValue)};
                Method priMethod = destClass.getMethod("setPriority", parms);
                priMethod.invoke(destInstance, args);
                continue;
            }
            if (type.equals("Persistence")) {
                setterValue = -559038737;
                content = (ResourceInfo)refaddr.getContent();
                param = content.getParam();
                if (param == null) continue;
                if (param.equals("Application")) {
                    setterValue = this.findJMSConstant("MQJMS_PER_APP");
                } else if (param.equals("Queue Default")) {
                    setterValue = this.findJMSConstant("MQJMS_PER_QDEF");
                } else if (param.equals("Persistent")) {
                    setterValue = this.findJMSConstant("MQJMS_PER_PER");
                } else if (param.equals("Non-Persistent")) {
                    setterValue = this.findJMSConstant("MQJMS_PER_NON");
                }
                parms = new Class[]{Integer.TYPE};
                args = new Object[]{new Integer(setterValue)};
                Method perMethod = destClass.getMethod("setPersistence", parms);
                perMethod.invoke(destInstance, args);
                continue;
            }
            if (type.equals("TargetClient")) {
                setterValue = -559038737;
                content = (ResourceInfo)refaddr.getContent();
                param = content.getParam();
                if (param == null) continue;
                if (param.equals("JMS")) {
                    setterValue = this.findJMSConstant("MQJMS_CLIENT_JMS_COMPLIANT");
                } else if (param.equals("MQ")) {
                    setterValue = this.findJMSConstant("MQJMS_CLIENT_NONJMS_MQ");
                }
                parms = new Class[]{Integer.TYPE};
                args = new Object[]{new Integer(setterValue)};
                Method tgtMethod = destClass.getMethod("setTargetClient", parms);
                tgtMethod.invoke(destInstance, args);
                continue;
            }
            if (type.equals("Encoding")) {
                content = (ResourceInfo)refaddr.getContent();
                param = content.getParam();
                if (param == null) continue;
                setterValue = param.equals("Native") ? this.findJMSConstant("MQJMS_ENCODING_NATIVE") : this.getEncodingValue(param);
                parms = new Class[]{Integer.TYPE};
                args = new Object[]{new Integer(setterValue)};
                Method encMethod = destClass.getMethod("setEncoding", parms);
                encMethod.invoke(destInstance, args);
                continue;
            }
            BaseResourceFactory.driveSetter(refaddr, destInstance);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getMQDestination", destInstance);
        }
        return destInstance;
    }

    private int findJMSConstant(String fieldname) throws Exception {
        if (JMSCClass == null) {
            JMSCClass = Class.forName(JMSCClassName);
        }
        return JMSCClass.getField(fieldname).getInt(null);
    }

    private int getEncodingValue(String param) throws Exception {
        int setterValue;
        if (param.equals("Native")) {
            setterValue = this.findJMSConstant("MQJMS_ENCODING_NATIVE");
        } else {
            int ienc = 0;
            int denc = 0;
            int fenc = 0;
            ienc = param.charAt(0) == 'N' ? this.findJMSConstant("MQJMS_ENCODING_INTEGER_NORMAL") : this.findJMSConstant("MQJMS_ENCODING_INTEGER_REVERSED");
            denc = param.charAt(1) == 'N' ? this.findJMSConstant("MQJMS_ENCODING_DECIMAL_NORMAL") : this.findJMSConstant("MQJMS_ENCODING_DECIMAL_REVERSED");
            fenc = param.charAt(2) == 'N' ? this.findJMSConstant("MQJMS_ENCODING_FLOAT_IEEE_NORMAL") : (param.charAt(2) == 'R' ? this.findJMSConstant("MQJMS_ENCODING_FLOAT_IEEE_REVERSED") : this.findJMSConstant("MQJMS_ENCODING_FLOAT_S390"));
            setterValue = ienc | denc | fenc;
        }
        return setterValue;
    }

    private int getCCSID(String characterSet) throws Exception {
        block29: {
            block28: {
                if (characterSet.equals("UTF-8")) {
                    return 1208;
                }
                if (characterSet.startsWith("ibm")) {
                    switch (characterSet.length()) {
                        case 7: {
                            return Integer.decode(characterSet.substring(3, 6));
                        }
                        case 8: {
                            return Integer.decode(characterSet.substring(3, 7));
                        }
                    }
                    return Integer.decode(characterSet.substring(3, 5));
                }
                if (!characterSet.startsWith("Windows")) break block28;
                switch (characterSet.length()) {
                    case 13: {
                        if (characterSet.equals("Windows Greek")) {
                            return 1253;
                        }
                        break block29;
                    }
                    case 14: {
                        if (characterSet.equals("Windows Hebrew")) {
                            return 1255;
                        }
                        if (characterSet.equals("Windows Arabic")) {
                            return 1256;
                        }
                        if (characterSet.equals("Windows Baltic")) {
                            return 1257;
                        }
                        break block29;
                    }
                    case 15: {
                        if (characterSet.equals("Windows Latin 1")) {
                            return 1252;
                        }
                        if (characterSet.equals("Windows Latin 2")) {
                            return 1250;
                        }
                        if (characterSet.equals("Windows Turkish")) {
                            return 1254;
                        }
                        break block29;
                    }
                    case 16: {
                        if (characterSet.equals("Windows Cyrillic")) {
                            return 1251;
                        }
                        if (characterSet.equals("Windows Vietnamese")) {
                            return 1258;
                        }
                        break block29;
                    }
                }
                break block29;
            }
            if (characterSet.startsWith("iso-8859")) {
                if (characterSet.equals("iso-8859-6 / arabic / ibm1089")) {
                    return 1089;
                }
                int ibmOffset = characterSet.indexOf("/ ibm");
                String ibmString = characterSet.substring(ibmOffset + 5, ibmOffset + 7);
                return Integer.decode(ibmString);
            }
            if (characterSet.equals("JIS")) {
                return 2022;
            }
            if (characterSet.equals("EUCJIS")) {
                return 954;
            }
            if (characterSet.equals("Unicode")) {
                return 1200;
            }
            if (characterSet.equals("PC Japanese")) {
                return 932;
            }
            if (characterSet.equals("ksc-5601 Korean")) {
                return 5601;
            }
            throw new Exception("Bad character set");
        }
        return -559038737;
    }
}

