/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.xcf.groupservices;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.dcs.common.exception.DCSRuntimeException;
import com.ibm.ws.dcs.common.liveness.JoinEventListener;
import com.ibm.ws.dcs.common.liveness.LeaveEventListener;
import com.ibm.ws.dcs.common.liveness.LivenessPlugin;
import com.ibm.ws.dcs.vri.common.Utils;
import com.ibm.ws.dcs.vri.common.util.DCSTraceContext;
import com.ibm.ws.xcf.groupservices.AnswerRecord;
import com.ibm.ws.xcf.groupservices.DiscoveryPluginLogger;
import com.ibm.ws.xcf.groupservices.HexLong;
import com.ibm.ws.xcf.groupservices.LDMemberInfoListener;
import com.ibm.ws.xcf.groupservices.LivenessServiceXCF;
import com.ibm.ws.xcf.groupservices.NameConverterZos;
import com.ibm.ws.xcf.groupservices.PendingAction;
import java.nio.ByteBuffer;
import java.util.Map;
import java.util.Vector;

public class LivenessPluginZoS
implements LivenessPlugin,
LDMemberInfoListener,
DCSTraceContext {
    private static LivenessServiceXCF xcfSingleton = null;
    private LeaveEventListener leaveListener = null;
    private JoinEventListener joinListener = null;
    private NameConverterZos nameConverter = null;
    private Vector<PendingAction> pendingActions = new Vector();
    String myName;
    String groupName;
    String shortGroupName;
    String shortMyName;
    ByteBuffer memberToken;
    long timestamp = 0L;
    final TraceComponent TC = Tr.register(this.getClass(), "DCS", "com.ibm.ws.dcs.common.event.nls.dcs");

    protected LivenessPluginZoS(Map config2) {
        this.myName = (String)config2.get("LP_THIS_MEMBER_NAME");
        this.groupName = (String)config2.get("LP_GROUP_NAME");
        this.nameConverter = new NameConverterZos(this.groupName);
        this.shortGroupName = this.nameConverter.getShortGroupName(this.groupName);
        String dispCoreGroupName = (String)config2.get("LP_CORE_GROUP_NAME");
        if (dispCoreGroupName == null || dispCoreGroupName.equals("")) {
            dispCoreGroupName = new String(this.groupName);
        }
        DiscoveryPluginLogger.dcsInternalInfo((DCSTraceContext)this, "XCFGroupName", "XCF name for Group " + dispCoreGroupName + " is " + this.shortGroupName);
        try {
            xcfSingleton = LivenessServiceXCF.getInstance();
        }
        catch (UnsatisfiedLinkError e) {
            DiscoveryPluginLogger.dcsInternalError(this, "constructor()", e);
        }
        catch (SecurityException e) {
            DiscoveryPluginLogger.dcsInternalError(this, "constructor()", e);
        }
        catch (Exception e) {
            DiscoveryPluginLogger.dcsInternalError(this, "constructor()", e);
        }
        String params = " groupName= " + this.groupName + " myName= " + this.myName + " shortGroupName= " + this.shortGroupName;
        DiscoveryPluginLogger.dcsLogLDSEvent(this, this.getState(), "Init", params);
    }

    private String getState() {
        return " CHK=none";
    }

    public void start() {
        String[] queryLive;
        DiscoveryPluginLogger.dcsLogLDSEvent(this, this.getState(), "start()", null);
        long rc = xcfSingleton.join(this.shortGroupName, this);
        if (rc != 0L) {
            DiscoveryPluginLogger.dcsInternalError(this, "start()", (Throwable)new DCSRuntimeException("failed to join XCF code=" + HexLong.print(rc)));
        }
        this.shortMyName = xcfSingleton.getshortMyName();
        DiscoveryPluginLogger.dcsInternalInfo((DCSTraceContext)this, "XCFMemberName", "XCF name for Member " + this.myName + " is " + this.shortMyName);
        this.nameConverter.addJoinedMemberName(this.groupName, this.shortMyName, this.myName);
        DiscoveryPluginLogger.dcsLogLDSEvent(this, this.getState(), "start()", "Added to group2MemberMap " + this.groupName + ": " + this.shortMyName + "=" + this.myName);
        this.check();
        AnswerRecord queryAnswer = this.queryLiveness();
        boolean foundMyself = false;
        if (queryAnswer != null && (queryLive = queryAnswer.names) != null) {
            for (int i = 0; i < queryLive.length; ++i) {
                if (!foundMyself && this.shortMyName.equals(queryLive[i])) {
                    foundMyself = true;
                    continue;
                }
                if (this.joinListener != null) {
                    if (queryLive[i] == null || !LivenessServiceXCF.isActive(queryAnswer.status[i])) continue;
                    String otherMbrName = this.nameConverter.short2longName(this.groupName, queryLive[i]);
                    if (otherMbrName != "") {
                        this.joinListener.memberJoined(otherMbrName, this.timestamp++);
                        continue;
                    }
                    PendingAction pendAction = new PendingAction(queryLive[i], 1, this.timestamp++, "", 0);
                    this.executePendingActions(pendAction, queryLive[i], "", 0L);
                    continue;
                }
                DiscoveryPluginLogger.dcsWarning((DCSTraceContext)this, "start()", (Exception)new DCSRuntimeException("Null joinListener"));
            }
        }
        String params = " groupName= " + this.groupName + " myName= " + this.myName + " shortGroupName= " + this.shortGroupName + " shortMyName= " + this.shortMyName + " rc= " + HexLong.print(rc) + " numQueryLive= " + queryAnswer.names.length;
        DiscoveryPluginLogger.dcsLogLDSEvent(this, this.getState(), "start()", params);
        xcfSingleton.sendNamePairsMsgToOthers(this.shortGroupName, this.shortMyName, this.myName, true);
        String parmMsg = "Name pair message sent to other members: Y;" + this.shortGroupName + ";" + this.shortMyName + ";" + this.myName;
        DiscoveryPluginLogger.dcsLogLDSEvent(this, this.getState(), "start()", parmMsg);
    }

    public void terminate(boolean grace) {
        long rc = xcfSingleton.leave(grace, this.shortGroupName, this.shortMyName, this);
        if (rc != 0L) {
            DiscoveryPluginLogger.dcsWarning((DCSTraceContext)this, "terminate()", (Exception)new DCSRuntimeException("failed to leave XCF code=" + HexLong.print(rc)));
        }
        DiscoveryPluginLogger.dcsLogLDSEvent(this, this.getState(), "terminate()", "rc= " + HexLong.print(rc));
    }

    public final boolean check() {
        return true;
    }

    public void notifyMemberInfo(String shortGroupName, String shortMemberName, long status, long timestamp) {
        HexLong prtStatus = new HexLong(status);
        if (!this.shortGroupName.equals(shortGroupName)) {
            DiscoveryPluginLogger.dcsWarning((DCSTraceContext)this, "start()", (Exception)new DCSRuntimeException("Wrong shortGroupName= " + shortGroupName + ", " + this.shortGroupName));
        }
        int state = LivenessServiceXCF.getShortStatus(status);
        DiscoveryPluginLogger.dcsLogLDSEvent(this, this.getState(), "notifyMemberInfo()-Received", "shortMemberName=" + shortMemberName + " status=" + prtStatus + " state=" + state);
        String memberName = this.nameConverter.short2longName(this.groupName, shortMemberName);
        switch (state) {
            case 0: {
                if (this.joinListener != null) {
                    if (memberName.equals("")) {
                        PendingAction pendAction = new PendingAction(shortMemberName, 1, timestamp, "", 0);
                        this.executePendingActions(pendAction, shortMemberName, "", 0L);
                        DiscoveryPluginLogger.dcsLogLDSEvent(this, this.getState(), "notifyMemberInfo()-ALIVE is PENDING", "name= " + shortMemberName + " status=" + prtStatus + " state=" + state);
                        break;
                    }
                    this.joinListener.memberJoined(memberName, timestamp);
                    DiscoveryPluginLogger.dcsLogLDSEvent(this, this.getState(), "notifyMemberInfo()-ALIVE", "name= " + memberName + " status=" + prtStatus + " state=" + state);
                    break;
                }
                DiscoveryPluginLogger.dcsWarning((DCSTraceContext)this, "notifyMemberInfo()", (Exception)new DCSRuntimeException("Null joinListener"));
                break;
            }
            case 1: {
                int rc = LivenessServiceXCF.getRC(status);
                int reasonCode = LivenessServiceXCF.getReasonCode(status);
                String reason = "ReasonCode= " + reasonCode;
                if (this.leaveListener != null) {
                    if (memberName.equals("")) {
                        PendingAction pendAction = new PendingAction(shortMemberName, 2, timestamp, reason, rc);
                        this.executePendingActions(pendAction, shortMemberName, "", 0L);
                        DiscoveryPluginLogger.dcsLogLDSEvent(this, this.getState(), "notifyMemberInfo()-DEAD is PENDING", "name= " + shortMemberName + " status=" + prtStatus + " state=" + state);
                        break;
                    }
                    this.leaveListener.memberLeft(memberName, timestamp, reason, (long)rc);
                    DiscoveryPluginLogger.dcsLogLDSEvent(this, this.getState(), "notifyMemberInfo()-DEAD", "name= " + memberName + " status=" + prtStatus + " state=" + state);
                    break;
                }
                DiscoveryPluginLogger.dcsWarning((DCSTraceContext)this, "notifyMemberInfo()", (Exception)new DCSRuntimeException("Null leaveListener"));
                break;
            }
            case 2: {
                PendingAction pendAction;
                int rc1 = LivenessServiceXCF.getRC(status);
                int reasonCode1 = LivenessServiceXCF.getReasonCode(status);
                String reason1 = "ReasonCode= alive dead alive" + reasonCode1;
                if (this.leaveListener != null) {
                    if (memberName.equals("")) {
                        pendAction = new PendingAction(shortMemberName, 2, timestamp, reason1, rc1);
                        this.executePendingActions(pendAction, shortMemberName, "", 0L);
                    } else {
                        this.leaveListener.memberLeft(memberName, timestamp, reason1, (long)rc1);
                    }
                } else {
                    DiscoveryPluginLogger.dcsWarning((DCSTraceContext)this, "notifyMemberInfo()", (Exception)new DCSRuntimeException("Null leaveListener"));
                }
                if (this.joinListener != null) {
                    if (memberName.equals("")) {
                        pendAction = new PendingAction(shortMemberName, 1, timestamp, "", 0);
                        this.executePendingActions(pendAction, shortMemberName, "", 0L);
                        DiscoveryPluginLogger.dcsLogLDSEvent(this, this.getState(), "notifyMemberInfo()-ALIVEALIVE is PENDING", "name= " + shortMemberName + " status=" + prtStatus + " state=" + state);
                        break;
                    }
                    this.joinListener.memberJoined(memberName, timestamp);
                    DiscoveryPluginLogger.dcsLogLDSEvent(this, this.getState(), "notifyMemberInfo()-ALIVEALIVE", "name= " + memberName + " status=" + prtStatus + " state=" + state);
                    break;
                }
                DiscoveryPluginLogger.dcsWarning((DCSTraceContext)this, "notifyMemberInfo()", (Exception)new DCSRuntimeException("Null joinListener"));
                break;
            }
            default: {
                if (memberName.equals("")) {
                    DiscoveryPluginLogger.dcsLogLDSEvent(this, this.getState(), "notifyMemberInfo()-UNKNOWN", "shortName= " + shortMemberName + " status=" + prtStatus + " state=" + state);
                    break;
                }
                DiscoveryPluginLogger.dcsLogLDSEvent(this, this.getState(), "notifyMemberInfo()-UNKNOWN", "name= " + memberName + " status=" + prtStatus + " state=" + state);
            }
        }
    }

    public void notifyMessage(String shortGroupName, String shortMemberName, String longMemberName, boolean reciprocate, long msgOriginatorToken, long msgNumber) {
        DiscoveryPluginLogger.dcsLogLDSEvent(this, this.getState(), "notifyMessage()-Received", " shortGroupName=" + shortGroupName + " shortMemberName=" + shortMemberName + " longMemberName=" + longMemberName + " msgOriginatorToken=" + msgOriginatorToken + " reciprocate=" + reciprocate);
        if (!this.shortGroupName.equals(shortGroupName)) {
            DiscoveryPluginLogger.dcsWarning((DCSTraceContext)this, "notifyMessage()", (Exception)new DCSRuntimeException("Wrong shortGroupName= " + shortGroupName + ", " + this.shortGroupName));
        }
        String groupName = this.nameConverter.getLongGroupName(shortGroupName);
        DiscoveryPluginLogger.dcsLogLDSEvent(this, this.getState(), "notifyMessage()-Processing", " longGroupName=" + groupName);
        if (groupName.equals("")) {
            DiscoveryPluginLogger.dcsWarning((DCSTraceContext)this, "notifyMessage()", (Exception)new DCSRuntimeException("Long name not found for short group name " + shortGroupName));
        } else {
            this.nameConverter.addJoinedMemberName(groupName, shortMemberName, longMemberName);
            this.executePendingActions(null, shortMemberName, longMemberName, msgNumber);
        }
        if (reciprocate) {
            DiscoveryPluginLogger.dcsLogLDSEvent(this, this.getState(), "notifyMessage()-sendNamePairsMsgBack", " shortGroupName=" + this.shortGroupName + " shortMyName=" + this.shortMyName + " myName" + this.myName);
            xcfSingleton.sendNamePairsMsgBack(msgOriginatorToken, this.shortGroupName, this.shortMyName, this.myName);
        }
    }

    public boolean isMemberAlive(String longMemberName) {
        String[] queryLive;
        String shortMemberName = this.nameConverter.getShortMemberName(this.groupName, longMemberName);
        if (shortMemberName == null || shortMemberName.equals("")) {
            return false;
        }
        AnswerRecord queryAnswer = this.queryLiveness();
        if (queryAnswer != null && (queryLive = queryAnswer.names) != null) {
            for (int i = 0; i < queryLive.length; ++i) {
                if (!shortMemberName.equals(queryLive[i])) continue;
                return LivenessServiceXCF.isActive(queryAnswer.status[i]);
            }
            return false;
        }
        return false;
    }

    public boolean addJoinEventListener(JoinEventListener listener) {
        if (listener == null) {
            return false;
        }
        if (this.joinListener != null) {
            DiscoveryPluginLogger.dcsInternalInfo((DCSTraceContext)this, "addJoinListener()", (Exception)new DCSRuntimeException("original joinListener has been updated"));
        }
        this.joinListener = listener;
        return true;
    }

    public boolean addLeaveEventListener(LeaveEventListener listener) {
        if (listener == null) {
            return false;
        }
        if (this.leaveListener != null) {
            DiscoveryPluginLogger.dcsInternalInfo((DCSTraceContext)this, "addLeaveListener()", (Exception)new DCSRuntimeException("original leaveListener has been updatedalready exists"));
        }
        this.leaveListener = listener;
        return true;
    }

    private synchronized void executePendingActions(PendingAction action, String shortMemberName, String longMemberName, long msgNumber) {
        DiscoveryPluginLogger.dcsLogLDSEvent(this, this.getState(), "executePendingActions()", " shortMemberName=" + shortMemberName + " longMemberName=" + longMemberName);
        if (action != null) {
            this.pendingActions.add(action);
            DiscoveryPluginLogger.dcsLogLDSEvent(this, this.getState(), "executePendingActions()-pending action added ", "shortName= " + shortMemberName);
        } else {
            Vector<PendingAction> deletePendingActions = new Vector<PendingAction>();
            for (PendingAction pendAction : this.pendingActions) {
                if (!pendAction.getMemberName().equals(shortMemberName)) continue;
                if (pendAction.pendingActionIsJoin()) {
                    if (this.joinListener != null) {
                        this.joinListener.memberJoined(longMemberName, msgNumber++);
                        DiscoveryPluginLogger.dcsLogLDSEvent(this, this.getState(), "executePendingActions()-ALIVE sent from Pending Actions", "shortName= " + shortMemberName + " name= " + longMemberName);
                    }
                } else if (pendAction.pendingActionIsLeave() && this.leaveListener != null) {
                    this.leaveListener.memberLeft(longMemberName, msgNumber++, pendAction.getLeaveReason(), (long)pendAction.getLeaveRC());
                    DiscoveryPluginLogger.dcsLogLDSEvent(this, this.getState(), "executePendingActions()-DEAD sent from Pending Actions", "shortName= " + shortMemberName + " name= " + longMemberName);
                }
                deletePendingActions.add(pendAction);
            }
            for (PendingAction deletePendAction : deletePendingActions) {
                this.pendingActions.remove(deletePendAction);
            }
        }
        DiscoveryPluginLogger.dcsLogLDSEvent(this, this.getState(), "executePendingActions() exit", " shortMemberName=" + shortMemberName + " longMemberName=" + longMemberName);
    }

    public AnswerRecord queryLiveness() {
        AnswerRecord query = xcfSingleton.queryLiveness(this.shortGroupName, 0);
        DiscoveryPluginLogger.dcsLogLDSEvent(this, this.getState(), "queryLiveness()", Utils.toString((Object[])query.names) + " " + Utils.toString((int[])query.status));
        return query;
    }

    public static final LivenessPlugin getInstance(Map config2) {
        return new LivenessPluginZoS(config2);
    }

    public String getLayerName() {
        return "LDzos";
    }

    public String getMemberName() {
        return this.myName;
    }

    public String getStackName() {
        return this.groupName;
    }

    public TraceComponent getTraceComponent() {
        return this.TC;
    }
}

