/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.xcf.groupservices;

import com.ibm.ws.xcf.groupservices.AnswerRecord;
import com.ibm.ws.xcf.groupservices.LDMemberInfoListener;
import com.ibm.ws.xcf.groupservices.MemberInfoListener;
import com.ibm.ws.xcf.groupservices.XcfFascade;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GenLivenessServiceXCF
implements MemberInfoListener {
    private static final String DELIMITER = ":";
    private static GenLivenessServiceXCF instance = null;
    private static final Map<String, List> eventListeners = new Hashtable<String, List>();
    private static final Map<String, ByteBuffer> memberTokens = new Hashtable<String, ByteBuffer>();
    private static XcfFascade xcf;
    private String shortMyName = "";
    static final int ALIVE = 0;
    static final int DEAD = 1;
    static final int ALIVEALIVE = 2;
    private long context = 0L;
    private long msgNumber = 0L;
    final int genListenerNumber = 2;

    private GenLivenessServiceXCF() {
    }

    public long join(String shortGroupName, LDMemberInfoListener listener) {
        this.addEventListener(listener, shortGroupName);
        byte[] memberTokenArray = new byte[8];
        byte[] shortMemberNameArray = new byte[16];
        long rc = xcf.xcfJoin(shortGroupName, shortMemberNameArray, memberTokenArray, 2, this);
        ByteBuffer memberToken = ByteBuffer.wrap(memberTokenArray);
        ByteBuffer shortMemberName = ByteBuffer.wrap(shortMemberNameArray);
        Charset charset = Charset.forName("Cp1047");
        CharsetDecoder decoder = charset.newDecoder();
        try {
            CharBuffer cbuf = decoder.decode(shortMemberName);
            this.shortMyName = cbuf.toString();
        }
        catch (Exception e) {
            // empty catch block
        }
        String key = this.makeMemberTokenKey(shortGroupName, this.shortMyName);
        memberTokens.put(key, memberToken);
        int returnCode = XcfFascade.getReturnCode(rc);
        int reasonCode = XcfFascade.getReason(rc);
        if (returnCode == 0 || returnCode == 4 && reasonCode == 4) {
            rc = 0L;
        }
        if (rc != 0L) {
            this.removeEventListener(listener, shortGroupName);
        }
        return rc;
    }

    public long leave(boolean grace, String shortGroupName, String shortMyName, LDMemberInfoListener listener) {
        ByteBuffer memberToken = this.getMemberToken(shortGroupName, shortMyName);
        if (memberToken != null) {
            this.removeEventListener(listener, shortGroupName);
            return xcf.xcfLeave(memberToken.getLong(0));
        }
        return -1L;
    }

    private ByteBuffer getMemberToken(String shortGroupName, String shortMyName) {
        String key = this.makeMemberTokenKey(shortGroupName, shortMyName);
        return memberTokens.get(key);
    }

    private String makeMemberTokenKey(String shortGroupName, String shortMyName) {
        return shortGroupName + DELIMITER + shortMyName;
    }

    @Override
    public void notifyMemberInfo(String shortGroupName, String shortMemberName, long status) {
        List<?> listeners = this.getMemberEventListeners(shortGroupName);
        if (listeners != null) {
            ++this.context;
            for (LDMemberInfoListener listener : listeners) {
                if (listener == null) continue;
                listener.notifyMemberInfo(shortGroupName, shortMemberName, status, this.context);
            }
        }
    }

    public void notifyMemberMsg(long msgOriginatorToken, String message) {
        String[] messageSplits = message.split(";");
        Boolean reciprocate = messageSplits[0].equals("Y");
        String msgShortGroupName = messageSplits[1];
        String msgShortMemberName = messageSplits[2];
        String msgLongMemberName = messageSplits[3];
        List<?> listeners = this.getMemberEventListeners(msgShortGroupName);
        if (listeners != null) {
            ++this.msgNumber;
            for (LDMemberInfoListener listener : listeners) {
                if (listener == null) continue;
                listener.notifyMessage(msgShortGroupName, msgShortMemberName, msgLongMemberName, reciprocate, msgOriginatorToken, this.msgNumber);
            }
        }
    }

    private List<?> getMemberEventListeners(String groupName) {
        return eventListeners.get(groupName);
    }

    private void addEventListener(LDMemberInfoListener listener, String shortGroupName) {
        ArrayList<LDMemberInfoListener> listenerList = eventListeners.get(shortGroupName);
        if (listenerList == null) {
            listenerList = new ArrayList<LDMemberInfoListener>();
            eventListeners.put(shortGroupName, listenerList);
        }
        if (!listenerList.contains(listener)) {
            listenerList.add(listener);
        }
    }

    private void removeEventListener(LDMemberInfoListener listener, String shortGroupName) {
        List listenerList = eventListeners.get(shortGroupName);
        if (listenerList != null && listenerList.contains(listener)) {
            listenerList.remove(listener);
        }
    }

    public AnswerRecord queryLiveness(String groupName, int type) {
        byte[] answerArray = xcf.xcfQuery(groupName, 0);
        ByteBuffer answer = ByteBuffer.wrap(answerArray);
        return XcfFascade.convertByteBuffer2QueryAnswer(answer);
    }

    public void sendNamePairsMsgToOthers(String shortGroupName, String shortMyName, String myName, boolean reciprocate) {
        String recipToMsg = "N";
        if (reciprocate) {
            recipToMsg = "Y";
        }
        String message = recipToMsg + ";" + shortGroupName + ";" + shortMyName + ";" + myName;
        ByteBuffer memberToken = this.getMemberToken(shortGroupName, shortMyName);
        if (memberToken != null) {
            xcf.xcfSendMsgToOthers(memberToken.getLong(0), message, message.length());
        }
    }

    public void sendNamePairsMsgBack(long msgOriginatorToken, String shortGroupName, String shortMyName, String myName) {
        String recipToMsg = "N";
        String message = recipToMsg + ";" + shortGroupName + ";" + shortMyName + ";" + myName;
        ByteBuffer myMemberToken = this.getMemberToken(shortGroupName, shortMyName);
        if (myMemberToken != null) {
            xcf.xcfSendMsgToMbr(msgOriginatorToken, myMemberToken.getLong(0), message, message.length());
        }
    }

    public static final GenLivenessServiceXCF getInstance() {
        if (instance == null) {
            String CurrentBitmode = System.getProperty("com.ibm.vm.bitmode");
            int bitmode = Integer.parseInt(CurrentBitmode);
            try {
                if (bitmode == 64) {
                    System.loadLibrary("bbgorb");
                } else {
                    System.loadLibrary("bboorb");
                }
            }
            catch (UnsatisfiedLinkError unsatisfiedLinkError) {
                // empty catch block
            }
            instance = new GenLivenessServiceXCF();
            xcf = new XcfFascade();
        }
        return instance;
    }

    static int getShortStatus(long rc) {
        int event = GenLivenessServiceXCF.getRC(rc);
        int newState = GenLivenessServiceXCF.getReasonCode(rc);
        int oldState = XcfFascade.getGEPMOLD(rc);
        if (event == 1) {
            if (newState == 3) {
                if (newState == oldState) {
                    return 2;
                }
                return 0;
            }
            return 1;
        }
        if (event == 9) {
            return 0;
        }
        return 1;
    }

    public String getshortMyName() {
        return this.shortMyName;
    }

    static int getRC(long status) {
        return XcfFascade.getGEPLTYPE(status);
    }

    static int getReasonCode(long status) {
        return XcfFascade.getGEPMNEW(status);
    }

    static boolean isActive(int status) {
        return XcfFascade.convertStatus(status) == 3;
    }
}

