/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wstx.policyset;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.policyset.runtime.PolicySetConfiguration;
import com.ibm.ws.tx.WSTXVersion;
import com.ibm.ws.wspolicy.domain.Assertion;
import com.ibm.ws.wspolicy.domain.PolicyInputStreamHolder;
import com.ibm.ws.wspolicy.domain.WSPolicyAssertionProcessor;
import com.ibm.ws.wspolicy.domain.WSPolicyPreferenceResolver;
import com.ibm.ws.wstx.WSTXHelper;
import com.ibm.ws.wstx.policyset.WSTXPolicyTypeFileHelper;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.xml.namespace.QName;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WSTXWSPolicyAssertionProcessor
implements WSPolicyAssertionProcessor {
    private static final TraceComponent tc = Tr.register(WSTXWSPolicyAssertionProcessor.class, "WSTX", "com.ibm.ws.Transaction.resources.TransactionMsgs");
    private static ArrayList<QName> _supportedAssertions = new ArrayList();
    private WSPolicyPreferenceResolver _preferenceResolver = new WSTXWSPolicyPreferenceResolver();
    private HashMap<QName, WSPolicyPreferenceResolver.WSPolicyPreferenceInformationForQName> _preferenceInformationForQNames = new HashMap();
    public static QName at10Assertion = new QName(WSTXVersion.getWSATNamespace((int)0), "ATAssertion");
    public static QName at11Assertion = new QName(WSTXVersion.getWSATNamespace((int)1), "ATAssertion");
    public static QName ba10Assertion = new QName("http://schemas.xmlsoap.org/ws/2004/10/wsba", "BAAtomicOutcomeAssertion");
    public static QName ba11Assertion = new QName("http://docs.oasis-open.org/ws-tx/wsba/2006/06", "BAAtomicOutcomeAssertion");

    public WSTXWSPolicyAssertionProcessor() {
        if (!WSTXHelper.DISABLED) {
            this._preferenceInformationForQNames.put(at10Assertion, new WSTXWSPolicyPreferenceInformationForQName(true, false, 0));
            this._preferenceInformationForQNames.put(at11Assertion, new WSTXWSPolicyPreferenceInformationForQName(true, false, 1));
            this._preferenceInformationForQNames.put(ba10Assertion, new WSTXWSPolicyPreferenceInformationForQName(true, false, 0));
            this._preferenceInformationForQNames.put(ba11Assertion, new WSTXWSPolicyPreferenceInformationForQName(true, false, 1));
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "preferenceInformationForQNames", this._preferenceInformationForQNames);
            }
        }
    }

    public ArrayList<QName> getSupportedWSPolicyAssertions() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "getSupportedWSPolicyAssertions", _supportedAssertions);
        }
        return _supportedAssertions;
    }

    public ArrayList<QName> getWSPolicyAssertionsWithCombineBehaviour() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "getWSPolicyAssertionsWithCombineBehaviour", _supportedAssertions);
        }
        return _supportedAssertions;
    }

    @Override
    public Assertion combine(Assertion assertion1, Assertion assertion2) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "combine", new Object[]{assertion1, assertion2});
        }
        String ignorable = assertion1.getAttributeValue(WSTXPolicyTypeFileHelper.WSP_IGNORABLE);
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "ignorable", ignorable);
        }
        if (Boolean.valueOf(ignorable).booleanValue()) {
            String policy = assertion1.getAttributeValue(WSTXPolicyTypeFileHelper.WSAT_POLICY);
            if (policy == null) {
                policy = assertion1.getAttributeValue(WSTXPolicyTypeFileHelper.WSBA_POLICY);
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "policy", policy);
            }
            if ("never".equals(policy)) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    Tr.exit(tc, "combine", null);
                }
                return null;
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "combine", assertion2);
        }
        return assertion2;
    }

    public ArrayList<QName> getWSPolicyAssertionsWithSupportBehaviour() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "getWSPolicyAssertionsWithSupportBehaviour", _supportedAssertions);
        }
        return _supportedAssertions;
    }

    @Override
    public boolean supports(Assertion assertion, Map bindings) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "supports", new Object[]{assertion, bindings});
        }
        boolean ret = _supportedAssertions.contains(assertion.getAssertionName());
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "supports", ret);
        }
        return ret;
    }

    @Override
    public String getType() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "getType", "WSTransaction");
        }
        return "WSTransaction";
    }

    @Override
    public InputStream transformForClientConfiguration(PolicyInputStreamHolder policy, Map<String, Object> transformOptions) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "transformForClientConfiguration", new Object[]{policy, transformOptions, this});
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "transformForClientConfiguration", null);
        }
        return null;
    }

    @Override
    public PolicyInputStreamHolder transformForPublish(Map<String, Object> transformOptions) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "transformForPublish", new Object[]{transformOptions, this});
        }
        PolicyInputStreamHolder result = new PolicyInputStreamHolder();
        Properties props = null;
        PolicySetConfiguration psConfig = (PolicySetConfiguration)transformOptions.get("com.ibm.ws.wspolicy.PolicySetConfiguration");
        if (psConfig != null) {
            props = (Properties)psConfig.getPolicyTypeConfiguration("ENABLE_WSTRANSACTION");
        }
        result.setMain(WSTXPolicyTypeFileHelper.transformForPublish(props));
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "transformForPublish", result);
        }
        return result;
    }

    @Override
    public PolicyInputStreamHolder transformForClientIntersection(InputStream policy, Map<String, Object> transformOptions) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "transformForClientIntersection", new Object[]{policy, transformOptions, this});
        }
        PolicyInputStreamHolder result = new PolicyInputStreamHolder();
        result.setMain(WSTXPolicyTypeFileHelper.transformForClientIntersection(policy));
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "transformForClientIntersection", result);
        }
        return result;
    }

    @Override
    public List<Integer> getAssertionAttachPoints(QName assertionQName) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "getAssertionAttachPoints", new Object[]{assertionQName, this});
        }
        ArrayList<Integer> attachPoints = new ArrayList<Integer>();
        if (assertionQName != null) {
            if (assertionQName.equals(new QName(WSTXVersion.getWSATNamespace((int)0), "ATAssertion"))) {
                attachPoints.add(3);
            } else if (assertionQName.equals(new QName(WSTXVersion.getWSATNamespace((int)1), "ATAssertion"))) {
                attachPoints.add(3);
            } else if (assertionQName.equals(new QName("http://schemas.xmlsoap.org/ws/2004/10/wsba", "BAAtomicOutcomeAssertion"))) {
                attachPoints.add(3);
            } else if (assertionQName.equals(new QName("http://docs.oasis-open.org/ws-tx/wsba/2006/06", "BAAtomicOutcomeAssertion"))) {
                attachPoints.add(3);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "getAssertionAttachPoints", attachPoints);
        }
        return attachPoints;
    }

    @Override
    public WSPolicyPreferenceResolver getWSPolicyPreferenceResolver() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "getWSPolicyPreferenceResolver", this._preferenceResolver);
        }
        return this._preferenceResolver;
    }

    @Override
    public List<QName> getProviderVocabularyRequired() {
        return _supportedAssertions;
    }

    @Override
    public List<QName> getAssertionsWithConditionalClientCapability() {
        return _supportedAssertions;
    }

    public boolean supports(Assertion assertion) {
        return this.supports(assertion, null);
    }

    public String getPreferredPrefix(QName assertionQName) {
        if (assertionQName.getNamespaceURI().equals(WSTXVersion.getWSATNamespace((int)0))) {
            return "wsat";
        }
        if (assertionQName.getNamespaceURI().equals(WSTXVersion.getWSATNamespace((int)1))) {
            return "wsat11";
        }
        if (assertionQName.getNamespaceURI().equals("http://schemas.xmlsoap.org/ws/2004/10/wsba")) {
            return "wsba";
        }
        if (assertionQName.getNamespaceURI().equals("http://docs.oasis-open.org/ws-tx/wsba/2006/06")) {
            return "wsba11";
        }
        return null;
    }

    static {
        if (!WSTXHelper.DISABLED) {
            _supportedAssertions.add(at10Assertion);
            _supportedAssertions.add(at11Assertion);
            _supportedAssertions.add(ba10Assertion);
            _supportedAssertions.add(ba11Assertion);
        }
    }

    public class WSTXWSPolicyPreferenceInformationForQName
    implements WSPolicyPreferenceResolver.WSPolicyPreferenceInformationForQName {
        private final TraceComponent tc = Tr.register(WSTXWSPolicyPreferenceInformationForQName.class, "WSTX", "com.ibm.ws.Transaction.resources.TransactionMsgs");
        private boolean _preferredAbsent;
        private boolean _preferredWithNested;
        private int _score;

        WSTXWSPolicyPreferenceInformationForQName(boolean preferredAbsent, boolean preferredWithNested, int score) {
            if (TraceComponent.isAnyTracingEnabled() && this.tc.isDebugEnabled()) {
                Tr.debug(this.tc, "WSTXWSPolicyPreferenceInformationForQName", new Object[]{preferredAbsent, preferredWithNested, score});
            }
            this._preferredAbsent = preferredAbsent;
            this._preferredWithNested = preferredWithNested;
            this._score = score;
        }

        public boolean getPreferredAbsent() {
            if (TraceComponent.isAnyTracingEnabled() && this.tc.isDebugEnabled()) {
                Tr.debug(this.tc, "getPreferredAbsent", this._preferredAbsent);
            }
            return this._preferredAbsent;
        }

        public boolean getPreferredWithNested() {
            if (TraceComponent.isAnyTracingEnabled() && this.tc.isDebugEnabled()) {
                Tr.debug(this.tc, "getPreferredWithNested", this._preferredWithNested);
            }
            return this._preferredWithNested;
        }

        public int getScore() {
            if (TraceComponent.isAnyTracingEnabled() && this.tc.isDebugEnabled()) {
                Tr.debug(this.tc, "getScore", this._score);
            }
            return this._score;
        }

        public String toString() {
            return this._preferredAbsent + ", " + this._preferredWithNested + ", " + this._score;
        }
    }

    public class WSTXWSPolicyPreferenceResolver
    implements WSPolicyPreferenceResolver {
        private final TraceComponent tc = Tr.register(WSTXWSPolicyPreferenceResolver.class, "WSTX", "com.ibm.ws.Transaction.resources.TransactionMsgs");

        public WSPolicyPreferenceResolver.WSPolicyPreferenceInformationForQName getWSPolicyPreferenceInformationForQName(QName qname) {
            if (TraceComponent.isAnyTracingEnabled() && this.tc.isEntryEnabled()) {
                Tr.entry(this.tc, "getWSPolicyPreferenceInformationForQName", qname);
            }
            WSPolicyPreferenceResolver.WSPolicyPreferenceInformationForQName result = (WSPolicyPreferenceResolver.WSPolicyPreferenceInformationForQName)WSTXWSPolicyAssertionProcessor.this._preferenceInformationForQNames.get(qname);
            if (TraceComponent.isAnyTracingEnabled() && this.tc.isEntryEnabled()) {
                Tr.exit(this.tc, "getWSPolicyPreferenceInformationForQName", result);
            }
            return result;
        }
    }
}

