/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wstx.policyset;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.tx.config.ConfigurationProviderManager;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.tx.WSTXVersion;
import com.ibm.ws.tx.config.WASConfigurationProvider;
import com.ibm.ws.wspolicy.WSPConstants;
import com.ibm.ws.wstx.policyset.WSTXWSPolicyAssertionProcessor;
import com.ibm.ws.wstx.policyset.jaxb.org.oasis_open.docs.ws_tx.wsat._2006._06.ObjectFactory;
import com.ibm.ws.wstx.policyset.jaxb.org.w3.ns.ws_policy.All;
import com.ibm.ws.wstx.policyset.jaxb.org.w3.ns.ws_policy.ExactlyOne;
import com.ibm.ws.wstx.policyset.jaxb.org.w3.ns.ws_policy.Policy;
import com.ibm.ws.wstx.policyset.jaxb.org.xmlsoap.schemas.ws._2004._10.wsat.ATAssertion;
import com.ibm.ws.wstx.policyset.jaxb.org.xmlsoap.schemas.ws._2004._10.wsba.BAAtomicOutcomeAssertion;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.Marshaller;
import javax.xml.bind.UnmarshalException;
import javax.xml.bind.Unmarshaller;
import javax.xml.namespace.QName;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WSTXPolicyTypeFileHelper {
    private static final TraceComponent tc = Tr.register(WSTXPolicyTypeFileHelper.class, "WSTX", "com.ibm.ws.Transaction.resources.TransactionMsgs");
    public static final QName WSP_IGNORABLE = new QName("http://www.w3.org/ns/ws-policy", "Ignorable");
    private static final QName WSP_OPTIONAL = new QName("http://www.w3.org/ns/ws-policy", "Optional");
    public static final QName WSAT_POLICY = new QName("http://www.ibm.com/ws-tx/wsat/2008/02", "WSTXPolicy");
    public static final QName WSBA_POLICY = new QName("http://www.ibm.com/ws-tx/wsba/2008/02", "WSTXPolicy");
    private static final Policy supportsPolicy;

    public static boolean writePolicyType(String fileName, Properties attributes) {
        boolean traceOn = TraceComponent.isAnyTracingEnabled();
        if (traceOn && tc.isEntryEnabled()) {
            Tr.entry(tc, "writePolicyType", new Object[]{fileName, attributes});
        }
        boolean success = true;
        Policy policy = WSTXPolicyTypeFileHelper.createPolicy(attributes);
        try {
            JAXBContext jc = null;
            try {
                jc = AccessController.doPrivileged(new PrivilegedExceptionAction<JAXBContext>(){

                    @Override
                    public JAXBContext run() throws Exception {
                        return JAXBContext.newInstance((Class[])new Class[]{Policy.class});
                    }
                });
            }
            catch (PrivilegedActionException pae) {
                FFDCFilter.processException(pae, "com.ibm.ws.wstx.policyset.WSTXPolicyTypeFileHelper.writePolicyType", "91");
                if (traceOn && tc.isEntryEnabled()) {
                    Tr.exit(tc, "writePolicyType", pae);
                }
                throw pae.getException();
            }
            Marshaller policyMarshaller = jc.createMarshaller();
            policyMarshaller.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
            File policyFile = new File(fileName);
            if (!policyFile.exists() && traceOn && tc.isDebugEnabled()) {
                Tr.debug(tc, "writePolicyType", "File does not exist. Will be created: " + fileName);
            }
            FileOutputStream outputStream = new FileOutputStream(policyFile);
            policyMarshaller.marshal((Object)policy, (OutputStream)outputStream);
        }
        catch (Exception e) {
            FFDCFilter.processException(e, "com.ibm.ws.wstx.policyset.WSTXPolicyTypeFileHelper.writePolicyType", "112");
            if (traceOn && tc.isDebugEnabled()) {
                Tr.debug(tc, "writePolicyType", e);
            }
            success = false;
        }
        if (traceOn && tc.isEntryEnabled()) {
            Tr.exit(tc, "writePolicyType", success);
        }
        return success;
    }

    public static Properties readPolicyType(String fileName) throws Exception {
        boolean traceOn = TraceComponent.isAnyTracingEnabled();
        if (traceOn && tc.isEntryEnabled()) {
            Tr.entry(tc, "readPolicyType", fileName);
        }
        FileInputStream policyFileStream = null;
        try {
            File policyFile = new File(fileName);
            if (!policyFile.exists() && traceOn && tc.isDebugEnabled()) {
                Tr.debug(tc, "readPolicyType", "File does not exist: " + fileName);
            }
            policyFileStream = new FileInputStream(policyFile);
        }
        catch (Exception e) {
            FFDCFilter.processException(e, "com.ibm.ws.wstx.policyset.WSTXPolicyTypeFileHelper.readPolicyType", "145");
            if (traceOn && tc.isEntryEnabled()) {
                Tr.exit(tc, "readPolicyType", e);
            }
            throw e;
        }
        Properties result = WSTXPolicyTypeFileHelper.readPolicyType(policyFileStream);
        if (traceOn && tc.isEntryEnabled()) {
            Tr.exit(tc, "readPolicyType", result);
        }
        return result;
    }

    public static Properties readPolicyType(InputStream input) throws Exception {
        boolean traceOn = TraceComponent.isAnyTracingEnabled();
        if (traceOn && tc.isEntryEnabled()) {
            Tr.entry(tc, "readPolicyType", input);
        }
        if (traceOn && tc.isDebugEnabled()) {
            input = WSTXPolicyTypeFileHelper.traceInputStream(input);
        }
        Properties p = new Properties();
        if (input != null) {
            List<Object> alternatives = WSTXPolicyTypeFileHelper.getAlternativesFromFile(input, p);
            if (alternatives != null) {
                for (Object o : alternatives) {
                    String wstxPolicy;
                    Map<QName, String> attributes;
                    Object a;
                    if (o instanceof ATAssertion) {
                        a = (ATAssertion)o;
                        if (traceOn && tc.isDebugEnabled()) {
                            Tr.debug(tc, "_2004._10.wsat.ATAssertion", ((ATAssertion)a).getOtherAttributes());
                        }
                        attributes = ((ATAssertion)a).getOtherAttributes();
                        wstxPolicy = null;
                        if (attributes != null) {
                            wstxPolicy = attributes.get(WSAT_POLICY);
                        }
                        p.setProperty("ATAssertion", wstxPolicy != null ? wstxPolicy : "mandatory");
                        continue;
                    }
                    if (o instanceof com.ibm.ws.wstx.policyset.jaxb.org.oasis_open.docs.ws_tx.wsat._2006._06.ATAssertion) {
                        a = (com.ibm.ws.wstx.policyset.jaxb.org.oasis_open.docs.ws_tx.wsat._2006._06.ATAssertion)o;
                        if (traceOn && tc.isDebugEnabled()) {
                            Tr.debug(tc, "_2006._06.ATAssertion", ((com.ibm.ws.wstx.policyset.jaxb.org.oasis_open.docs.ws_tx.wsat._2006._06.ATAssertion)a).getOtherAttributes());
                        }
                        attributes = ((com.ibm.ws.wstx.policyset.jaxb.org.oasis_open.docs.ws_tx.wsat._2006._06.ATAssertion)a).getOtherAttributes();
                        wstxPolicy = null;
                        if (attributes != null) {
                            wstxPolicy = attributes.get(WSAT_POLICY);
                        }
                        p.setProperty("ATAssertion", wstxPolicy != null ? wstxPolicy : "mandatory");
                        continue;
                    }
                    if (o instanceof BAAtomicOutcomeAssertion) {
                        a = (BAAtomicOutcomeAssertion)o;
                        if (traceOn && tc.isDebugEnabled()) {
                            Tr.debug(tc, "_2004._10.wsba.BAAtomicOutcomeAssertion", ((BAAtomicOutcomeAssertion)a).getOtherAttributes());
                        }
                        attributes = ((BAAtomicOutcomeAssertion)a).getOtherAttributes();
                        wstxPolicy = null;
                        if (attributes != null) {
                            wstxPolicy = attributes.get(WSBA_POLICY);
                        }
                        p.setProperty("BAAtomicOutcomeAssertion", wstxPolicy != null ? wstxPolicy : "mandatory");
                        continue;
                    }
                    if (!(o instanceof com.ibm.ws.wstx.policyset.jaxb.org.oasis_open.docs.ws_tx.wsba._2006._06.BAAtomicOutcomeAssertion)) continue;
                    a = (com.ibm.ws.wstx.policyset.jaxb.org.oasis_open.docs.ws_tx.wsba._2006._06.BAAtomicOutcomeAssertion)o;
                    if (traceOn && tc.isDebugEnabled()) {
                        Tr.debug(tc, "_2006._06.BAAtomicOutcomeAssertion", ((com.ibm.ws.wstx.policyset.jaxb.org.oasis_open.docs.ws_tx.wsba._2006._06.BAAtomicOutcomeAssertion)a).getOtherAttributes());
                    }
                    attributes = ((com.ibm.ws.wstx.policyset.jaxb.org.oasis_open.docs.ws_tx.wsba._2006._06.BAAtomicOutcomeAssertion)a).getOtherAttributes();
                    wstxPolicy = null;
                    if (attributes != null) {
                        wstxPolicy = attributes.get(WSBA_POLICY);
                    }
                    p.setProperty("BAAtomicOutcomeAssertion", wstxPolicy != null ? wstxPolicy : "mandatory");
                }
            } else {
                p.setProperty("ATAssertion", "supports");
                p.setProperty("BAAtomicOutcomeAssertion", "supports");
            }
        }
        WSTXPolicyTypeFileHelper.massagePolicy(p);
        if (traceOn && tc.isEntryEnabled()) {
            Tr.exit(tc, "readPolicyType", p);
        }
        return p;
    }

    private static void massagePolicy(Properties p) {
        boolean traceOn = TraceComponent.isAnyTracingEnabled();
        if (traceOn && tc.isEntryEnabled()) {
            Tr.entry(tc, "massagePolicy", p);
        }
        if (p.getProperty("ATAssertion") == null) {
            if (p.getProperty("WSATNS") != null) {
                p.setProperty("ATAssertion", "supports");
            } else {
                p.setProperty("ATAssertion", "never");
            }
        }
        if (p.getProperty("BAAtomicOutcomeAssertion") == null) {
            if (p.getProperty("WSBANS") != null) {
                p.setProperty("BAAtomicOutcomeAssertion", "supports");
            } else {
                p.setProperty("BAAtomicOutcomeAssertion", "never");
            }
        }
        int wstxVersion = ((WASConfigurationProvider)ConfigurationProviderManager.getConfigurationProvider()).getDefaultWSTXSpecLevel();
        if (p.getProperty("WSATNS") == null) {
            p.setProperty("WSATNS", WSTXVersion.getWSATNamespace((int)wstxVersion));
        }
        if (p.getProperty("WSBANS") == null) {
            p.setProperty("WSBANS", WSTXVersion.getWSBANamespace((int)wstxVersion));
        }
        if (traceOn && tc.isEntryEnabled()) {
            Tr.exit(tc, "massagePolicy", p);
        }
    }

    private static InputStream traceInputStream(InputStream policy) {
        if (policy != null) {
            try {
                int inBytes = policy.available();
                byte[] inBuf = new byte[inBytes];
                policy.read(inBuf, 0, inBytes);
                Tr.debug(tc, "InputStream", new String(inBuf));
                if (policy instanceof ByteArrayInputStream) {
                    policy.reset();
                } else {
                    policy = new ByteArrayInputStream(inBuf);
                }
            }
            catch (IOException e) {
                FFDCFilter.processException(e, "com.ibm.ws.wstx.policyset.WSTXPolicyTypeFileHelper.traceInputStream", "273");
            }
        }
        return policy;
    }

    private static List<Object> getAlternativesFromFile(InputStream policyFileStream, Properties p) throws Exception {
        boolean traceOn = TraceComponent.isAnyTracingEnabled();
        if (traceOn && tc.isEntryEnabled()) {
            Tr.entry(tc, "getAlternativesFromFile", new Object[]{policyFileStream, p});
        }
        ArrayList<Object> result = new ArrayList<Object>();
        try {
            StreamSource ss;
            Unmarshaller um;
            JAXBElement jaxbElement;
            JAXBContext jc = null;
            try {
                jc = AccessController.doPrivileged(new PrivilegedExceptionAction<JAXBContext>(){

                    @Override
                    public JAXBContext run() throws Exception {
                        return JAXBContext.newInstance((Class[])new Class[]{Policy.class});
                    }
                });
            }
            catch (PrivilegedActionException pae) {
                throw pae.getException();
            }
            if (traceOn && tc.isDebugEnabled()) {
                Tr.debug(tc, "JAXBContext", jc);
            }
            if ((jaxbElement = (um = jc.createUnmarshaller()).unmarshal((Source)(ss = new StreamSource(policyFileStream)), Policy.class)) != null) {
                if (traceOn && tc.isDebugEnabled()) {
                    Tr.debug(tc, "getAlternativesFromFile", "JAXBElement<Policy> unmarshalled: " + jaxbElement);
                }
                Policy policy = (Policy)jaxbElement.getValue();
                if (traceOn && tc.isDebugEnabled()) {
                    Tr.debug(tc, "Policy", policy);
                }
                if (policy != null) {
                    WSTXPolicyTypeFileHelper.deduceWSTXVersions(policy, p);
                    List<ExactlyOne> exactlyOnes = policy.getExactlyOne();
                    if (traceOn && tc.isDebugEnabled()) {
                        Tr.debug(tc, "exactlyOnes", exactlyOnes);
                    }
                    for (ExactlyOne exactlyOne : exactlyOnes) {
                        List<All> alls = exactlyOne.getAll();
                        if (traceOn && tc.isDebugEnabled()) {
                            Tr.debug(tc, "alls", alls);
                        }
                        for (All all : alls) {
                            result.addAll(all.getContent());
                        }
                    }
                }
            }
        }
        catch (UnmarshalException e) {
            if (traceOn && tc.isEntryEnabled()) {
                Tr.exit(tc, "getAlternativesFromFile", null);
            }
            return null;
        }
        catch (Exception e) {
            FFDCFilter.processException(e, "com.ibm.ws.wstx.policyset.WSTXPolicyTypeFileHelper.getAlternativesFromFile", "265");
            if (traceOn && tc.isDebugEnabled()) {
                Tr.debug(tc, "getAlternativesFromFile", e);
            }
            throw e;
        }
        if (traceOn && tc.isEntryEnabled()) {
            Tr.exit(tc, "getAlternativesFromFile", result);
        }
        return result;
    }

    private static void deduceWSTXVersions(Policy policy, Properties p) {
        Map<QName, String> policyAttributes;
        String providerVocabulary;
        boolean traceOn = TraceComponent.isAnyTracingEnabled();
        if (traceOn && tc.isEntryEnabled()) {
            Tr.entry(tc, "deduceWSTXVersions", new Object[]{policy, p});
        }
        if ((providerVocabulary = (policyAttributes = policy.getOtherAttributes()).get(WSPConstants.providerVocabQName)) != null) {
            String[] namespaces;
            HashSet<QName> nsSet = new HashSet<QName>();
            for (String ns : namespaces = providerVocabulary.split(" ")) {
                nsSet.add(QName.valueOf(ns));
            }
            if (nsSet.contains(WSTXWSPolicyAssertionProcessor.at11Assertion)) {
                p.setProperty("WSATNS", WSTXWSPolicyAssertionProcessor.at11Assertion.getNamespaceURI());
            } else if (nsSet.contains(WSTXWSPolicyAssertionProcessor.at10Assertion)) {
                p.setProperty("WSATNS", WSTXWSPolicyAssertionProcessor.at10Assertion.getNamespaceURI());
            }
            if (nsSet.contains(WSTXWSPolicyAssertionProcessor.ba11Assertion)) {
                p.setProperty("WSBANS", WSTXWSPolicyAssertionProcessor.ba11Assertion.getNamespaceURI());
            } else if (nsSet.contains(WSTXWSPolicyAssertionProcessor.ba10Assertion)) {
                p.setProperty("WSBANS", WSTXWSPolicyAssertionProcessor.ba10Assertion.getNamespaceURI());
            }
        }
        if (traceOn && tc.isEntryEnabled()) {
            Tr.exit(tc, "deduceWSTXVersions", p);
        }
    }

    private static Policy createPolicy(Properties attributes) {
        boolean traceOn = TraceComponent.isAnyTracingEnabled();
        if (traceOn && tc.isEntryEnabled()) {
            Tr.entry(tc, "createPolicy", attributes);
        }
        com.ibm.ws.wstx.policyset.jaxb.org.w3.ns.ws_policy.ObjectFactory policyObjectFactory = new com.ibm.ws.wstx.policyset.jaxb.org.w3.ns.ws_policy.ObjectFactory();
        Policy policy = policyObjectFactory.createPolicy();
        if (attributes != null) {
            String assertion = attributes.getProperty("ATAssertion", "never");
            ExactlyOne eo = policyObjectFactory.createExactlyOne();
            policy.getExactlyOne().add(eo);
            All all10 = policyObjectFactory.createAll();
            eo.getAll().add(all10);
            com.ibm.ws.wstx.policyset.jaxb.org.xmlsoap.schemas.ws._2004._10.wsat.ObjectFactory at10ObjectFactory = new com.ibm.ws.wstx.policyset.jaxb.org.xmlsoap.schemas.ws._2004._10.wsat.ObjectFactory();
            ATAssertion at10Assertion = at10ObjectFactory.createATAssertion();
            at10Assertion.getOtherAttributes().put(WSP_IGNORABLE, Boolean.TRUE.toString());
            at10Assertion.getOtherAttributes().put(WSAT_POLICY, assertion);
            all10.getContent().add(at10Assertion);
            All all11 = policyObjectFactory.createAll();
            eo.getAll().add(all11);
            ObjectFactory at11ObjectFactory = new ObjectFactory();
            com.ibm.ws.wstx.policyset.jaxb.org.oasis_open.docs.ws_tx.wsat._2006._06.ATAssertion at11Assertion = at11ObjectFactory.createATAssertion();
            at11Assertion.getOtherAttributes().put(WSP_IGNORABLE, Boolean.TRUE.toString());
            at11Assertion.getOtherAttributes().put(WSAT_POLICY, assertion);
            all11.getContent().add(at11Assertion);
            assertion = attributes.getProperty("BAAtomicOutcomeAssertion", "never");
            eo = policyObjectFactory.createExactlyOne();
            policy.getExactlyOne().add(eo);
            all10 = policyObjectFactory.createAll();
            eo.getAll().add(all10);
            com.ibm.ws.wstx.policyset.jaxb.org.xmlsoap.schemas.ws._2004._10.wsba.ObjectFactory ba10ObjectFactory = new com.ibm.ws.wstx.policyset.jaxb.org.xmlsoap.schemas.ws._2004._10.wsba.ObjectFactory();
            BAAtomicOutcomeAssertion ba10Assertion = ba10ObjectFactory.createBAAtomicOutcomeAssertion();
            ba10Assertion.getOtherAttributes().put(WSP_IGNORABLE, Boolean.TRUE.toString());
            ba10Assertion.getOtherAttributes().put(WSBA_POLICY, assertion);
            all10.getContent().add(ba10Assertion);
            all11 = policyObjectFactory.createAll();
            eo.getAll().add(all11);
            com.ibm.ws.wstx.policyset.jaxb.org.oasis_open.docs.ws_tx.wsba._2006._06.ObjectFactory ba11ObjectFactory = new com.ibm.ws.wstx.policyset.jaxb.org.oasis_open.docs.ws_tx.wsba._2006._06.ObjectFactory();
            com.ibm.ws.wstx.policyset.jaxb.org.oasis_open.docs.ws_tx.wsba._2006._06.BAAtomicOutcomeAssertion ba11Assertion = ba11ObjectFactory.createBAAtomicOutcomeAssertion();
            ba11Assertion.getOtherAttributes().put(WSP_IGNORABLE, Boolean.TRUE.toString());
            ba11Assertion.getOtherAttributes().put(WSBA_POLICY, assertion);
            all11.getContent().add(ba11Assertion);
        }
        if (traceOn && tc.isEntryEnabled()) {
            Tr.exit(tc, "createPolicy", policy);
        }
        return policy;
    }

    public static InputStream transformForPublish(Properties in) {
        boolean traceOn = TraceComponent.isAnyTracingEnabled();
        if (traceOn && tc.isEntryEnabled()) {
            Tr.entry(tc, "transformForPublish", in);
        }
        if (in == null) {
            if (traceOn && tc.isEntryEnabled()) {
                Tr.exit(tc, "transformForPublish", null);
            }
            return null;
        }
        InputStream result = WSTXPolicyTypeFileHelper.writeInteroperablePolicy(in);
        if (traceOn && tc.isEntryEnabled()) {
            Tr.exit(tc, "transformForPublish", result);
        }
        return result;
    }

    private static InputStream writeInteroperablePolicy(Properties in) {
        boolean traceOn = TraceComponent.isAnyTracingEnabled();
        if (traceOn && tc.isEntryEnabled()) {
            Tr.entry(tc, "writeInteroperablePolicy", in);
        }
        Policy policy = WSTXPolicyTypeFileHelper.createInteroperablePolicy(in);
        InputStream is = WSTXPolicyTypeFileHelper.policy2InputStream(policy);
        if (traceOn && tc.isEntryEnabled()) {
            Tr.exit(tc, "writeInteroperablePolicy", is);
        }
        return is;
    }

    private static InputStream policy2InputStream(Policy policy) {
        ByteArrayInputStream result;
        boolean traceOn;
        block4: {
            traceOn = TraceComponent.isAnyTracingEnabled();
            if (traceOn && tc.isEntryEnabled()) {
                Tr.entry(tc, "policy2InputStream", policy);
            }
            result = null;
            try {
                JAXBContext jc = null;
                jc = AccessController.doPrivileged(new PrivilegedExceptionAction<JAXBContext>(){

                    @Override
                    public JAXBContext run() throws Exception {
                        return JAXBContext.newInstance((Class[])new Class[]{Policy.class});
                    }
                });
                Marshaller policyMarshaller = jc.createMarshaller();
                policyMarshaller.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
                ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
                policyMarshaller.marshal((Object)policy, (OutputStream)outputStream);
                result = new ByteArrayInputStream(outputStream.toByteArray());
            }
            catch (Exception e) {
                FFDCFilter.processException(e, "com.ibm.ws.wstx.policyset.WSTXPolicyTypeFileHelper.policy2InputStream", "457");
                if (!traceOn || !tc.isDebugEnabled()) break block4;
                Tr.debug(tc, "policy2InputStream", e);
            }
        }
        if (traceOn && tc.isEntryEnabled()) {
            Tr.exit(tc, "policy2InputStream", result);
        }
        return result;
    }

    private static Policy createInteroperablePolicy(Properties attributes) {
        boolean traceOn = TraceComponent.isAnyTracingEnabled();
        if (traceOn && tc.isEntryEnabled()) {
            Tr.entry(tc, "createPolicy", attributes);
        }
        com.ibm.ws.wstx.policyset.jaxb.org.w3.ns.ws_policy.ObjectFactory policyObjectFactory = new com.ibm.ws.wstx.policyset.jaxb.org.w3.ns.ws_policy.ObjectFactory();
        Policy policy = policyObjectFactory.createPolicy();
        if (attributes != null) {
            All all11;
            All all10;
            ExactlyOne eo;
            String assertion = attributes.getProperty("ATAssertion", "never");
            if (!"never".equals(assertion)) {
                eo = policyObjectFactory.createExactlyOne();
                policy.getExactlyOne().add(eo);
                all10 = policyObjectFactory.createAll();
                eo.getAll().add(all10);
                com.ibm.ws.wstx.policyset.jaxb.org.xmlsoap.schemas.ws._2004._10.wsat.ObjectFactory at10ObjectFactory = new com.ibm.ws.wstx.policyset.jaxb.org.xmlsoap.schemas.ws._2004._10.wsat.ObjectFactory();
                ATAssertion at10Assertion = at10ObjectFactory.createATAssertion();
                all10.getContent().add(at10Assertion);
                all11 = policyObjectFactory.createAll();
                eo.getAll().add(all11);
                ObjectFactory at11ObjectFactory = new ObjectFactory();
                com.ibm.ws.wstx.policyset.jaxb.org.oasis_open.docs.ws_tx.wsat._2006._06.ATAssertion at11Assertion = at11ObjectFactory.createATAssertion();
                all11.getContent().add(at11Assertion);
                if ("supports".equals(assertion)) {
                    at10Assertion.getOtherAttributes().put(WSP_OPTIONAL, Boolean.TRUE.toString());
                    at11Assertion.getOtherAttributes().put(WSP_OPTIONAL, Boolean.TRUE.toString());
                }
            }
            if (!"never".equals(assertion = attributes.getProperty("BAAtomicOutcomeAssertion", "never"))) {
                eo = policyObjectFactory.createExactlyOne();
                policy.getExactlyOne().add(eo);
                all10 = policyObjectFactory.createAll();
                eo.getAll().add(all10);
                com.ibm.ws.wstx.policyset.jaxb.org.xmlsoap.schemas.ws._2004._10.wsba.ObjectFactory ba10ObjectFactory = new com.ibm.ws.wstx.policyset.jaxb.org.xmlsoap.schemas.ws._2004._10.wsba.ObjectFactory();
                BAAtomicOutcomeAssertion ba10Assertion = ba10ObjectFactory.createBAAtomicOutcomeAssertion();
                all10.getContent().add(ba10Assertion);
                all11 = policyObjectFactory.createAll();
                eo.getAll().add(all11);
                com.ibm.ws.wstx.policyset.jaxb.org.oasis_open.docs.ws_tx.wsba._2006._06.ObjectFactory ba11ObjectFactory = new com.ibm.ws.wstx.policyset.jaxb.org.oasis_open.docs.ws_tx.wsba._2006._06.ObjectFactory();
                com.ibm.ws.wstx.policyset.jaxb.org.oasis_open.docs.ws_tx.wsba._2006._06.BAAtomicOutcomeAssertion ba11Assertion = ba11ObjectFactory.createBAAtomicOutcomeAssertion();
                all11.getContent().add(ba11Assertion);
                if ("supports".equals(assertion)) {
                    ba10Assertion.getOtherAttributes().put(WSP_OPTIONAL, Boolean.TRUE.toString());
                    ba11Assertion.getOtherAttributes().put(WSP_OPTIONAL, Boolean.TRUE.toString());
                }
            }
        }
        if (traceOn && tc.isEntryEnabled()) {
            Tr.exit(tc, "createPolicy", policy);
        }
        return policy;
    }

    public static InputStream transformForClientIntersection(InputStream policy) {
        boolean traceOn = TraceComponent.isAnyTracingEnabled();
        if (traceOn && tc.isEntryEnabled()) {
            Tr.entry(tc, "transformForClientIntersection", policy);
        }
        if (traceOn && tc.isDebugEnabled()) {
            policy = WSTXPolicyTypeFileHelper.traceInputStream(policy);
        }
        if (policy == null) {
            policy = WSTXPolicyTypeFileHelper.policy2InputStream(supportsPolicy);
        }
        if (traceOn && tc.isEntryEnabled()) {
            Tr.exit(tc, "transformForClientIntersection", policy);
        }
        return policy;
    }

    static {
        boolean traceOn = TraceComponent.isAnyTracingEnabled();
        if (traceOn && tc.isEntryEnabled()) {
            Tr.entry(tc, "<clinit>");
        }
        Properties supportsProps = new Properties();
        supportsProps.setProperty("ATAssertion", "supports");
        supportsProps.setProperty("BAAtomicOutcomeAssertion", "supports");
        supportsPolicy = WSTXPolicyTypeFileHelper.createPolicy(supportsProps);
        if (traceOn && tc.isEntryEnabled()) {
            Tr.exit(tc, "<clinit>");
        }
    }
}

