/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wstx.handler;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.Transaction.wstx.WSTXConstants;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.wsaddressing.jaxws.EndpointReferenceConverter;
import com.ibm.ws.wscoor.CoordinationContext;
import com.ibm.ws.wstx.WSTXHelper;
import com.ibm.ws.wstx.handler.WSATConsumer;
import com.ibm.ws.wstx.handler.WSBAConsumer;
import com.ibm.wsspi.wsaddressing.EndpointReference;
import java.util.List;
import java.util.Properties;
import javax.xml.namespace.QName;
import javax.xml.ws.WebServiceException;
import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMNamespace;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.engine.Handler;
import org.apache.axis2.handlers.AbstractHandler;

public class WSTXConsumerHandler
extends AbstractHandler {
    private static final TraceComponent tc = Tr.register(WSTXConsumerHandler.class, "WSTX", "com.ibm.ws.Transaction.resources.TransactionMsgs");
    private static final OMNamespace wsatextns = OMAbstractFactory.getOMFactory().createOMNamespace("http://www.ibm.com/ws-tx/wsat/2007/12", "wsat-ext");

    public Handler.InvocationResponse invoke(MessageContext mc) throws AxisFault {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "invoke", mc);
        }
        WSTXHelper.traceMessageContext(mc);
        try {
            switch (mc.FLOW) {
                case 1: {
                    this.handleRequest(mc);
                    break;
                }
                case 2: {
                    this.handleResponse(mc);
                    break;
                }
                case 4: {
                    this.handleFault(mc);
                    break;
                }
                default: {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug(tc, "invoke", WSTXHelper.flow(mc.FLOW));
                    }
                    break;
                }
            }
        }
        catch (Exception e) {
            FFDCFilter.processException((Throwable)e, "com.ibm.ws.wstx.handler.WSTXConsumerHandler.invoke", "75", this);
            AxisFault af = AxisFault.makeFault(e);
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "invoke", af);
            }
            throw af;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "invoke", Handler.InvocationResponse.CONTINUE);
        }
        return Handler.InvocationResponse.CONTINUE;
    }

    private void handleFault(MessageContext mc) throws AxisFault, WebServiceException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "handleFault", new Object[]{mc, this});
        }
        this.handleResponse(mc);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "handleFault");
        }
    }

    private void handleResponse(MessageContext mc) throws AxisFault, WebServiceException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "handleResponse", new Object[]{mc, this});
        }
        if (!WSTXHelper.DISABLED) {
            String mep = mc.getAxisOperation().getMessageExchangePattern();
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "MEP", mep);
            }
            if ("http://www.w3.org/2004/08/wsdl/in-out".equals(mep) || "http://www.w3.org/2006/01/wsdl/in-out".equals(mep) || "http://www.w3.org/ns/wsdl/in-out".equals(mep)) {
                Object ccFound;
                MessageContext inboundContext = mc.getOperationContext().getMessageContext("In");
                if (inboundContext != null && (ccFound = inboundContext.getProperty("COORDINATION_CONTEXT_FOUND")) != null) {
                    WSTXHelper.getSOAPHeader(mc).addHeaderBlock("imported", wsatextns);
                }
                this.doDeferredRegistration(inboundContext, mc);
                try {
                    WSBAConsumer.handleOutbound(inboundContext, mc);
                }
                catch (Exception ex) {
                    FFDCFilter.processException((Throwable)ex, "com.ibm.ws.wstx.handler.WSTXConsumerHandler.handleResponse", "104", this);
                    throw AxisFault.makeFault(ex);
                }
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "handleResponse");
        }
    }

    private void handleRequest(MessageContext mc) throws AxisFault {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "handleRequest", new Object[]{mc, this});
        }
        Properties ptc = WSTXHelper.getPolicyTypeConfig(mc, false);
        CoordinationContext wsatContext = WSATConsumer.extractContext(mc, ptc);
        List wsbaContext = WSBAConsumer.extractContext(mc, ptc);
        String mep = mc.getAxisOperation().getMessageExchangePattern();
        if ("http://www.w3.org/2004/08/wsdl/in-out".equals(mep) || "http://www.w3.org/2006/01/wsdl/in-out".equals(mep) || "http://www.w3.org/ns/wsdl/in-out".equals(mep)) {
            WSATConsumer.cacheContext(mc, wsatContext);
            WSBAConsumer.cacheContext(mc, wsbaContext);
        } else if (wsatContext != null || wsbaContext != null && !wsbaContext.isEmpty()) {
            AxisFault f = new AxisFault("Coordination Context received via unsupported message exchange pattern: " + mc.getAxisOperation().getMessageExchangePattern());
            f.setFaultCode("MustUnderstand");
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "handleRequest", f);
            }
            throw f;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "handleRequest");
        }
    }

    private void doDeferredRegistration(MessageContext inboundContext, MessageContext outboundContext) throws AxisFault, WebServiceException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "doDeferredRegistration", new Object[]{inboundContext, outboundContext, this});
        }
        EndpointReference participantEPR = null;
        if (inboundContext != null) {
            participantEPR = (EndpointReference)inboundContext.getProperty(WSTXHelper.PARTICIPANT_EPR);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "participantEPR", participantEPR);
        }
        if (participantEPR != null) {
            WSTXHelper.getSOAPHeader(outboundContext).addChild(EndpointReferenceConverter.serializeEndpointReference(participantEPR, new QName("http://wstx.Transaction.ws.ibm.com/extension", WSTXConstants.WSTX10_PARTICIPANT_REGISTRATION_ELEMENT_NAME.getLocalName(), "websphere-wsat")));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "doDeferredRegistration");
        }
    }
}

