/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wstx.handler;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.ras.TraceNLS;
import com.ibm.ws.activity.GlobalIdImpl;
import com.ibm.ws.activity.HLSInformation;
import com.ibm.ws.activity.LocalActivityContext;
import com.ibm.ws.activity.ThreadContextManager;
import com.ibm.ws.activity.remote.ActivityContextDescriptor;
import com.ibm.ws.activity.remote.ActivityContextDescriptorFactory;
import com.ibm.ws.activity.remote.DistributedActivityContext;
import com.ibm.ws.activity.remote.PropertyGroupTooLargeException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.javax.activity.ServiceInformation;
import com.ibm.ws.javax.activity.SystemException;
import com.ibm.ws.javax.activity.coordination.ServiceManager;
import com.ibm.ws.wstx.WSTXHelper;
import com.ibm.ws.wstx.activity.remote.Axis2ServerSideProcessor;
import com.ibm.ws.wstx.activity.remote.soap.Axis2ActivityContextDescriptorFactory;
import com.ibm.ws.wstx.activity.remote.soap.Axis2ActivityContextDescriptorRenderer;
import com.ibm.ws.wstx.activity.remote.soap.WSBAActivityHandlerCollaborator;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.MessageContext;

public class WSBAConsumer {
    private static final TraceComponent tc = Tr.register(WSBAConsumer.class, "WSTX", "com.ibm.ws.Transaction.resources.TransactionMsgs");
    private static final TraceNLS nls = TraceNLS.getTraceNLS("com.ibm.ws.Transaction.resources.TransactionMsgs");
    public static String ACTIVITY_DESCRIPTORS = "ActivityDescriptors";
    private static ActivityContextDescriptorFactory _factory = new Axis2ActivityContextDescriptorFactory();
    private static final int SUBORDINATE_TIMEOUT_EXTENSION = 30;

    public static boolean establishContext(MessageContext mc) throws Exception {
        List descriptorList;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "establishContext", mc);
        }
        if (mc != null && (descriptorList = (List)mc.getProperty(ACTIVITY_DESCRIPTORS)) != null) {
            if (tc.isDebugEnabled()) {
                ActivityContextDescriptor.outputDescriptorHierarchy((List)descriptorList);
            }
            try {
                Iterator descriptors = descriptorList.iterator();
                while (descriptors.hasNext()) {
                    for (ActivityContextDescriptor descriptor = (ActivityContextDescriptor)descriptors.next(); descriptor != null; descriptor = descriptor.getChild()) {
                        ServiceInformation serviceInformation;
                        DistributedActivityContext distributedContext;
                        LocalActivityContext localContext = ThreadContextManager.instance().getContextFromGlobalId(descriptor.getId());
                        if (localContext != null) {
                            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                                Tr.debug(tc, "Context " + descriptor.getId() + " is being reimported.");
                            }
                            List propertyGroupsList = descriptor.getPropertyGroups();
                            if (descriptor.representsAllAncestorNodes()) {
                                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                                    Tr.debug(tc, "HLS has indicated that descriptor represents all ancestor nodes");
                                }
                                ArrayList<LocalActivityContext> ancestorNodes = new ArrayList<LocalActivityContext>();
                                for (LocalActivityContext parentContext = localContext.getParentContext(); parentContext != null; parentContext = parentContext.getParentContext()) {
                                    ancestorNodes.add(parentContext);
                                }
                                int ancestorCount = ancestorNodes.size();
                                for (int i = ancestorCount - 1; i >= 0; --i) {
                                    ((LocalActivityContext)ancestorNodes.get(i)).getDistributedContext().reimport(propertyGroupsList);
                                }
                            }
                            localContext.getDistributedContext().reimport(propertyGroupsList);
                            descriptor.setContext(localContext);
                            continue;
                        }
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Context " + descriptor.getId() + " is being imported.");
                        }
                        List propertyGroups = descriptor.getPropertyGroups();
                        int timeout = descriptor.getTimeout();
                        if (timeout > 0) {
                            timeout = Math.min(timeout + 30, 1000000000);
                        }
                        if (!(distributedContext = new DistributedActivityContext(descriptor.getServiceName(), descriptor.getContextGroup(), descriptor.getType(), propertyGroups, new GlobalIdImpl(descriptor.getId()), timeout, descriptor.getCoordinator(), descriptor.getActivitySpecificData())).isHLSRegistered()) {
                            distributedContext.setCachedContext(descriptor);
                        }
                        localContext = distributedContext.getLocalContext();
                        descriptor.setContext(localContext);
                        ServiceManager serviceManager = distributedContext.getLocalContext().getServiceManager();
                        if (serviceManager == null || !localContext.notifyImported() || (serviceInformation = descriptor.getServiceInformation()) == null) continue;
                        serviceManager.activityImported(serviceInformation);
                    }
                }
            }
            catch (SystemException se) {
                FFDCFilter.processException(se, "com.ibm.ws.wstx.handler.WSBAConsumer.establishContext", "170");
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    Tr.exit(tc, "establishContext", (Object)se);
                }
                throw se;
            }
            catch (PropertyGroupTooLargeException pgtle) {
                FFDCFilter.processException(pgtle, "com.ibm.ws.wstx.handler.WSBAConsumer.establishContext", "176");
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    Tr.exit(tc, "establishContext", (Object)pgtle);
                }
                throw pgtle;
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "establishContext", Boolean.TRUE);
        }
        return true;
    }

    public static boolean removeContext(MessageContext mc) throws Exception {
        List descriptorList;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "removeContext", mc);
        }
        if (mc != null && (descriptorList = (List)mc.getProperty(ACTIVITY_DESCRIPTORS)) != null) {
            if (tc.isDebugEnabled()) {
                ActivityContextDescriptor.outputDescriptorHierarchy((List)descriptorList);
            }
            try {
                Axis2ServerSideProcessor.suspendAllContexts(descriptorList);
            }
            catch (SystemException se) {
                FFDCFilter.processException(se, "com.ibm.ws.wstx.handler.WSBAConsumer.removeContext", "431");
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    Tr.exit(tc, "removeContext", (Object)se);
                }
                throw se;
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "removeContext", Boolean.TRUE);
        }
        return true;
    }

    public static List extractContext(MessageContext mc, Properties ptc) throws AxisFault {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "extractContext", new Object[]{mc, ptc});
        }
        List descriptorList = null;
        if (mc != null) {
            String policy = ptc.getProperty("BAAtomicOutcomeAssertion");
            if (policy == null) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    Tr.exit(tc, "extractContext", null);
                }
                return null;
            }
            if (!WSTXHelper.DISABLED || HLSInformation.isWebServiceEnabledHLSRegistered()) {
                WSBAActivityHandlerCollaborator.inboundRequest(mc);
                try {
                    descriptorList = Axis2ServerSideProcessor.processRequest(_factory, mc);
                }
                catch (PropertyGroupTooLargeException e) {
                    FFDCFilter.processException(e, "com.ibm.ws.wstx.handler.WSBAConsumer.extractInbound", "48");
                    AxisFault af = AxisFault.makeFault(e);
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                        Tr.exit(tc, "extractContext", af);
                    }
                    throw af;
                }
                catch (SystemException e) {
                    FFDCFilter.processException(e, "com.ibm.ws.wstx.handler.WSBAConsumer.extractInbound", "58");
                    AxisFault af = AxisFault.makeFault(e);
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                        Tr.exit(tc, "extractContext", af);
                    }
                    throw af;
                }
            }
            if (WSBAConsumer.isEmpty(descriptorList) && "mandatory".equals(policy) || !WSBAConsumer.isEmpty(descriptorList) && "never".equals(policy)) {
                AxisFault af = new AxisFault(nls.getString("WTRN0127_BLOCKED_BY_POLICY_ASSERTION"));
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    Tr.exit(tc, "extractContext", af);
                }
                throw af;
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "extractContext", descriptorList);
        }
        return descriptorList;
    }

    private static boolean isEmpty(List descriptorList) {
        return descriptorList == null || descriptorList.isEmpty();
    }

    public static boolean handleOutbound(MessageContext inboundContext, MessageContext outboundContext) throws Exception {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "handleOutbound", new Object[]{inboundContext, outboundContext});
        }
        List descriptorList = null;
        if (inboundContext != null && (descriptorList = (List)inboundContext.getProperty(ACTIVITY_DESCRIPTORS)) != null && tc.isDebugEnabled()) {
            ActivityContextDescriptor.outputDescriptorHierarchy((List)descriptorList);
        }
        if (!WSBAConsumer.isEmpty(descriptorList) && outboundContext != null && HLSInformation.isWebServiceEnabledHLSRegistered()) {
            WSBAActivityHandlerCollaborator.outboundResponse(outboundContext);
            try {
                Axis2ActivityContextDescriptorRenderer renderer = new Axis2ActivityContextDescriptorRenderer(outboundContext);
                Axis2ServerSideProcessor.processReply(renderer, descriptorList);
            }
            catch (SystemException se) {
                FFDCFilter.processException(se, "com.ibm.ws.wstx.handler.WSBAConsumer.handleOutbound", "231");
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    Tr.exit(tc, "handleOutbound", (Object)se);
                }
                throw se;
            }
            catch (PropertyGroupTooLargeException pgtle) {
                FFDCFilter.processException(pgtle, "com.ibm.ws.wstx.handler.WSBAConsumer.handleOutbound", "238");
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    Tr.exit(tc, "handleOutbound", (Object)pgtle);
                }
                throw pgtle;
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "handleOutbound", Boolean.TRUE);
        }
        return true;
    }

    public static void cacheContext(MessageContext mc, List descriptorList) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "cacheContext", new Object[]{mc, descriptorList});
        }
        mc.setProperty(ACTIVITY_DESCRIPTORS, descriptorList);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "cacheContext");
        }
    }
}

