/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wstx.activity.remote.soap;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.activity.ActivityContext;
import com.ibm.ws.activity.ContextExtractor;
import com.ibm.ws.activity.HLSInformation;
import com.ibm.ws.activity.LocalActivityContext;
import com.ibm.ws.activity.remote.ActivityContextDescriptor;
import com.ibm.ws.activity.remote.ActivityContextDescriptorFactory;
import com.ibm.ws.activity.remote.PropertyGroupTooLargeException;
import com.ibm.ws.activity.remote.soap.WSActivityContextDescriptorFactory;
import com.ibm.ws.javax.activity.SystemException;
import com.ibm.ws.wstx.activity.remote.soap.Axis2ActivityContextDescriptor;
import java.util.List;
import org.apache.axiom.soap.SOAPEnvelope;
import org.apache.axiom.soap.SOAPHeader;
import org.apache.axis2.context.MessageContext;

public class Axis2ActivityContextDescriptorFactory
extends WSActivityContextDescriptorFactory
implements ActivityContextDescriptorFactory {
    private static final TraceComponent tc = Tr.register(Axis2ActivityContextDescriptorFactory.class, "WSTX", "com.ibm.ws.Transaction.resources.TransactionMsgs");

    public ActivityContextDescriptor createDescriptor(LocalActivityContext context, boolean outboundSIBWSRequest) {
        int enabled;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "createDescriptor", new Object[]{context, outboundSIBWSRequest, this});
        }
        Axis2ActivityContextDescriptor descriptor = null;
        HLSInformation hlsInformation = context.getHLSInformation();
        if (hlsInformation != null && ((enabled = hlsInformation.getWebServicePropagationEnabled()) == 1 || enabled == 2)) {
            boolean custom = enabled == 2;
            descriptor = new Axis2ActivityContextDescriptor(context, custom, outboundSIBWSRequest);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "createDescriptor", descriptor);
        }
        return descriptor;
    }

    public List extractDescriptors(Object message) throws SystemException, PropertyGroupTooLargeException {
        SOAPHeader sh;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "extractDescriptors", new Object[]{message, this});
        }
        MessageContext mc = (MessageContext)message;
        SOAPEnvelope envelope = mc.getEnvelope();
        List descriptors = null;
        if (envelope != null && (sh = envelope.getHeader()) != null) {
            descriptors = Axis2ActivityContextDescriptor.extractContextsFromSOAPHeader(sh);
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                ActivityContextDescriptor.outputDescriptorHierarchy((List)descriptors);
            }
            for (ContextExtractor contextExtractor : HLSInformation.getContextExtractors()) {
                ActivityContext extractedContext;
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "ContextExtractor", contextExtractor);
                }
                if ((extractedContext = contextExtractor.extractContext(message)) != null) {
                    this.mapForeignIds(extractedContext);
                    descriptors.add(new Axis2ActivityContextDescriptor(extractedContext));
                }
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) continue;
                Tr.debug(tc, "Extracted context", extractedContext);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "extractDescriptors", descriptors);
        }
        return descriptors;
    }
}

