/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wstx.activity.remote;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.activity.LocalActivityContext;
import com.ibm.ws.activity.ThreadContextManager;
import com.ibm.ws.activity.remote.ActivityContextDescriptor;
import com.ibm.ws.activity.remote.ActivityContextDescriptorFactory;
import com.ibm.ws.activity.remote.ActivityContextDescriptorRenderer;
import com.ibm.ws.activity.remote.DistributedActivityContext;
import com.ibm.ws.activity.remote.PropertyGroupTooLargeException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.javax.activity.SystemException;
import java.util.Iterator;
import java.util.List;

public class Axis2ServerSideProcessor {
    private static final TraceComponent tc = Tr.register(Axis2ServerSideProcessor.class, "WSTX", "com.ibm.ws.Transaction.resources.TransactionMsgs");

    public static List processRequest(ActivityContextDescriptorFactory factory, Object request) throws PropertyGroupTooLargeException, SystemException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "processRequest", new Object[]{factory, request});
        }
        List descriptorList = factory.extractDescriptors(request);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "processRequest", descriptorList);
        }
        return descriptorList;
    }

    public static void processReply(ActivityContextDescriptorRenderer renderer, List importedContextList) throws SystemException, PropertyGroupTooLargeException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "processReply", new Object[]{renderer, importedContextList});
        }
        try {
            if (importedContextList != null) {
                if (tc.isDebugEnabled()) {
                    ActivityContextDescriptor.outputDescriptorHierarchy((List)importedContextList);
                }
                if (renderer.renderingStarting()) {
                    for (ActivityContextDescriptor rootContextDescriptor : importedContextList) {
                        renderer.render(rootContextDescriptor, false);
                    }
                }
                renderer.renderingComplete();
            }
        }
        catch (SystemException se) {
            FFDCFilter.processException(se, "com.ibm.ws.activity.remote.ServerSideProcessor.processReply", "80");
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "processReply", (Object)se);
            }
            throw se;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "processReply");
        }
    }

    public static void suspendAllContexts(List importedContextList) throws SystemException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "suspendAllContexts", importedContextList);
        }
        try {
            if (importedContextList != null) {
                Iterator importedContexts = importedContextList.iterator();
                while (importedContexts.hasNext()) {
                    ActivityContextDescriptor rootContextDescriptor;
                    for (ActivityContextDescriptor contextDescriptor = rootContextDescriptor = (ActivityContextDescriptor)importedContexts.next(); contextDescriptor != null; contextDescriptor = contextDescriptor.getChild()) {
                        LocalActivityContext context = ThreadContextManager.instance().getContextFromGlobalId(contextDescriptor.getId());
                        DistributedActivityContext distributedContext = context.getDistributedContext();
                        if (distributedContext.hasNonImportedCoordinatedChild()) {
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "Context has a coordinated child - ensuring that a local coordinator exists");
                            }
                            context.getCoordinator();
                        }
                        contextDescriptor.updatePropertyGroups(false);
                    }
                    if (rootContextDescriptor.representsAllAncestorNodes()) {
                        rootContextDescriptor.getContext().getDistributedContext().cleanHierarchyFromThread();
                        continue;
                    }
                    rootContextDescriptor.getContext().getDistributedContext().cleanFromThread();
                }
            }
        }
        catch (SystemException se) {
            FFDCFilter.processException(se, "com.ibm.ws.activity.remote.ServerSideProcessor.suspendAllContexts", "279");
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "suspendAllContexts", (Object)se);
            }
            throw se;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "suspendAllContexts");
        }
    }
}

