/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wstx.activity.remote;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.ras.TraceNLS;
import com.ibm.ws.activity.ActivityService;
import com.ibm.ws.activity.ActivityTokenImpl;
import com.ibm.ws.activity.LocalActivityContext;
import com.ibm.ws.activity.PropertyGroupInfo;
import com.ibm.ws.activity.ThreadContextManager;
import com.ibm.ws.activity.remote.ActivityContextDescriptor;
import com.ibm.ws.activity.remote.ActivityContextDescriptorFactory;
import com.ibm.ws.activity.remote.DistributedActivityContext;
import com.ibm.ws.activity.remote.PropertyGroupTooLargeException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.javax.activity.InvalidActivityException;
import com.ibm.ws.javax.activity.PropertyGroupContext;
import com.ibm.ws.javax.activity.SystemException;
import com.ibm.ws.javax.activity.propertygroup.PropertyGroup;
import com.ibm.ws.javax.activity.propertygroup.PropertyGroupManager;
import com.ibm.ws.util.WSThreadLocal;
import com.ibm.ws.wstx.WSTXHelper;
import com.ibm.ws.wstx.activity.remote.soap.Axis2ActivityContextDescriptorRenderer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import org.apache.axis2.AxisFault;

public class Axis2ClientSideProcessor {
    private static final TraceComponent tc = Tr.register(Axis2ClientSideProcessor.class, "WSTX", "com.ibm.ws.Transaction.resources.TransactionMsgs");
    private static final TraceNLS nls = TraceNLS.getTraceNLS("com.ibm.ws.Transaction.resources.TransactionMsgs");
    private static WSThreadLocal<Boolean> _internalRequest = new WSThreadLocal();
    private static WSThreadLocal<List<ActivityContextDescriptor>> _exportedContexts = new WSThreadLocal();

    public static void resumeAllContexts() throws InvalidActivityException, SystemException {
        LocalActivityContext context;
        ActivityTokenImpl token;
        boolean traceOn = TraceComponent.isAnyTracingEnabled();
        if (traceOn && tc.isEntryEnabled()) {
            Tr.entry(tc, "resumeAllContexts");
        }
        if ((token = ThreadContextManager.instance().removeFromThreadActivityTokenMap()) != null && (context = token.getContext()) != null) {
            context.resume(token);
        }
        if (traceOn && tc.isEntryEnabled()) {
            Tr.exit(tc, "resumeAllContexts");
        }
    }

    public static void processRequest(ActivityContextDescriptorFactory factory, Axis2ActivityContextDescriptorRenderer renderer) throws SystemException, PropertyGroupTooLargeException, AxisFault {
        boolean traceOn = TraceComponent.isAnyTracingEnabled();
        if (traceOn && tc.isEntryEnabled()) {
            Tr.entry(tc, "processRequest", new Object[]{factory, renderer});
        }
        Axis2ClientSideProcessor.processRequest(factory, renderer, false);
        if (traceOn && tc.isEntryEnabled()) {
            Tr.exit(tc, "processRequest");
        }
    }

    public static void processRequest(ActivityContextDescriptorFactory factory, Axis2ActivityContextDescriptorRenderer renderer, boolean outboundSIBWSRequest) throws SystemException, PropertyGroupTooLargeException, AxisFault {
        boolean traceOn = TraceComponent.isAnyTracingEnabled();
        if (traceOn && tc.isEntryEnabled()) {
            Tr.entry(tc, "processRequest", new Object[]{factory, renderer, outboundSIBWSRequest});
        }
        Boolean internalRequest = _internalRequest.get();
        ArrayList<ActivityContextDescriptor> exportedContexts = new ArrayList<ActivityContextDescriptor>();
        if (internalRequest == null || !internalRequest.booleanValue()) {
            if (renderer.renderingStarting()) {
                ActivityTokenImpl token;
                Properties ptc = WSTXHelper.getPolicyTypeConfig(renderer.getMessageContext(), true);
                String policy = ptc.getProperty("BAAtomicOutcomeAssertion", "never");
                if (token == null && "mandatory".equals(policy)) {
                    renderer.renderingComplete();
                    AxisFault af = new AxisFault(nls.getString("WTRN0127_BLOCKED_BY_POLICY_ASSERTION"));
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                        Tr.exit(tc, "processRequest", af);
                    }
                    throw af;
                }
                if ("never".equals(policy)) {
                    renderer.renderingComplete();
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                        Tr.exit(tc, "processRequest");
                    }
                    return;
                }
                if (token != null) {
                    ArrayList<String> activitiesDescribed = new ArrayList<String>();
                    for (token = ThreadContextManager.instance().getRootActivityToken(); token != null; token = token.getChildToken()) {
                        LocalActivityContext localContext = token.getContext();
                        String serviceName = localContext.getServiceName();
                        if (activitiesDescribed.contains(serviceName)) continue;
                        ActivityContextDescriptor descriptor = factory.createDescriptor(localContext, outboundSIBWSRequest);
                        if (descriptor != null) {
                            renderer.render(descriptor, true);
                            exportedContexts.add(descriptor);
                            if (!outboundSIBWSRequest) {
                                for (ActivityContextDescriptor tmpDesc = descriptor; tmpDesc != null; tmpDesc = tmpDesc.getChild()) {
                                    LocalActivityContext lac = tmpDesc.getContext();
                                    if (lac == null) continue;
                                    DistributedActivityContext distributedContext = lac.getDistributedContext();
                                    distributedContext.incRequestCount();
                                }
                            }
                        }
                        activitiesDescribed.add(serviceName);
                    }
                }
            }
            renderer.renderingComplete();
        }
        if (ActivityService.instance().isServerProcess()) {
            try {
                ActivityTokenImpl allContextToken = ThreadContextManager.instance().suspendAllContexts();
                if (allContextToken != null) {
                    ThreadContextManager.instance().addToThreadActivityTokenMap(allContextToken);
                }
            }
            catch (SystemException e) {
                FFDCFilter.processException(e, "com.ibm.ws.activity.remote.ClientSideProcessor.processRequest", "96");
                if (traceOn && tc.isEntryEnabled()) {
                    Tr.exit(tc, "processRequest", (Object)e);
                }
                throw e;
            }
        }
        _exportedContexts.set(exportedContexts);
        if (traceOn && tc.isDebugEnabled()) {
            ActivityContextDescriptor.outputDescriptorHierarchy(exportedContexts);
        }
        if (traceOn && tc.isEntryEnabled()) {
            Tr.exit(tc, "processRequest");
        }
    }

    public static void processReply(ActivityContextDescriptorFactory factory, Object reply) throws InvalidActivityException, SystemException, PropertyGroupTooLargeException {
        boolean traceOn = TraceComponent.isAnyTracingEnabled();
        if (traceOn && tc.isEntryEnabled()) {
            Tr.entry(tc, "processReply", new Object[]{factory, reply});
        }
        Axis2ClientSideProcessor.processReply(factory, reply, false);
        if (traceOn && tc.isEntryEnabled()) {
            Tr.exit(tc, "processReply");
        }
    }

    public static void processReply(ActivityContextDescriptorFactory factory, Object reply, boolean outboundSIBWSRequest) throws InvalidActivityException, SystemException, PropertyGroupTooLargeException {
        Boolean internalRequest;
        boolean traceOn = TraceComponent.isAnyTracingEnabled();
        if (traceOn && tc.isEntryEnabled()) {
            Tr.entry(tc, "processReply", new Object[]{factory, reply, outboundSIBWSRequest});
        }
        Axis2ClientSideProcessor.resumeAllContexts();
        List descriptorList = null;
        if (reply != null && (descriptorList = factory.extractDescriptors(reply)) != null) {
            if (traceOn && tc.isDebugEnabled()) {
                ActivityContextDescriptor.outputDescriptorHierarchy((List)descriptorList);
            }
            Iterator descriptors = descriptorList.iterator();
            while (descriptors.hasNext()) {
                for (ActivityContextDescriptor descriptor = (ActivityContextDescriptor)descriptors.next(); descriptor != null; descriptor = descriptor.getChild()) {
                    List propertyGroupsInReply;
                    LocalActivityContext context = ThreadContextManager.instance().getContextFromGlobalId(descriptor.getId());
                    if (context == null) continue;
                    DistributedActivityContext distributedContext = context.getDistributedContext();
                    if (distributedContext.isHLSRegistered()) {
                        List propertyGroupList = descriptor.getPropertyGroups();
                        if (propertyGroupList != null) {
                            for (PropertyGroupContext propertyGroupContext : propertyGroupList) {
                                String propertyGroupName = propertyGroupContext.getPropertyGroupName();
                                PropertyGroupInfo propertyGroupInfo = context.getPropertyGroupInfo(propertyGroupContext.getPropertyGroupName());
                                if (propertyGroupInfo._demarshalResponse) {
                                    if (traceOn && tc.isDebugEnabled()) {
                                        Tr.debug(tc, "Calling PGManager " + propertyGroupName + " to demarshal PropertyGroupContext");
                                    }
                                    PropertyGroupManager manager = propertyGroupInfo._manager;
                                    PropertyGroup propertyGroup = context.getPropertyGroup(propertyGroupName);
                                    manager.unmarshalResponse(propertyGroupContext, propertyGroup);
                                    continue;
                                }
                                if (!traceOn || !tc.isDebugEnabled()) continue;
                                Tr.debug(tc, "PropertyGroupManager " + propertyGroupName + " is not configured to unmarshal responses");
                            }
                        }
                        if (distributedContext.getSuperiorCoordinatorProxy() != null || context.getCoordinatorRef() != null) continue;
                        distributedContext.setSuperiorCoordinatorProxy(descriptor.getCoordinator(), false);
                        continue;
                    }
                    ActivityContextDescriptor cachedContext = distributedContext.getCachedContext();
                    boolean contextUpdated = false;
                    if (cachedContext.getCoordinator() == null && descriptor.getCoordinator() != null) {
                        cachedContext.setCoordinator(descriptor.getCoordinator());
                        contextUpdated = true;
                    }
                    if ((propertyGroupsInReply = descriptor.getPropertyGroups()) != null && propertyGroupsInReply.size() > 0) {
                        cachedContext.setPropertyGroups(propertyGroupsInReply);
                        contextUpdated = true;
                    }
                    if (!contextUpdated) continue;
                    distributedContext.setCachedContext(cachedContext);
                }
            }
        }
        if ((internalRequest = _internalRequest.get()) == null || !internalRequest.booleanValue()) {
            List<ActivityContextDescriptor> exportedContextsList = _exportedContexts.get();
            _exportedContexts.set(null);
            if (exportedContextsList != null && !outboundSIBWSRequest) {
                Iterator<ActivityContextDescriptor> exportedContexts = exportedContextsList.iterator();
                while (exportedContexts.hasNext()) {
                    for (ActivityContextDescriptor exportedContext = exportedContexts.next(); exportedContext != null; exportedContext = exportedContext.getChild()) {
                        exportedContext.getContext().getDistributedContext().decRequestCount();
                    }
                }
            }
        }
        if (traceOn && tc.isEntryEnabled()) {
            Tr.exit(tc, "processReply");
        }
    }

    public static void setInternalRequest(Boolean internalRequest) {
        boolean traceOn = TraceComponent.isAnyTracingEnabled();
        if (traceOn && tc.isEntryEnabled()) {
            Tr.entry(tc, "setInternalRequest", internalRequest);
        }
        _internalRequest.set(internalRequest);
        if (traceOn && tc.isEntryEnabled()) {
            Tr.exit(tc, "setInternalRequest");
        }
    }
}

